/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxException;
import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.PortSpeedHelper;
import com.sun.jade.device.fcswitch.util.snmp.PrincipalSwitchHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToCIM_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToString_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.device.fcswitch.util.zones.ZoneInfo;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.snmp.SnmpStatusException;

public class SwitchDeviceReport
implements ReportGenerator {
    private Properties props;
    private static final String CIM_VERSION = "CIM 2.5";
    private String ip;
    private int portCount;
    private String wwn;
    private HashMap systemProps = null;
    private HashMap portStatProps = null;
    private HashMap portProps = null;
    private HashMap revisionProps = null;
    private HashMap sensorProps = null;
    private HashMap systemUnitProps = null;
    private SwitchWWNsnmp swSnmp = null;
    private HashMap portResult = null;
    private static final String SYSTEM_VIEW = "SystemView";
    private static final String ZONE_VIEW = "ZoneView";
    private static final String NUMBER_OF_PORTS = "connUnitNumports";
    private static final String CONNECTED_PORT_NUMBER = "connUnitLinkPortNumberX";
    private static final String DOT = ".";
    private static final String PORT_COUNT_ERROR_MESSAGE = "Error getting the number of ports.";
    private static final String SENSOR_COUNT_ERROR_MESSAGE = "Error getting the number of sensors.";
    private static final int TEN = 10;
    private static final String LOG_TAG = "Switch_Device_Report";
    private static final String DEFAULT_PORT_TYPE = "1";
    private static final String SENSOR_TYPE_FAN = "4";
    private static final String SENSOR_TYPE_TEMPERATURE = "8";
    private static final String SWITCH1GB_SENSOR_TYPE_TEMPERATURE = "2";
    private static final String SENSOR_TYPE_POWER = "5";
    private FA_Mibsnmp switchsnmp = null;
    private int noOfZones;
    private int noOfSensors;
    private Zones[] zones = null;
    private Sanbox sanbox = null;
    private boolean setNoIP;
    public static final String sccs_id = "@(#)SwitchDeviceReport.java\t1.42 08/28/03 SMI";

    public SwitchDeviceReport(Properties properties) {
        this.props = properties;
        this.ip = properties.getProperty("ip");
        if (this.ip == null) {
            this.ip = properties.getProperty("remoteIP");
            this.setNoIP = true;
        }
        this.wwn = properties.getProperty("wwn");
        try {
            this.portCount = Integer.parseInt(properties.getProperty("NumberOfPorts"));
            this.noOfSensors = Integer.parseInt(properties.getProperty("NumberOfSensors"));
        }
        catch (Exception exception) {
            this.portCount = 0;
            this.noOfSensors = 0;
        }
        this.switchsnmp = new FA_Mibsnmp(this.props);
        try {
            this.sanbox = new Sanbox(this.ip);
        }
        catch (SanboxException sanboxException) {}
    }

    public synchronized String generateReport() {
        DeviceClass deviceClass = null;
        DeviceClass deviceClass2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        DeviceClass deviceClass5 = null;
        DeviceClass deviceClass6 = null;
        Object var10_10 = null;
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        try {
            string = this.switchsnmp.resolveVarName(CONNECTED_PORT_NUMBER).getOid();
        }
        catch (SnmpStatusException snmpStatusException) {
            // empty catch block
        }
        this.systemProps = this.switchsnmp.getConnectivityProps();
        if (this.portCount == 0) {
            this.portCount = this.getNumberOfPorts();
        }
        DeviceClass deviceClass7 = this.getReport();
        DeviceClass deviceClass8 = deviceClass7.newSubInstance();
        deviceClass8.setClassName("model");
        deviceClass8.setProperty("schema", CIM_VERSION);
        deviceClass8.setProperty("view", "system");
        deviceClass8.setProperty("type", "switch");
        deviceClass8.setProperty("prefix", "StorAdeSwitch");
        deviceClass8.setProperty("package", "com.sun.jade.cim.bean");
        Report.debug.log(LOG_TAG, (Object)("Filter " + string + DOT + this.props.getProperty("wwnSnmp")));
        this.portResult = this.discoverConnectedDevice(string + DOT + this.props.getProperty("wwnSnmp"));
        string2 = this.props.getProperty("password");
        objectArray = string2 != null && !"".equals(string2) ? ZoneInfo.getQlogicZones(this.ip, string2) : ZoneInfo.getQlogicZones(this.ip);
        this.noOfZones = objectArray.length;
        Report.debug.log(LOG_TAG, (Object)("Number ofZones " + this.noOfZones));
        this.zones = new Zones[this.noOfZones];
        int n = 0;
        while (n < this.noOfZones) {
            this.zones[n] = (Zones)objectArray[n];
            ++n;
        }
        DeviceClass deviceClass9 = deviceClass8.newSubInstance();
        deviceClass9.setClassName(SYSTEM_VIEW);
        DeviceClass deviceClass10 = deviceClass9.newSubInstance();
        this.populateSwitchSystem(this.switchsnmp, this.systemProps, deviceClass10);
        DeviceClass deviceClass11 = deviceClass10.newSubInstance();
        this.populateChassisDevice(this.systemProps, deviceClass11);
        DeviceClass deviceClass12 = deviceClass10.newSubInstance();
        this.populatePhysicalPackage(this.systemProps, deviceClass12);
        if (this.portCount != 0) {
            int n2 = 1;
            while (n2 <= this.portCount) {
                this.portStatProps = this.switchsnmp.getPortStatProps(n2);
                this.portProps = this.switchsnmp.getPortProps(n2);
                deviceClass2 = deviceClass10.newSubInstance();
                this.populateFibrePort(this.portProps, this.portStatProps, deviceClass2, n2);
                deviceClass = deviceClass2.newSubInstance();
                this.populateFibreCounters(this.portProps, this.portStatProps, deviceClass, n2);
                deviceClass3 = deviceClass2.newSubInstance();
                this.populateProtocolEndPoint(this.portProps, deviceClass3, n2);
                Set set = this.portResult.entrySet();
                Iterator iterator = set.iterator();
                String string3 = null;
                int n3 = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string4 = (String)entry.getValue();
                    try {
                        n3 = Integer.parseInt(string4, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    if (n3 + 1 != n2) continue;
                    this.populateLogicalNetwork(deviceClass3, deviceClass5);
                    deviceClass4 = deviceClass3.newSubInstance();
                    string3 = (String)entry.getKey();
                    int n4 = string3.lastIndexOf(DOT);
                    string3 = string3.substring(n4);
                    HashMap hashMap = this.switchsnmp.getLinkProps(string3);
                    deviceClass4.setClassName("ProtocolEndpoint");
                    String string5 = (String)hashMap.get("connUnitLinkPortWwnY");
                    if (string5 != null) {
                        string5 = string5.substring(0, 16);
                    }
                    deviceClass4.setProperty("Name", string5);
                    deviceClass4.setProperty("NameFormat", "WWN");
                    deviceClass4.setProperty("ProtocolType", "Fibre Channel");
                }
                ++n2;
            }
            if (this.noOfZones > 0) {
                int n5 = 0;
                while (n5 < this.noOfZones) {
                    deviceClass6 = deviceClass10.newSubInstance();
                    this.populateZones(deviceClass6, this.zones[n5]);
                    this.populateZoneMember(deviceClass8, this.zones[n5]);
                    ++n5;
                }
            }
        }
        return deviceClass7.toXML();
    }

    protected String getIP() {
        return this.ip;
    }

    protected String getWWN() {
        return this.wwn;
    }

    protected String getPortWWN(HashMap hashMap, int n) {
        String string = (String)hashMap.get("connUnitPortWwn");
        if (string == null) {
            String string2 = Integer.toHexString(n);
            string = this.computePortWWN(string2);
        }
        try {
            if (string != null && string.length() > 16) {
                string = string.substring(0, 16);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return string;
    }

    private String computePortWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getWWN());
        stringBuffer.setCharAt(0, '2');
        if (string.length() > 1) {
            stringBuffer.setCharAt(2, string.charAt(0));
            stringBuffer.setCharAt(3, string.charAt(1));
            return stringBuffer.toString();
        }
        stringBuffer.setCharAt(3, string.charAt(0));
        return stringBuffer.toString();
    }

    protected void populateProtocolEndPoint(HashMap hashMap, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("ProtocolEndpoint");
        string = this.getPortWWN(hashMap, n - 1);
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    protected void populateLogicalNetwork(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = this.props.getProperty("FabricName");
        deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalNetwork");
        deviceClass2.setProperty("Name", string);
        deviceClass2.setProperty("NetworkType", "Fibre Channel");
    }

    protected HashMap discoverConnectedDevice(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip);
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties(CONNECTED_PORT_NUMBER, "connUnitLinkPortWwnX");
        hashMap = sNMPWalk.filterProperties(hashMap, string);
        return hashMap;
    }

    protected void populateSwitchSystem(FA_Mibsnmp fA_Mibsnmp, HashMap hashMap, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.getWWN());
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)hashMap.get("connUnitStatus"))));
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        string = this.props.getProperty("ipno");
        if (this.setNoIP) {
            string = "-";
        }
        deviceClass.setProperty("OtherIdentifyingInfo", string == null ? this.ip : string);
        deviceClass.setProperty("IdentifyingDescriptions", "'IP Address'");
        deviceClass.setProperty("PortCount", (String)hashMap.get(NUMBER_OF_PORTS));
        this.revisionProps = fA_Mibsnmp.getRevisionProps(4);
        deviceClass.setProperty("Flash", this.revisionProps.get("connUnitRevsRevId") == null ? "-" : (String)this.revisionProps.get("connUnitRevsRevId"));
        this.revisionProps = fA_Mibsnmp.getRevisionProps(2);
        String string2 = (String)this.revisionProps.get("connUnitRevsRevId");
        if ("<Unknown>".equalsIgnoreCase(string2)) {
            string2 = "UnKnown";
        }
        deviceClass.setProperty("HW", string2 == null ? "-" : string2);
        deviceClass.setProperty("MAC", "-");
        this.revisionProps = fA_Mibsnmp.getRevisionProps(3);
        string2 = (String)this.revisionProps.get("connUnitRevsRevId");
        deviceClass.setProperty("PROM", string2 == null ? "-" : string2);
        deviceClass.setProperty("WWN", this.getWWN());
        deviceClass.setProperty("ZoneTotal", this.noOfZones + "");
        string = (String)hashMap.get("connUnitPrincipal");
        if (string != null) {
            string = PrincipalSwitchHelper.get_FA_PrincipalSwitchAttr(string);
        }
        deviceClass.setProperty("PrincipalSwitch", string == null ? "Unknown" : string);
    }

    protected void populateFibreCounters(HashMap hashMap, HashMap hashMap2, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("DeviceStatisticalInformation");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("DeviceCreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePortEventCounters");
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(hashMap, n - 1);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        string = (String)hashMap2.get("connUnitPortStatCountLinkFailures");
        deviceClass.setProperty("LinkFails", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountPrimitiveSequenceProtocolErrors");
        deviceClass.setProperty("Prim_Seq_Errs", string == null ? "0" : string);
    }

    protected void populateFibrePort(HashMap hashMap, HashMap hashMap2, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("REF", "" + (n - 1));
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(hashMap, n - 1);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStateString((String)hashMap.get("connUnitPortState"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStateString((String)hashMap.get("connUnitPortState"))));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = (String)hashMap2.get("connUnitPortStatCountLossofSignal");
        deviceClass.setProperty("LossOfSignalCounter", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountLossofSynchronization");
        deviceClass.setProperty("LossOfSyncCounter", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountInvalidCRC");
        deviceClass.setProperty("CRCErrors", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountInvalidTxWords");
        deviceClass.setProperty("InvalidTransmissionWords", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountFramesTruncated");
        deviceClass.setProperty("FramesTooShort", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountFramesTooLong");
        deviceClass.setProperty("FramesTooLong", string == null ? "0" : string);
        string = (String)hashMap.get("connUnitPortType");
        deviceClass.setProperty("Type", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        deviceClass.setProperty("Description", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        string = (String)hashMap.get("connUnitPortSpeed");
        deviceClass.setProperty("Speed", string == null ? "0" : string);
        deviceClass.setProperty("PortOperatingSpeed", PortSpeedHelper.getPortSpeed(string));
        deviceClass.setProperty("OperatingStatus", SNMPToString_State_Status.getOperationalStateString((String)hashMap.get("connUnitPortState")));
        try {
            string = this.sanbox.getPortState(n - 1).getAdministrativeStateString();
            deviceClass.setProperty("AdministrativeStatus", string == null ? "Unknown" : string);
        }
        catch (Exception exception) {
            deviceClass.setProperty("AdministrativeStatus", "Unknown");
        }
    }

    protected void populateChassisDevice(HashMap hashMap, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("LogicalDevice");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("DeviceID", "Chassis");
        deviceClass.setProperty("Name", "chassis");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_ChassisDevice");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)hashMap.get("connUnitStatus"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStateString((String)hashMap.get("connUnitState"))));
        deviceClass.setProperty("Description", "Switch Chassis");
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = this.switchsnmp.getSystemUpTimeString();
        deviceClass.setProperty("PowerOnTime", string == null ? "-" : string);
        deviceClass.setProperty("PowerOnSeconds", this.switchsnmp.getSystemUpTime() + "");
        if (this.noOfSensors == 0) {
            this.noOfSensors = this.getNumberOfSensors();
        }
        Report.debug.log(LOG_TAG, (Object)("Number of Sensors " + this.noOfSensors));
        int n = 1;
        while (n <= this.noOfSensors) {
            DeviceClass deviceClass2;
            this.sensorProps = this.switchsnmp.getSensorProps(n);
            String string2 = (String)this.sensorProps.get("connUnitSensorType");
            if (SENSOR_TYPE_TEMPERATURE.equalsIgnoreCase(string2) || SWITCH1GB_SENSOR_TYPE_TEMPERATURE.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("TemperatureSensor");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_TemperatureSensor");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                string = (String)this.sensorProps.get("connUnitSensorMessage");
                deviceClass2.setProperty("SensorType", DEFAULT_PORT_TYPE);
                deviceClass2.setProperty("OtherSensorTypeDescription", string == null ? "Unknown" : string);
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.sensorProps.get("connUnitSensorStatus"))));
            }
            if (SENSOR_TYPE_FAN.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("Fan");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_Fan");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.sensorProps.get("connUnitSensorStatus"))));
            }
            if (SENSOR_TYPE_POWER.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("PowerSupply");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_UninterruptiblePowerSupply");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.sensorProps.get("connUnitSensorStatus"))));
            }
            ++n;
        }
    }

    protected void populatePhysicalPackage(HashMap hashMap, DeviceClass deviceClass) {
        deviceClass.setClassName("PhysicalPackage");
        deviceClass.setProperty("Tag", this.getWWN());
        deviceClass.setProperty("Name", (String)hashMap.get("connUnitProduct"));
        String string = this.props.getProperty("DeviceDisplayModel");
        deviceClass.setProperty("Manufacturer", string == null ? "Sun StorEdge network FC 2Gig switch" : string);
        string = (String)hashMap.get("connUnitSn");
        deviceClass.setProperty("SerialNumber", string == null ? "-" : string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_PhysicalPackage");
        deviceClass.setProperty("Removable", "true");
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("HotSwappable", "true");
    }

    protected DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    protected void populateZones(DeviceClass deviceClass, Zones zones) {
        deviceClass.setClassName("Zone");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", zones.getZoneName().trim());
        deviceClass.setProperty("Name", zones.getZoneName().trim());
        deviceClass.setProperty("ElementName", zones.getZoneName());
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("OtherZoneTypeDescription", zones.getZoneDescription());
        deviceClass.setProperty("Active", "true");
        deviceClass.setProperty("ProtocolType", DEFAULT_PORT_TYPE);
    }

    protected void populateZoneMember(DeviceClass deviceClass, Zones zones) {
        Object[] objectArray = zones.getMemberList();
        if (objectArray.length > 0) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ZoneMember");
            deviceClass2.setProperty("ZoneMemberType", SENSOR_TYPE_POWER);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            deviceClass3.setClassName("Collection");
            deviceClass3.setProperty("REF", zones.getZoneName().trim());
            int n = 0;
            while (n < objectArray.length) {
                String string = ((String)objectArray[n]).trim();
                if (string != null) {
                    DeviceClass deviceClass4 = deviceClass2.newSubInstance();
                    deviceClass4.setClassName("Member");
                    if (string.length() == 16) {
                        this.addWWNZoneMember(deviceClass4, string);
                    } else {
                        deviceClass4.setProperty("REF", string);
                    }
                }
                ++n;
            }
        }
    }

    private void addWWNZoneMember(DeviceClass deviceClass, String string) {
        deviceClass.setProperty("CreationClassName", "CIM_ProtocolEndpoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
        deviceClass.setAlias("ProtocolEndPoint");
    }

    protected int getNumberOfPorts() {
        int n = 0;
        if (this.systemProps == null) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
        }
        try {
            n = Integer.parseInt((String)this.systemProps.get(NUMBER_OF_PORTS));
        }
        catch (Exception exception) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
            try {
                n = Integer.parseInt((String)this.systemProps.get(NUMBER_OF_PORTS));
            }
            catch (Exception exception2) {
                Report.warning.log((Object)PORT_COUNT_ERROR_MESSAGE);
                this.getReportError(exception2);
            }
        }
        return n;
    }

    protected int getNumberOfSensors() {
        int n = 0;
        if (this.systemProps == null) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
        }
        try {
            n = Integer.parseInt((String)this.systemProps.get("connUnitNumSensors"));
        }
        catch (NumberFormatException numberFormatException) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
            try {
                n = Integer.parseInt((String)this.systemProps.get(NUMBER_OF_PORTS));
            }
            catch (NumberFormatException numberFormatException2) {
                Report.warning.log((Object)SENSOR_COUNT_ERROR_MESSAGE);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        int n = 1;
        if (stringArray.length < 1) {
            System.out.println("Usage: java -Dstorade.home=<JADE_HOME>/build/demo SwitchDeviceReport <ipAddress> <noTimes>");
        }
        try {
            try {
                properties.put("ip", stringArray[0]);
                SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[0]);
                String string = switchWWNsnmp.getWWNString();
                String string2 = switchWWNsnmp.getWWNSnmp();
                String string3 = switchWWNsnmp.getFabricName();
                properties.put("wwn", string);
                properties.put("wwnSnmp", string2);
                properties.put("FabricName", string3);
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n > 1) {
                        Thread.sleep(30000L);
                    }
                    SwitchDeviceReport switchDeviceReport = new SwitchDeviceReport(properties);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[0] + ".xml." + n2));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.println(switchDeviceReport.generateReport());
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var12_14 = null;
                SingleSnmpSession.destroySnmpSession();
                SingleSnmpSession.destroyAsyncSnmpSession();
                return;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            SingleSnmpSession.destroySnmpSession();
            SingleSnmpSession.destroyAsyncSnmpSession();
            throw throwable;
        }
        SingleSnmpSession.destroySnmpSession();
        SingleSnmpSession.destroyAsyncSnmpSession();
    }

    public static class Test
    extends UnitTest {
        public void testSwitchReportGenerator(String string) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            SwitchDeviceReport switchDeviceReport = new SwitchDeviceReport(properties);
            String string2 = new SwitchWWNsnmp(properties.getProperty("ip")).getWWNString();
            this.assertNotNull(string2);
            this.assertEquals(switchDeviceReport.getIP(), string);
        }

        public static void main(String[] stringArray) {
            new Test().testSwitchReportGenerator(stringArray[0]);
        }
    }
}

