/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.util.inband.FCGS3DataHelper;
import com.sun.jade.device.fcswitch.util.inband.InbandDataParser;
import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToCIM_State_Status;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import java.util.Properties;

public class GenericInbandSwitchDeviceReport
implements ReportGenerator {
    private Properties props;
    private int portCount;
    private String wwn;
    private String fabricName;
    private InbandDataParser ibData;
    private FCGS3DataHelper fcgs3datahelper;
    private Properties systemProps = null;
    private Properties portProps = null;
    private static final String CIM_VERSION = "CIM 2.5";
    private static final String SYSTEM_VIEW = "SystemView";
    public static final String sccs_id = "@(#)GenericInbandSwitchDeviceReport.java 1.3     03/09/12 SMI";

    public GenericInbandSwitchDeviceReport(Properties properties) {
        this.props = properties;
        this.wwn = properties.getProperty("wwn");
        this.fabricName = properties.getProperty("FabricName");
        this.fcgs3datahelper = new FCGS3DataHelper();
        this.ibData = new InbandDataParser(this.wwn);
        this.portCount = this.ibData.getNumberOfPorts();
    }

    public synchronized String generateReport() {
        DeviceClass deviceClass = null;
        DeviceClass deviceClass2 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        if (this.portCount == 0) {
            this.portCount = this.ibData.getNumberOfPorts();
        }
        DeviceClass deviceClass5 = this.getReport();
        DeviceClass deviceClass6 = deviceClass5.newSubInstance();
        deviceClass6.setClassName("model");
        deviceClass6.setProperty("schema", CIM_VERSION);
        deviceClass6.setProperty("view", "system");
        deviceClass6.setProperty("type", "switch");
        deviceClass6.setProperty("prefix", "StorAdeSwitch");
        deviceClass6.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        deviceClass7.setClassName(SYSTEM_VIEW);
        DeviceClass deviceClass8 = deviceClass7.newSubInstance();
        try {
            this.systemProps = this.ibData.getSystemProperties();
        }
        catch (Exception exception) {
            return this.getReportError(exception);
        }
        this.populateSwitchSystem(this.systemProps, deviceClass8);
        if (this.portCount != 0) {
            int n = 1;
            while (n <= this.portCount) {
                deviceClass = deviceClass8.newSubInstance();
                String string = new Integer(n - 1).toString();
                this.portProps = this.ibData.getPortProperties(string);
                this.populateFibrePort(this.portProps, deviceClass, n);
                deviceClass2 = deviceClass.newSubInstance();
                this.populateProtocolEndPoint(this.portProps, deviceClass2);
                String string2 = this.portProps.getProperty("AttachedPortWWN");
                if (string2 != null) {
                    this.populateLogicalNetwork(deviceClass2, deviceClass4);
                }
                deviceClass3 = deviceClass2.newSubInstance();
                deviceClass3.setClassName("ProtocolEndpoint");
                deviceClass3.setProperty("Name", string2);
                deviceClass3.setProperty("NameFormat", "WWN");
                deviceClass3.setProperty("ProtocolType", "Fibre Channel");
                ++n;
            }
        }
        return deviceClass5.toXML();
    }

    protected void populateSwitchSystem(Properties properties, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.wwn);
        deviceClass.setProperty("Status", "Unknown");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("OtherIdentifyingInfo", "-");
        deviceClass.setProperty("IdentifyingDescriptions", "'WWN'");
        deviceClass.setProperty("PortCount", this.portCount + "");
        string = properties.getProperty("ReleaseCode");
        deviceClass.setProperty("Flash", string == null ? "-" : string);
        deviceClass.setProperty("WWN", this.wwn);
        string = this.getPrincipalSwitchValue(this.wwn, this.fabricName);
        deviceClass.setProperty("PrincipalSwitch", string == null ? "Unknown" : string);
    }

    private String getPrincipalSwitchValue(String string, String string2) {
        try {
            if (string.equalsIgnoreCase(string2)) {
                return "Yes";
            }
        }
        catch (Exception exception) {
            return "Unknown";
        }
        return "No";
    }

    protected void populateFibrePort(Properties properties, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", "" + (n - 1));
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = properties.getProperty("WWN");
        deviceClass.setProperty("Name", string == null ? "-" : string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        string = properties.getProperty("State");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString_FE(string)));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStatusString_FE(string)));
        deviceClass.setProperty("OperatingStatus", this.fcgs3datahelper.getPortOperationalState(string));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = properties.getProperty("Type");
        deviceClass.setProperty("Type", string == null ? this.fcgs3datahelper.getPortType("0") : this.fcgs3datahelper.getPortType(string));
        deviceClass.setProperty("Description", string == null ? this.fcgs3datahelper.getPortType("0") : this.fcgs3datahelper.getPortType(string));
    }

    protected void populateProtocolEndPoint(Properties properties, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("ProtocolEndpoint");
        string = properties.getProperty("WWN");
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    protected void populateLogicalNetwork(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = this.props.getProperty("FabricName");
        deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalNetwork");
        deviceClass2.setProperty("Name", string);
        deviceClass2.setProperty("NetworkType", "Fibre Channel");
    }

    protected DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }
}

