/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class AncorDeviceReport
implements ReportGenerator {
    private Properties props;
    private String ip;
    private MFStatus status;
    private String name;
    private static final String IP = "ip";
    private Sanbox sanbox;
    private int numPorts;
    private String wwn;
    private String errorMsg;
    private String reason;
    public static final String sccs_id = "@(#)AncorDeviceReport.java\t1.7 05/02/03 SMI";

    public AncorDeviceReport(Properties properties) {
        this.props = properties;
        this.ip = properties.getProperty(IP);
        try {
            this.sanbox = new Sanbox(InetAddress.getByName(this.ip));
        }
        catch (UnknownHostException unknownHostException) {
            this.reason = "NO_CONTACT";
            this.errorMsg = "Initialization failed";
            return;
        }
        SanboxVersion sanboxVersion = this.sanbox.getVersion();
        if (sanboxVersion == null) {
            this.reason = "Lost Comm";
            this.errorMsg = "Communication protocol unknown.";
            return;
        }
        this.wwn = sanboxVersion.getWorldWideNameString();
        ChassisStatus chassisStatus = this.sanbox.getChassisStatus(0);
        this.numPorts = chassisStatus.getNumOfPorts();
    }

    public String generateReport() {
        if (this.sanbox == null) {
            return this.getReportError(new Exception("Unable to generate report"));
        }
        return this.sanbox.getXMLReport();
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    public String getName() {
        return this.wwn;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        if (stringArray.length < 1) {
            System.out.println("Usage: java AncorDeviceReport <ipAddress>");
        }
        try {
            properties.setProperty(IP, stringArray[0]);
            AncorDeviceReport ancorDeviceReport = new AncorDeviceReport(properties);
            FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[0] + ".xml"));
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(ancorDeviceReport.generateReport());
            DeviceReport deviceReport = new DeviceReport(ancorDeviceReport.generateReport());
            Collection collection = deviceReport.toBeans();
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                System.out.println("Writing to file...");
                CIMBean cIMBean = (CIMBean)iterator.next();
                printStream.println("bean # " + n++);
                printStream.println(((CIMBeanBase)cIMBean).toBeanXML() + "\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Test
    extends UnitTest {
        public void testAncorReportGenerator(String string) {
            Properties properties = new Properties();
            properties.setProperty(AncorDeviceReport.IP, string);
            AncorDeviceReport ancorDeviceReport = new AncorDeviceReport(properties);
            this.assertNotNull(ancorDeviceReport.generateReport());
        }

        public static void main(String[] stringArray) {
            new Test().testAncorReportGenerator(stringArray[0]);
        }
    }
}

