/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class Initiators
extends SanboxHeader {
    private static final String sccs_id = "@(#)Initiators.java\t1.5 10/08/01 SMI";
    static VariableDefinition[] request = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("sl_loop_num", 2), new VariableDefinition("reserved", 1, 2)};
    public static final int UT_CONFIG_MGMT_MSG = 48;
    public static final int CFG_SL_INITIATORS_REQ = 97;
    public static final int MAX_INITIATOR_ENTRIES = 16;
    static VariableDefinition[] reply = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("sl_loop_num", 2), new VariableDefinition("entry_count", 1), new VariableDefinition("reserved", 1), new VariableDefinition("port_num", 1, 16), new VariableDefinition("al_pa", 1, 16), new VariableDefinition("public_addr", 4, 16), new VariableDefinition("node_name", 8, 16), new VariableDefinition("port_name", 8, 16)};
    private int entryCount;

    public static byte[] getInitiatorsRequest(int n) {
        SanboxHeader sanboxHeader = new SanboxHeader(request);
        DataBlock dataBlock = sanboxHeader.getBlock();
        sanboxHeader.setCommand(48);
        dataBlock.setVariable("sub_cmd", 97L);
        dataBlock.setVariable("sl_loop_num", n);
        return sanboxHeader.getBytes();
    }

    public Initiators(int n) {
        super(request);
        this.setCommand(48);
        this.block.setVariable("sub_cmd", 97L);
        this.block.setVariable("sl_loop_num", n);
    }

    public Initiators(byte[] byArray) {
        super(reply);
        this.block.useData(byArray);
        this.entryCount = (int)this.block.getVariableValue("entry_count");
    }

    public int getSegmentedLoopNum() {
        return (int)this.block.getVariableValue("sl_loop_num");
    }

    public int getNumInitiators() {
        return this.entryCount;
    }

    public int getPortNum(int n) {
        if (n < 0 || n >= this.entryCount) {
            throw new IndexOutOfBoundsException();
        }
        return (int)this.block.getVariableValue("port_num", n);
    }

    public int getAlPa(int n) {
        if (n < 0 || n >= this.entryCount) {
            throw new IndexOutOfBoundsException();
        }
        return (int)this.block.getVariableValue("al_pa", n);
    }

    public int getPublicAddress(int n) {
        if (n < 0 || n >= this.entryCount) {
            throw new IndexOutOfBoundsException();
        }
        return (int)this.block.getVariableValue("public_addr", n);
    }

    public long getNodeName(int n) {
        if (n < 0 || n >= this.entryCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.block.getVariableValue("node_name", n);
    }

    public long getPortName(int n) {
        if (n < 0 || n >= this.entryCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.block.getVariableValue("port_name", n);
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            Initiators initiators = new Initiators(byArray);
            this.assertNotNull(initiators);
        }
    }
}

