/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxException;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Arrays;

public class DataBlock {
    private static final String sccs_id = "@(#)DataBlock.java\t1.6 04/04/02 SMI";
    VariableDefinition[] vars;
    byte[] blockData;
    int blockSize;
    int location;
    long readValue;
    boolean doSwap;

    public DataBlock(VariableDefinition[] variableDefinitionArray) {
        this.vars = variableDefinitionArray;
        this.setUpDataBlock();
    }

    public DataBlock(int n) {
        this.vars = new VariableDefinition[n];
    }

    public DataBlock(VariableDefinition[] variableDefinitionArray, VariableDefinition[] variableDefinitionArray2) {
        this.vars = new VariableDefinition[variableDefinitionArray.length + variableDefinitionArray2.length];
        int n = 0;
        int n2 = 0;
        while (n < variableDefinitionArray.length) {
            this.vars[n2] = variableDefinitionArray[n];
            ++n;
            ++n2;
        }
        n = 0;
        while (n < variableDefinitionArray2.length) {
            this.vars[n2] = variableDefinitionArray2[n];
            ++n;
            ++n2;
        }
        this.setUpDataBlock();
    }

    public void setDefinition(VariableDefinition[] variableDefinitionArray, int n) {
        int n2 = 0;
        while (n2 < variableDefinitionArray.length) {
            this.vars[n++] = variableDefinitionArray[n2];
            ++n2;
        }
    }

    public void setDefinition(VariableDefinition variableDefinition, int n) {
        this.vars[n] = variableDefinition;
    }

    public void setUpDataBlock() {
        int n = 0;
        while (n < this.vars.length) {
            int n2 = this.vars[n].getNumBytes();
            this.blockSize += n2 * this.vars[n].getArraySize();
            ++n;
        }
        this.blockData = new byte[this.blockSize];
    }

    public void setVariable(String string, long l, int n) {
        VariableDefinition variableDefinition = this.getVariable(string);
        if (variableDefinition == null) {
            throw new SanboxException("No variable called " + string);
        }
        if (n < 0 || n >= variableDefinition.getArraySize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = variableDefinition.getNumBytes();
        this.location += n2 * n;
        int n3 = 0;
        while (n3 < n2) {
            long l2 = l >> 8 * n3 & 0xFFL;
            if (this.doSwap) {
                this.blockData[this.location + n3] = (byte)l2;
            } else {
                this.blockData[this.location + n2 - 1 - n3] = (byte)l2;
            }
            ++n3;
        }
    }

    public void setVariable(String string, long l) {
        VariableDefinition variableDefinition = this.getVariable(string);
        if (variableDefinition == null) {
            throw new SanboxException("No variable called " + string);
        }
        int n = variableDefinition.getNumBytes();
        int n2 = 0;
        while (n2 < n) {
            long l2 = l >> 8 * n2 & 0xFFL;
            if (this.doSwap) {
                this.blockData[this.location + n2] = (byte)l2;
            } else {
                this.blockData[this.location + n - 1 - n2] = (byte)l2;
            }
            ++n2;
        }
    }

    private long getValue(int n) {
        long l;
        long l2 = 0L;
        int n2 = 0;
        while (n2 < n) {
            l = this.doSwap ? (long)this.blockData[this.location + n2] : (long)this.blockData[this.location + n - 1 - n2];
            l2 |= (l &= 0xFFL) << n2 * 8;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 8) {
            l = l2 >> n3 * 8;
            l &= 0xFFL;
            ++n3;
        }
        return l2;
    }

    private byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.blockData, this.location, byArray, 0, n);
        return byArray;
    }

    public long getVariableValue(String string) {
        VariableDefinition variableDefinition = this.getVariable(string);
        if (variableDefinition == null) {
            throw new SanboxException("No variable called " + string);
        }
        if (variableDefinition.getNumBytes() > 8) {
            return -1L;
        }
        return this.getValue(variableDefinition.getNumBytes());
    }

    public long getVariableValue(String string, int n) {
        long l = 0L;
        VariableDefinition variableDefinition = this.getVariable(string);
        if (variableDefinition == null) {
            throw new SanboxException("No variable called " + string);
        }
        if (n < 0 || n >= variableDefinition.getArraySize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (variableDefinition.getNumBytes() > 8) {
            return -1L;
        }
        int n2 = variableDefinition.getNumBytes();
        this.location += n2 * n;
        return this.getValue(n2);
    }

    public byte[] getVariableBytes(String string) {
        VariableDefinition variableDefinition = this.getVariable(string);
        if (variableDefinition == null) {
            throw new SanboxException("No variable called " + string);
        }
        int n = variableDefinition.getNumBytes();
        return this.getBytes(n);
    }

    public byte[] getVariableBytes(String string, int n) {
        VariableDefinition variableDefinition = this.getVariable(string);
        if (variableDefinition == null) {
            throw new SanboxException("No variable called " + string);
        }
        if (n < 0 || n >= variableDefinition.getArraySize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = variableDefinition.getNumBytes();
        this.location += n2 * n;
        return this.getBytes(n2);
    }

    public VariableDefinition getVariable(String string) {
        this.location = 0;
        int n = 0;
        while (n < this.vars.length) {
            if (string.equals(this.vars[n].getName())) {
                return this.vars[n];
            }
            this.location += this.vars[n].getNumBytes() * this.vars[n].getArraySize();
            ++n;
        }
        return null;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public byte[] getBlockData() {
        return this.blockData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.vars.length) {
            long l;
            int n2 = this.vars[n].getArraySize();
            if (n2 > 1) {
                stringBuffer.append(this.vars[n].getName());
                stringBuffer.append(" = [ ");
                int n3 = 0;
                while (n3 < n2) {
                    l = this.getVariableValue(this.vars[n].getName(), n3);
                    stringBuffer.append(l);
                    stringBuffer.append(" ");
                    ++n3;
                }
                stringBuffer.append("]\n");
            } else {
                l = this.getVariableValue(this.vars[n].getName());
                stringBuffer.append(this.vars[n].getName());
                stringBuffer.append(" = ");
                stringBuffer.append(l);
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void useData(byte[] byArray) {
        int n = byArray.length;
        if (n > this.blockData.length) {
            n = this.blockData.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.blockData[n2] = byArray[n2];
            ++n2;
        }
    }

    public long getCheckSum() {
        long l = 0L;
        int n = 0;
        while (n < this.blockData.length) {
            long l2 = this.blockData[n];
            l += (l2 &= 0xFFL);
            ++n;
        }
        return l;
    }

    public static class Test
    extends UnitTest {
        public void test() {
            VariableDefinition[] variableDefinitionArray = new VariableDefinition[]{new VariableDefinition("data1", 4), new VariableDefinition("data2", 4), new VariableDefinition("data3", 1), new VariableDefinition("data4", 1), new VariableDefinition("data5", 1, 2), new VariableDefinition("data6", 16), new VariableDefinition("data7", 16, 4), new VariableDefinition("data8", 4)};
            byte[] byArray = new byte[100];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            boolean bl = true;
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            System.arraycopy(byArray, 12, byArray2, 0, 16);
            System.arraycopy(byArray, 44, byArray3, 0, 16);
            DataBlock dataBlock = new DataBlock(variableDefinitionArray);
            DataBlock dataBlock2 = new DataBlock(variableDefinitionArray, variableDefinitionArray);
            this.assertNotNull(dataBlock.vars);
            this.assertNotNull(dataBlock2.vars);
            this.assertNotNull(dataBlock.toString());
            try {
                dataBlock2.setVariable("data1", 1L);
                dataBlock2.setVariable("data5", 1L, 1);
                dataBlock2.getCheckSum();
            }
            catch (Exception exception) {
                bl = false;
            }
            this.assertCondition(bl);
            this.assertCondition(dataBlock.getVariable("data7").getNumBytes() == new VariableDefinition("data7", 16, 4).getNumBytes());
            dataBlock.useData(byArray);
            this.assertCondition(dataBlock.getVariableValue("data3") == (long)byArray[8]);
            this.assertCondition(dataBlock.getVariableValue("data5", 0) == (long)byArray[10]);
            this.assertCondition(Arrays.equals(dataBlock.getVariableBytes("data6"), byArray2));
            this.assertCondition(Arrays.equals(dataBlock.getVariableBytes("data7", 1), byArray3));
        }
    }
}

