/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.hba.sun.io;

import com.sun.jade.device.hba.sun.io.Token;
import com.sun.jade.device.hba.sun.io.TokenListException;
import com.sun.jade.device.util.DeviceProperties;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Vector;

public class TokenList
implements DeviceProperties {
    private static final String sccs_id = "@(#)TokenList.java 1.0 05/22/02 SMI";
    Vector list;

    public TokenList(String string) {
        Vector<Token> vector = new Vector<Token>();
        int n = 0;
        int n2 = 0;
        try {
            n2 = string.indexOf("\n");
            String string2 = string.substring(0, n2);
            if (string2.indexOf("<pre>") != -1) {
                n = n2 + 1;
                while (true) {
                    Token token;
                    if ((token = new Token(string.substring(n, n2 = string.indexOf("\n", n)))).getElementID() != null) {
                        vector.add(token);
                    }
                    n = n2 + 1;
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        this.list = vector;
    }

    public TokenList(Vector vector) {
        this.list = vector;
    }

    public Token findToken(String string) {
        if (this.list == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            Token token = (Token)this.list.get(n);
            if (string.equals(token.getPropertyKey())) {
                return token;
            }
            ++n;
        }
        return null;
    }

    public Token findToken(String string, String string2) {
        if (this.list == null || string == null || string2 == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            Token token = (Token)this.list.get(n);
            if (string2.equals(token.getPropertyKey()) && string.equals(token.getElementID())) {
                return token;
            }
            ++n;
        }
        return null;
    }

    public String getStringValue(String string) {
        Token token = this.findToken(string);
        if (token == null) {
            return null;
        }
        return token.getPropertyValue();
    }

    public String getStringValue(String string, String string2) {
        Token token = this.findToken(string, string2);
        if (token == null) {
            return null;
        }
        return token.getPropertyValue();
    }

    public int getIntValue(String string, String string2) {
        Token token = this.findToken(string, string2);
        if (token == null) {
            throw new IllegalArgumentException();
        }
        Integer n = new Integer(token.getPropertyValue());
        return n;
    }

    public int getIntValue(String string) {
        Token token = this.findToken(string);
        if (token == null) {
            throw new IllegalArgumentException();
        }
        Integer n = new Integer(token.getPropertyValue());
        return n;
    }

    public float getFloatValue(String string) {
        Token token = this.findToken(string);
        if (token == null) {
            throw new IllegalArgumentException();
        }
        Float f = new Float(token.getPropertyValue());
        return f.floatValue();
    }

    public float getFloatValue(String string, String string2) {
        Token token = Token.findToken(this.list, string, string2);
        if (token == null) {
            throw new IllegalArgumentException();
        }
        Float f = new Float(token.getPropertyValue());
        return f.floatValue();
    }

    public boolean assertCondition(String string, String string2, String string3) throws TokenListException {
        Token token = Token.findToken(this.list, string, string2);
        if (token == null) {
            throw new TokenListException("No Token Found", string + "," + string2);
        }
        return token.getPropertyValue().equals(string3);
    }

    public boolean assertCondition(String string, String string2) throws TokenListException {
        Token token = Token.findToken(this.list, string);
        if (token == null) {
            throw new TokenListException("token.exception.noToken", string);
        }
        return token.getPropertyValue().equals(string2);
    }

    public static class Test
    extends UnitTest {
        public void test() throws TokenListException {
            String string = "<pre>\na.b.c\t5\nd.e.f\t6\n";
            TokenList tokenList = new TokenList(string);
            this.assertCondition(tokenList.assertCondition("a.b", "c", "5"));
            this.assertCondition(tokenList.assertCondition("f", "6"));
            this.assertCondition(tokenList.getIntValue("f") == 6);
            this.assertEquals(tokenList.findToken("none"), null);
        }
    }
}

