/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.util.unittest.UnitTest;

public class CIMStateStatusHelper {
    private static final String ONLINE = "online";
    private static final String OFFLINE = "offline";
    private static final String FAILED = "failed";
    private static final String WARNING = "warning";
    private static final String OK = "ok";
    private static final String UNUSED = "Unused";
    public static final String sccs_id = "@(#)CIMStateStatusHelper.java\t1.5 05/02/03 SMI";

    public static String convertToCIMStatus(String string) {
        String string2;
        block5: {
            string2 = "Unknown";
            try {
                if (string.equalsIgnoreCase(OK) || string.equalsIgnoreCase(ONLINE) || string.equalsIgnoreCase(OFFLINE) || string.equalsIgnoreCase(UNUSED)) {
                    string2 = "OK";
                    break block5;
                }
                if (string.equalsIgnoreCase(FAILED)) {
                    string2 = "Error";
                    break block5;
                }
                if (string.equalsIgnoreCase(WARNING)) {
                    string2 = "Degraded";
                    break block5;
                }
                string2 = "Unknown";
            }
            catch (NullPointerException nullPointerException) {}
        }
        return string2;
    }

    public static String convertToCIMAvailability(String string) {
        int n = 2;
        try {
            if (string.equalsIgnoreCase(ONLINE) || string.equalsIgnoreCase(OK)) {
                n = 3;
            } else if (string.equalsIgnoreCase(OFFLINE) || string.equalsIgnoreCase(UNUSED)) {
                n = 8;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string2 = Integer.toString(n);
        return string2;
    }

    public static class Test
    extends UnitTest {
        public void testAvailability() {
            this.assertEquals(new Integer(CIMStateStatusHelper.convertToCIMAvailability(CIMStateStatusHelper.ONLINE)), new Integer(3));
            this.assertEquals(new Integer(CIMStateStatusHelper.convertToCIMAvailability(CIMStateStatusHelper.OK)), new Integer(3));
            this.assertEquals(new Integer(CIMStateStatusHelper.convertToCIMAvailability(CIMStateStatusHelper.OFFLINE)), new Integer(8));
            this.assertEquals(new Integer(CIMStateStatusHelper.convertToCIMAvailability("earth")), new Integer(2));
        }

        public void testStatus() {
            this.assertEquals(CIMStateStatusHelper.convertToCIMStatus(CIMStateStatusHelper.ONLINE), "OK");
            this.assertEquals(CIMStateStatusHelper.convertToCIMStatus(CIMStateStatusHelper.FAILED), "Error");
            this.assertEquals(CIMStateStatusHelper.convertToCIMStatus("moon"), "Unknown");
        }
    }
}

