/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.inband;

import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AgentStore;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class InbandDataParser {
    private DeviceClass dc;
    private Hashtable portProperties;
    private Properties systemProperties;
    private HashSet switchOnlinePortWWN;
    private static final String PORT = "IE.PORT";
    private static final String TOPOLOGY = "IE.TOPOLOGY";
    private static final String SYSTEM = "IE.ASSET";
    private static final String ATTACHED_PORT = "ATTACHED.PORT";
    public static final String sccs_id = "@(#)InbandDataParser.java 1.3     03/09/12 SMI";

    public InbandDataParser(String string) {
        AgentStore agentStore = new AgentStore();
        this.portProperties = new Hashtable();
        this.switchOnlinePortWWN = new HashSet();
        Iterator iterator = agentStore.getTarget(string);
        if (iterator != null && iterator.hasNext()) {
            this.dc = (DeviceClass)iterator.next();
            Iterator iterator2 = this.dc.getChildren();
            if (iterator2 != null && iterator2.hasNext()) {
                this.dc = (DeviceClass)iterator2.next();
                if (this.dc != null) {
                    this.parseDeviceClass(this.dc);
                }
            }
        }
    }

    private InbandDataParser(DeviceClass deviceClass) {
        this.portProperties = new Hashtable();
        this.switchOnlinePortWWN = new HashSet();
        Iterator iterator = deviceClass.getChildren();
        if (iterator != null && iterator.hasNext() && (deviceClass = (DeviceClass)iterator.next()) != null) {
            this.parseDeviceClass(deviceClass);
        }
    }

    private void parseDeviceClass(DeviceClass deviceClass) {
        block3: {
            String string;
            block2: {
                string = deviceClass.getClassName();
                if (!SYSTEM.equalsIgnoreCase(string)) break block2;
                this.setSystemProperties(deviceClass.getProperties());
                Iterator iterator = deviceClass.getChildren();
                while (iterator != null && iterator.hasNext()) {
                    DeviceClass deviceClass2 = (DeviceClass)iterator.next();
                    if (deviceClass2 == null) continue;
                    this.parseDeviceClass(deviceClass2);
                }
                break block3;
            }
            if (!TOPOLOGY.equalsIgnoreCase(string)) break block3;
            Iterator iterator = deviceClass.getChildren();
            while (iterator != null && iterator.hasNext()) {
                DeviceClass deviceClass3 = (DeviceClass)iterator.next();
                if (deviceClass3 == null) continue;
                this.parsePortDeviceClass(deviceClass3);
            }
        }
    }

    private void parsePortDeviceClass(DeviceClass deviceClass) {
        String string = deviceClass.getClassName();
        if (PORT.equalsIgnoreCase(string)) {
            Properties properties = deviceClass.getProperties();
            Iterator iterator = deviceClass.getChildren();
            if (iterator != null && iterator.hasNext()) {
                DeviceClass deviceClass2 = (DeviceClass)iterator.next();
                String string2 = deviceClass2.getProperty("WWN");
                this.setOnlinePortWWN(properties);
                if (string2 != null) {
                    properties.setProperty("AttachedPortWWN", string2);
                }
            }
            this.setPortProperties(properties);
        }
    }

    private void setPortProperties(Properties properties) {
        String string;
        if (properties != null && (string = properties.getProperty("PhysicalPortNumber")) != null) {
            this.portProperties.put(string, properties);
        }
    }

    private void setOnlinePortWWN(Properties properties) {
        String string;
        if (properties != null && (string = properties.getProperty("WWN")) != null) {
            this.switchOnlinePortWWN.add(string);
        }
    }

    private void setSystemProperties(Properties properties) {
        this.systemProperties = properties;
    }

    public Properties getPortProperties(String string) {
        Properties properties = null;
        try {
            properties = (Properties)this.portProperties.get(string);
        }
        catch (Exception exception) {
            properties = new Properties();
            properties.setProperty("PhysicalPortNumber", string);
        }
        return properties;
    }

    public int getNumberOfPorts() {
        return this.portProperties.size();
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Iterator getSwitchOnlinePortWWN() {
        return this.switchOnlinePortWWN.iterator();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            DeviceClass deviceClass = new DeviceClass("raclient.ieasset");
            DeviceClass deviceClass2 = deviceClass.newSubInstance(InbandDataParser.SYSTEM);
            deviceClass2.setProperty("LogicalName", "brocade123");
            deviceClass2.setProperty("WWN", "10000000000000012");
            DeviceClass deviceClass3 = deviceClass2.newSubInstance("MGMT.ADDRESS");
            deviceClass3.setProperty("Address", "foo.bar.bar1.xx");
            DeviceClass deviceClass4 = deviceClass2.newSubInstance(InbandDataParser.TOPOLOGY);
            deviceClass4.setProperty("WWN", "10000000000000012");
            DeviceClass deviceClass5 = deviceClass4.newSubInstance(InbandDataParser.PORT);
            deviceClass5.setProperty("PhysicalPortNumber", "1");
            deviceClass5.setProperty("WWN", "2001000000000012");
            deviceClass5.setProperty("State", "2");
            deviceClass5.setProperty("Type", "0");
            DeviceClass deviceClass6 = deviceClass4.newSubInstance(InbandDataParser.PORT);
            deviceClass6.setProperty("PhysicalPortNumber", "2");
            deviceClass6.setProperty("WWN", "2002000000000012");
            deviceClass6.setProperty("State", "1");
            deviceClass6.setProperty("Type", "129");
            DeviceClass deviceClass7 = deviceClass6.newSubInstance(InbandDataParser.ATTACHED_PORT);
            deviceClass7.setProperty("WWN", "5002000000000012");
            deviceClass7.setProperty("Type", "132");
            InbandDataParser inbandDataParser = new InbandDataParser(deviceClass);
            Properties properties = inbandDataParser.getPortProperties("1");
            this.assertEquals("1", properties.getProperty("PhysicalPortNumber"));
            this.assertEquals("2001000000000012", properties.getProperty("WWN"));
            this.assertEquals("2", properties.getProperty("State"));
            Properties properties2 = inbandDataParser.getPortProperties("2");
            this.assertEquals("2", properties2.getProperty("PhysicalPortNumber"));
            this.assertEquals("2002000000000012", properties2.getProperty("WWN"));
            this.assertEquals("1", properties2.getProperty("State"));
            this.assertEquals("5002000000000012", properties2.getProperty("AttachedPortWWN"));
            Properties properties3 = inbandDataParser.getSystemProperties();
            this.assertEquals("brocade123", properties3.getProperty("LogicalName"));
            this.assertEquals("10000000000000012", properties3.getProperty("WWN"));
            this.assertEquals(new Integer(2), new Integer(inbandDataParser.getNumberOfPorts()));
            Iterator iterator = inbandDataParser.getSwitchOnlinePortWWN();
            while (iterator.hasNext()) {
                this.assertEquals("2002000000000012", (String)iterator.next());
            }
        }
    }
}

