/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.util.unittest.UnitTest;

public class SwitchModel {
    public static final String CONFIG_TYPE = "switch";
    public static final String CIM_CLASS_NAME = "StorAdeSwitch_UnitaryComputerSystem";
    public static final String PORT_CLASS = "StorAdeSwitch_FibrePort";
    public static final String CHASSIS_CLASS = "StorAdeSwitch_ChassisDevice";
    public static final String BROCADE_SWITCH = "Brocade SilkWorm FC Switch";
    public static final String MCDATA_SWITCH = "McData Enterprise Director FC Switch";
    public static final String QLOGIC_SUN1GB_SWITCH = "Sun StorEdge network FC switch";
    public static final String QLOGIC_SUN1GB_SWITCH_UPDATEDFW = "Sun StorEdge network FC switch (with updated 2Gig firmware)";
    public static final String QLOGIC_SUN2GB_SWITCH = "Sun StorEdge network FC 2Gig switch";
    public static final String INRANGE_SWITCH = "Inrange FC/9000 Switch";
    public static final String DEFAULT_SWITCH = "Fibre Channel Switch";
    public static final String sccs_id = "@(#)SwitchModel.java\t1.8 05/02/03 SMI";

    public static final int getSwitchModelInt(String string) {
        if (QLOGIC_SUN1GB_SWITCH.equalsIgnoreCase(string)) {
            return 1;
        }
        if (QLOGIC_SUN2GB_SWITCH.equalsIgnoreCase(string)) {
            return 2;
        }
        if (QLOGIC_SUN1GB_SWITCH_UPDATEDFW.equalsIgnoreCase(string)) {
            return 6;
        }
        if (BROCADE_SWITCH.equalsIgnoreCase(string)) {
            return 3;
        }
        if (MCDATA_SWITCH.equalsIgnoreCase(string)) {
            return 4;
        }
        if (INRANGE_SWITCH.equalsIgnoreCase(string)) {
            return 5;
        }
        return 0;
    }

    public static final String getSwitchModel(String string, String string2) {
        if ("1663".equalsIgnoreCase(string) || string.startsWith("42.2.28.3.4.1.1")) {
            if (string2.startsWith("QLogic") || string2.startsWith("Sun SANbox2") || string2.startsWith("SANbox2")) {
                return QLOGIC_SUN2GB_SWITCH;
            }
            if (string2.startsWith(DEFAULT_SWITCH)) {
                return QLOGIC_SUN1GB_SWITCH;
            }
            if (string2.startsWith("SANbox1") || string2.startsWith("Sun SANbox")) {
                return QLOGIC_SUN1GB_SWITCH_UPDATEDFW;
            }
            return DEFAULT_SWITCH;
        }
        if ("1588".equalsIgnoreCase(string)) {
            return BROCADE_SWITCH;
        }
        if ("289".equalsIgnoreCase(string)) {
            return MCDATA_SWITCH;
        }
        if ("824".equalsIgnoreCase(string)) {
            return INRANGE_SWITCH;
        }
        return DEFAULT_SWITCH;
    }

    public static class Test
    extends UnitTest {
        public void testModelInt() {
            this.assertEquals(new Integer(SwitchModel.getSwitchModelInt(SwitchModel.QLOGIC_SUN1GB_SWITCH)), new Integer(1));
            this.assertEquals(new Integer(SwitchModel.getSwitchModelInt(SwitchModel.QLOGIC_SUN2GB_SWITCH)), new Integer(2));
            this.assertEquals(new Integer(SwitchModel.getSwitchModelInt(SwitchModel.BROCADE_SWITCH)), new Integer(3));
            this.assertEquals(new Integer(SwitchModel.getSwitchModelInt(SwitchModel.MCDATA_SWITCH)), new Integer(4));
            this.assertEquals(new Integer(SwitchModel.getSwitchModelInt(SwitchModel.INRANGE_SWITCH)), new Integer(5));
            this.assertEquals(new Integer(SwitchModel.getSwitchModelInt(SwitchModel.QLOGIC_SUN1GB_SWITCH_UPDATEDFW)), new Integer(6));
        }

        public void testSwitchModel() {
            this.assertEquals(SwitchModel.getSwitchModel("1663", SwitchModel.DEFAULT_SWITCH), SwitchModel.QLOGIC_SUN1GB_SWITCH);
            this.assertEquals(SwitchModel.getSwitchModel("1663", "SANbox2"), SwitchModel.QLOGIC_SUN2GB_SWITCH);
            this.assertEquals(SwitchModel.getSwitchModel("1588", "Brocade"), SwitchModel.BROCADE_SWITCH);
            this.assertEquals(SwitchModel.getSwitchModel("289", "MCDATA"), SwitchModel.MCDATA_SWITCH);
            this.assertEquals(SwitchModel.getSwitchModel("824", "-"), SwitchModel.INRANGE_SWITCH);
            this.assertEquals(SwitchModel.getSwitchModel("1663", "SANbox1"), SwitchModel.QLOGIC_SUN1GB_SWITCH_UPDATEDFW);
        }
    }

    protected class SNMPsysDescrConstants {
        protected static final String QLOGIC = "QLogic";
        protected static final String BROCADE = "Brocade";
        protected static final String MCDATA = "MCDATA";
        protected static final String SUN = "Sun";
        protected static final String SANBOX_1GB = "SANbox1";
        protected static final String SUN_SANBOX_2GB = "Sun SANbox2";
        protected static final String SUN_SANBOX_1GB = "Sun SANbox";
        protected static final String FIBRE_CHANNEL_SWITCH = "Fibre Channel Switch";
        protected static final String SANBOX_2GB = "SANbox2";

        protected SNMPsysDescrConstants() {
        }
    }
}

