/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.diag.brocade;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class BrocadeTestExecutable
extends TestExecutableImpl {
    private static final String TEST_NAME = "Brocade LoopBack and Pattern Test";
    private static final String SADE_HOME = "storade.home";
    private static final String DIAGS_DIR = "Diags";
    private static final String BIN = "bin";
    private InetAddress hostAddress;
    private int iterations;
    private int portNum;
    private String passwd;
    private String switchip;
    private DiagnosticResult result;
    private CommandExec command = null;
    public static final String sccs_id = "@(#)BrocadeTestExecutable.java\t1.5 05/06/03 SMI";

    public BrocadeTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
        Report.debug.log("BrocadeDiags", (Object)("new BrocadeTestExecutable: mse     =" + referenceForMSE));
        Report.debug.log("BrocadeDiags", (Object)("new BrocadeTestExecutable: setting =" + diagnosticSetting));
    }

    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        this.result = diagnosticResult;
        Report.trace.log("BrocadeDiags", (Object)"runTest");
        this.parseSettings();
        this.switchip = this.hostAddress.getHostAddress();
        String string = System.getProperty(SADE_HOME) + File.separator + DIAGS_DIR + File.separator + BIN + File.separator;
        Report.debug.log("BrocadeDiags", (Object)("SADE HOME " + System.getProperty(SADE_HOME)));
        try {
            String string2 = string + "brocadetest" + " -v -o dev=" + this.portNum + ":" + this.switchip + ":|iterations=" + this.iterations + "|passwd=" + this.passwd;
            Report.debug.log("BrocadeDiags", (Object)string2);
            this.command = new CommandExec(string2);
            this.command.exec();
            this.command.getReturnValue();
            String string3 = this.command.getStandardOutput();
            String string4 = this.command.getErrorOutput();
            string3 = string3.trim();
            string4 = string4.trim();
            String string5 = string3 + " " + string4;
            StringBuffer stringBuffer = new StringBuffer(string5);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '<') {
                    stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                }
                ++n;
            }
            string5 = stringBuffer.toString().trim();
            if (string5.trim().endsWith("Close " + this.switchip)) {
                diagnosticResult.setFinalResults(TestState.PASSED, string5);
            } else {
                diagnosticResult.setFinalResults(TestState.FAILED, string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LocalizedString localizedString = new LocalizedString(exception);
            diagnosticResult.setFinalResults(TestState.FAILED, localizedString.toString());
            return;
        }
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log("BrocadeDiags", (Object)"abortTest");
        this.result.addTestResults("Test is aborted for time out or other reason");
        this.command.abort();
        return true;
    }

    protected void parseSettings() {
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("numberOfPasses");
        if (testParameter != null) {
            String string = (String)testParameter.getCurrentValue();
            this.iterations = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("Password")) != null) {
            this.passwd = (String)testParameter.getCurrentValue();
        }
        try {
            this.hostAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Object)unknownHostException);
        }
        this.portNum = Integer.parseInt(this.mse.getKeyValue());
    }
}

