/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.service;

import com.sun.jade.device.fcswitch.ancor.diag.AncorLoopbackTest;
import com.sun.jade.device.fcswitch.ancor.diag.AncorPortStatusTest;
import com.sun.jade.device.fcswitch.ancor.diag.AncorSwitchTest;
import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.device.fcswitch.ancor.service.AncorMF;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class AncorMFImpl
extends AbstractMF
implements AncorMF,
ReportGenerator {
    private Sanbox sanbox;
    private String ip;
    private int numPorts;
    private String wwn;
    private Properties p;
    private String errorMsg;
    private String reason;
    private MFStatus status;
    static /* synthetic */ Class class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl;

    public AncorMFImpl(Properties properties) {
        super(properties);
        this.ip = properties.getProperty("ip");
        this.wwn = properties.getProperty("wwn");
        this.setDeviceReport(this);
        this.addDiagnosticTest(new AncorLoopbackTest());
        this.addDiagnosticTest(new AncorPortStatusTest());
        this.addDiagnosticTest(new AncorSwitchTest());
        this.init();
    }

    private void init() {
        try {
            this.sanbox = new Sanbox(InetAddress.getByName(this.ip));
        }
        catch (UnknownHostException unknownHostException) {
            this.reason = "NO_CONTACT";
            this.errorMsg = "Initialization failed";
            return;
        }
        SanboxVersion sanboxVersion = this.sanbox.getVersion();
        if (sanboxVersion == null) {
            this.reason = "UNKNOWN";
            this.errorMsg = "Communication protocol unknown.";
            return;
        }
        this.wwn = sanboxVersion.getWorldWideNameString();
        ChassisStatus chassisStatus = this.sanbox.getChassisStatus(0);
        this.numPorts = chassisStatus.getNumOfPorts();
    }

    public String getClassName() {
        return "StorAdeSwitch_UnitaryComputerSystem";
    }

    public String getName() {
        return this.wwn;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl == null ? (class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl = AncorMFImpl.class$("com.sun.jade.device.fcswitch.ancor.service.AncorMFImpl")) : class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl, "caption", "Fibre Switch");
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString(class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl == null ? (class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl = AncorMFImpl.class$("com.sun.jade.device.fcswitch.ancor.service.AncorMFImpl")) : class$com$sun$jade$device$fcswitch$ancor$service$AncorMFImpl, "description", "Fibre Channel Switch");
    }

    public synchronized String generateReport() {
        if (this.sanbox == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<report ReturnCode='FAILURE'>\n");
            stringBuffer.append("<exception Reason='" + this.reason + "'>\n");
            stringBuffer.append(this.errorMsg);
            stringBuffer.append("</exception>\n");
            stringBuffer.append("</report>\n");
            return stringBuffer.toString();
        }
        return this.sanbox.getXMLReport();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

