/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class SanboxVersion
extends SanboxHeader {
    private static final String sccs_id = "@(#)SanboxVersion.java\t1.7 09/20/01 SMI";
    static VariableDefinition[] version_reply = new VariableDefinition[]{new VariableDefinition("util_msg_version", 4), new VariableDefinition("flash_revision", 4), new VariableDefinition("prom_hw_version", 4), new VariableDefinition("prom_sw_version", 4), new VariableDefinition("flash_sw_version", 4), new VariableDefinition("num_of_quadrants", 4), new VariableDefinition("chassis_type", 4), new VariableDefinition("chassis_number", 4), new VariableDefinition("topology", 4), new VariableDefinition("fabric_id", 4), new VariableDefinition("module_addr", 4), new VariableDefinition("world_wide_name", 8), new VariableDefinition("sys_config_reg", 4), new VariableDefinition("mac_address", 6), new VariableDefinition("reserved", 2), new VariableDefinition("long_hw_version", 4)};
    public static final int CHASSIS_TYPE_8PORT = 2;
    public static final int CHASSIS_TYPE_16PORT = 0;
    public static final int TOPOLOGY_IO_TRANSFER = 0;
    public static final int TOPOLOGY_CROSS_CONNECT = 1;

    public SanboxVersion() {
        super(version_reply);
    }

    public SanboxVersion(byte[] byArray) {
        super(version_reply);
        this.block.useData(byArray);
    }

    public boolean isValidVersion() {
        if (this.getPromHWVersion() == 0L) {
            return false;
        }
        if (this.getPromSWVersion() == 0L) {
            return false;
        }
        if (this.getFlashRevision() == 0L) {
            return false;
        }
        if (this.getWorldWideName() == 0L) {
            return false;
        }
        return this.getMACAddr() != 0L;
    }

    public long getUtilMsgVersion() {
        return this.block.getVariableValue("util_msg_version");
    }

    public long getFlashRevision() {
        return this.block.getVariableValue("flash_revision");
    }

    public long getPromHWVersion() {
        return this.block.getVariableValue("prom_hw_version");
    }

    public long getPromSWVersion() {
        return this.block.getVariableValue("prom_sw_version");
    }

    public long getFlashSWVersion() {
        return this.block.getVariableValue("flash_sw_version");
    }

    public long getNumOfQuadrants() {
        return this.block.getVariableValue("num_of_quadrants");
    }

    public long getChassisType() {
        return this.block.getVariableValue("chassis_type");
    }

    public long getChassisNumber() {
        return this.block.getVariableValue("chassis_number");
    }

    public long getTopology() {
        return this.block.getVariableValue("topology");
    }

    public long getFabricID() {
        return this.block.getVariableValue("fabric_id");
    }

    public long getModuleAddr() {
        return this.block.getVariableValue("module_addr");
    }

    public long getWorldWideName() {
        return this.block.getVariableValue("world_wide_name");
    }

    public String getWorldWideNameString() {
        return Integer.toHexString((int)(this.getWorldWideName() >> 32)) + Integer.toHexString((int)this.getWorldWideName());
    }

    public long getSysConfigReg() {
        return this.block.getVariableValue("sys_config_reg");
    }

    public long getMACAddr() {
        return this.block.getVariableValue("mac_address");
    }

    public long getLongHWVersion() {
        return this.block.getVariableValue("long_hw_version");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HW:     ");
        stringBuffer.append(Integer.toHexString((int)this.getPromHWVersion()));
        stringBuffer.append("\nPROM:   ");
        stringBuffer.append(Integer.toHexString((int)this.getPromSWVersion()));
        stringBuffer.append("\nFLASH:  ");
        stringBuffer.append(Integer.toHexString((int)this.getFlashRevision()));
        stringBuffer.append("\nWWN:    ");
        stringBuffer.append(Integer.toHexString((int)(this.getWorldWideName() >> 32)));
        stringBuffer.append(Integer.toHexString((int)this.getWorldWideName()));
        stringBuffer.append("\nMAC:    ");
        stringBuffer.append(Integer.toHexString((int)(this.getMACAddr() >> 32)));
        stringBuffer.append(Integer.toHexString((int)this.getMACAddr()));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            SanboxVersion sanboxVersion = new SanboxVersion(byArray);
            this.assertNotNull(sanboxVersion);
        }
    }
}

