/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class PortState
extends SanboxHeader {
    private static final String sccs_id = "@(#)PortState.java\t1.8 11/21/02 SMI";
    public static final int ONLINE = 1;
    public static final int OFFLINE = 2;
    public static final int INTEST = 3;
    public static final int FAILURE = 4;
    public static final int MAX_PORTS = 16;
    private static final int PORT_COMMAND = 48;
    private static final int STATE_ALL_SUB_COMMAND = 80;
    private static final int STATE_SUB_COMMAND = 81;
    private static VariableDefinition[] req = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("port_num", 1), new VariableDefinition("reserved", 1, 3)};
    private static VariableDefinition[] ret_all = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("num_of_ports", 1), new VariableDefinition("reserved", 1, 3), new VariableDefinition("actv_admin_state", 1, 16), new VariableDefinition("pndg_admin_state", 1, 16), new VariableDefinition("operational_state", 1, 16), new VariableDefinition("port_type", 1, 16), new VariableDefinition("logged_in", 1, 16), new VariableDefinition("al_disabled", 1, 16)};
    private static VariableDefinition[] ret = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("port_num", 1), new VariableDefinition("actv_admin_state", 1), new VariableDefinition("pndg_admin_state", 1), new VariableDefinition("operational_state", 1), new VariableDefinition("port_type", 1), new VariableDefinition("logged_in", 1), new VariableDefinition("al_disabled", 1), new VariableDefinition("mfs_mode", 1)};

    public static byte[] getPortStateRequest(int n) {
        SanboxHeader sanboxHeader = new SanboxHeader(req);
        sanboxHeader.setCommand(48);
        DataBlock dataBlock = sanboxHeader.getBlock();
        dataBlock.setVariable("sub_cmd", 81L);
        dataBlock.setVariable("port_num", n);
        return sanboxHeader.getBytes();
    }

    public PortState(int n) {
        super(req);
        this.setCommand(48);
        this.block.setVariable("sub_cmd", 81L);
        this.block.setVariable("port_num", n);
    }

    public PortState(byte[] byArray) {
        super(ret);
        this.block.useData(byArray);
    }

    public int getPortNum() {
        return (int)this.block.getVariableValue("port_num");
    }

    public int getOperationalState() {
        return (int)this.block.getVariableValue("operational_state");
    }

    public int getAdministrativeState() {
        return (int)this.block.getVariableValue("actv_admin_state");
    }

    public String getOperationalStateString() {
        int n = (int)this.block.getVariableValue("operational_state");
        String string = new String();
        switch (n) {
            case 1: {
                string = "Online";
                break;
            }
            case 2: {
                string = "Off Line";
                break;
            }
            case 3: {
                string = "In test";
                break;
            }
            case 4: {
                string = "Failure";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public String getAdministrativeStateString() {
        int n = (int)this.block.getVariableValue("actv_admin_state");
        String string = new String();
        switch (n) {
            case 1: {
                string = "Online";
                break;
            }
            case 2: {
                string = "Off Line";
                break;
            }
            case 3: {
                string = "In test";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public int getPortType() {
        return (int)this.block.getVariableValue("port_type");
    }

    public String getPortTypeString() {
        switch (this.getPortType()) {
            case 1: {
                return "F_Port";
            }
            case 2: {
                return "FL_Port";
            }
            case 3: {
                return "T_Port";
            }
            case 4: {
                return "SL_Port";
            }
            case 5: {
                return "TL_Port";
            }
        }
        return "Type(" + this.getPortType() + ")";
    }

    public boolean getLoggedIn() {
        return 0L != this.block.getVariableValue("logged_in");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Port ");
        stringBuffer.append(this.getPortNum() + 1);
        stringBuffer.append(" ");
        stringBuffer.append(this.getPortTypeString());
        switch (this.getOperationalState()) {
            case 1: {
                stringBuffer.append(" Online");
                break;
            }
            case 2: {
                stringBuffer.append(" Offline");
                break;
            }
            case 3: {
                stringBuffer.append(" In test");
                break;
            }
            case 4: {
                stringBuffer.append(" Failure");
                break;
            }
            default: {
                stringBuffer.append(" Unknown");
            }
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            PortState portState = new PortState(byArray);
            this.assertNotNull(portState);
        }
    }

    public static class PortType {
        public static final int F_Port = 1;
        public static final int FL_Port = 2;
        public static final int T_Port = 3;
        public static final int SL_Port = 4;
        public static final int TL_Port = 5;
    }
}

