/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.diag;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.fcswitch.ancor.diag.Messages;
import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortCounts;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortState;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.wbem.cim.CIMDateTime;

public class AncorPortStatusTestExecutable
extends TestExecutableImpl {
    private static final Localizer msgs = Messages.getLocalizer();
    private static final int ALL_PORTS = -1;
    private DiagnosticResult result;
    private boolean abort = false;
    private boolean isRunning = false;
    private Sanbox sanbox;
    private InetAddress hostAddress;
    private int portNum = -1;
    private int numPorts;
    private static final String sccs_id = "@(#)AncorPortStatusTestExecutable.java\t1.7 05/08/03 SMI";

    public AncorPortStatusTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
        Report.debug.log((Object)("\nnew AncorPortStatusTestExecutable: mse     =" + referenceForMSE));
        Report.debug.log((Object)("\nnew AncorPortStatusTestExecutable: setting =" + diagnosticSetting));
    }

    public ReferenceForMSE getExclusiveMSE() {
        return new ReferenceForMSE(this.mse.getSystemClassName(), this.mse.getSystemName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        Report.trace.log((Object)"runTest");
        super.parseSettings();
        this.result = diagnosticResult;
        diagnosticResult.setTestStartTime(new CIMDateTime());
        diagnosticResult.setTestState(TestState.IN_PROGRESS);
        diagnosticResult.setEstimatedTimeOfPerforming(10);
        diagnosticResult.setPercentComplete((short)0);
        this.isRunning = true;
        try {
            try {
                this.parseLocalSettings();
                if (this.reportStatus) {
                    diagnosticResult.addTestResults(msgs.getFormattedString("test.settings", (Object)("\n" + this.setting.getTestParameter("TestWarningLevel") + "\n" + this.setting.getTestParameter("ReportSoftErrors") + "\n" + this.setting.getTestParameter("ReportStatusMessages") + "\n" + this.setting.getTestParameter("HaltOnError"))));
                }
                this.sanbox = new Sanbox(this.hostAddress);
                ChassisStatus chassisStatus = this.sanbox.getChassisStatus(0);
                this.switchStatus();
                if (this.portNum == -1) {
                    int n = 0;
                    while (n < this.numPorts) {
                        this.portStatus(n);
                        ++n;
                    }
                } else {
                    this.portStatus(this.portNum);
                }
                this.status(msgs.getString("test.passed"), diagnosticResult);
                diagnosticResult.setFinalResults(TestState.PASSED);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.reportErrors) {
                    diagnosticResult.addTestResults(exception.getLocalizedMessage());
                }
                diagnosticResult.setFinalResults(TestState.FAILED);
                Object var5_6 = null;
                this.isRunning = false;
                this.abort = false;
                return;
            }
            Object var5_5 = null;
            this.isRunning = false;
            this.abort = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.isRunning = false;
            this.abort = false;
            throw throwable;
        }
    }

    private void switchStatus() throws DiagnosticException {
        SanboxVersion sanboxVersion = this.sanbox.getVersion();
        ChassisStatus chassisStatus = this.sanbox.getChassisStatus(0);
        this.numPorts = chassisStatus.getNumOfPorts();
        if (0 != chassisStatus.getPowerSupplyFailed()) {
            this.failure(msgs.getString("status.ps.failure"), this.result);
        }
        this.status(msgs.getFormattedString("status.temp.value", (Object)new Integer(chassisStatus.getBoardTemp() / 2)), this.result);
        switch (chassisStatus.getBoardHeatStatus()) {
            case 0: {
                this.status(msgs.getString("status.temp.ok"), this.result);
                break;
            }
            case 1: {
                this.softError(msgs.getString("status.temp.warm"), this.result);
                break;
            }
            case 2: {
                this.failure(msgs.getString("status.temp.overheat"), this.result);
            }
        }
        if (chassisStatus.isFanInstalled(1) && 0 != chassisStatus.getFanStatus(1)) {
            this.failure(msgs.getFormattedString("status.fan.failure", (Object)new Integer(1)), this.result);
        }
        if (chassisStatus.isFanInstalled(2) && 0 != chassisStatus.getFanStatus(2)) {
            this.failure(msgs.getFormattedString("status.fan.failure", (Object)new Integer(2)), this.result);
        }
    }

    private void portStatus(int n) throws DiagnosticException {
        PortCounts portCounts = this.sanbox.getPortCounts(n);
        Integer n2 = new Integer(n + 1);
        if (portCounts.getfcFPortInvalidCrcs() > 0L) {
            this.status(msgs.getFormattedString("status.port.crc", (Object)new Integer(n), (Object)new Integer((int)portCounts.getfcFPortInvalidCrcs())), this.result);
        }
        PortState portState = this.sanbox.getPortState(n);
        switch (portState.getOperationalState()) {
            case 1: {
                this.status(msgs.getFormattedString("status.port.online", (Object)n2), this.result);
                break;
            }
            case 2: {
                this.status(msgs.getFormattedString("status.port.offline", (Object)n2), this.result);
                break;
            }
            case 3: {
                this.status(msgs.getFormattedString("status.port.intest", (Object)n2), this.result);
                break;
            }
            case 4: {
                this.failure(msgs.getFormattedString("status.port.failure", (Object)n2), this.result);
                break;
            }
            default: {
                this.softError(msgs.getFormattedString("status.port.unknown_state", (Object)n2), this.result);
            }
        }
    }

    private void parseLocalSettings() throws UnknownHostException {
        super.parseSettings();
        this.hostAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
        this.portNum = Integer.parseInt(this.mse.getKeyValue()) - 1;
    }
}

