/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.service.api;

import com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmCountSummary;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.service.api.Contract;
import java.io.Serializable;

public abstract class ElementTransferObject
implements Serializable {
    private static final String SCCS_ID = "@(#)ElementTransferObject.java 1.2   03/04/18 SMI";
    private boolean myMutable = true;
    private boolean myMonitored = false;
    private final Identity myIdentity;
    private final ElementType myElementType;
    private AlarmCountSummary myAlarmCounts = null;

    protected ElementTransferObject(Identity identity, ElementType elementType) {
        this.myIdentity = identity;
        this.myElementType = elementType;
    }

    protected ElementTransferObject(Identity identity) {
        this(identity, null);
    }

    public final boolean isMutable() {
        return this.myMutable;
    }

    public final void immutable() {
        this.myMutable = false;
        Contract.ensures((!this.isMutable() ? 1 : 0) != 0, (String)"isMutable() == false");
    }

    protected final void checkMutable() {
        Contract.guarantees((boolean)this.isMutable(), (String)"isMutable()");
    }

    public final boolean isMonitored() {
        return this.myMonitored;
    }

    public final void setMonitored(boolean bl) {
        this.myMonitored = bl;
    }

    public Identity getIdentity() {
        return this.myIdentity;
    }

    public ElementType getElementType() {
        return this.myElementType;
    }

    public final AlarmCountSummary getAlarmCounts() {
        if (this.myAlarmCounts == null) {
            this.myAlarmCounts = new AlarmCountSummary(0L, 0L, 0L, 0L);
        }
        return this.myAlarmCounts;
    }

    public final void setAlarmCounts(AlarmCountSummary alarmCountSummary) {
        this.myAlarmCounts = alarmCountSummary;
    }

    public String toString() {
        return this.myIdentity.toString();
    }
}

