/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.identity.api;

import com.sun.jade.apps.persistence.util.db.ConnectionPool;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementModel;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementVendor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolutionException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.TypeResolutionException;
import com.sun.netstorage.mgmt.esm.logic.registry.api.RMIRegistryFacility;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeResolver {
    private static final String CLASS_NAME = "TypeResolver";
    private static final String PKG_NAME = "com.sun.netstorage.mgmt.esm.logic.identity.api";
    private static final String RES_NAME = "com/sun/netstorage/mgmt/esm/logic/identity/api/Localization";
    private static final String COMP_NAME = "Type Resolver";
    private static final Logger logger = Logger.getLogger("com.sun.netstorage.mgmt.esm.logic.identity.api");
    private static final String ERR_RESOLVER = "type.err.resolver";
    private static final String ERR_DBID = "type.err.dbid";
    private static final String ERR_DB = "type.err.db";
    private static final String QUERY = "SELECT flavor, vendor, model from type where dbid = ?";
    private static final String QUERY2 = "SELECT dbid FROM type where ";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver;

    private static IdentityResolver getIDResolver() {
        IdentityResolver identityResolver;
        block3: {
            identityResolver = null;
            try {
                Class clazz;
                Class clazz2 = clazz = class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver == null ? (class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver = TypeResolver.class$("com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver")) : class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver;
                if (System.getProperty("standalone") != null) {
                    identityResolver = (IdentityResolver)LocateRegistry.getRegistry().lookup(clazz.getPackage().getName());
                    break block3;
                }
                identityResolver = (IdentityResolver)RMIRegistryFacility.Singleton.get().lookup(clazz.getPackage().getName());
            }
            catch (Exception exception) {
                TypeResolver.log(Level.SEVERE, CLASS_NAME, "getIDResolver", RES_NAME, ERR_RESOLVER, null, exception);
            }
        }
        return identityResolver;
    }

    public static ElementType getType(Identity identity) throws TypeResolutionException {
        DeviceType deviceType;
        Identity identity2 = null;
        try {
            identity2 = TypeResolver.getDBID(identity);
        }
        catch (Exception exception) {
            TypeResolver.log(Level.SEVERE, CLASS_NAME, "getType", RES_NAME, ERR_DBID, new Object[]{identity}, exception);
            throw new TypeResolutionException(identity, "Failed to get DBID.  Got exception.", exception);
        }
        Connection connection = null;
        try {
            connection = ConnectionPool.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(QUERY);
            preparedStatement.setString(1, identity2.getValue());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new TypeResolutionException(identity, "Could not resolve type for identity.  No type exists in db for given identity.");
            }
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            DeviceFlavor deviceFlavor = DeviceFlavor.getInstance(string);
            ElementVendor elementVendor = ElementVendor.getInstance(string2);
            ElementModel elementModel = ElementModel.getInstance(string3);
            preparedStatement.close();
            deviceType = DeviceType.getInstance(deviceFlavor, elementVendor, elementModel);
            Object var13_14 = null;
        }
        catch (Exception exception) {
            try {
                TypeResolver.log(Level.SEVERE, CLASS_NAME, "getType", RES_NAME, ERR_DB, new Object[]{QUERY, identity2.getValue(), identity}, exception);
                throw new TypeResolutionException(identity, "Exception while querying type from DB.", exception);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                ConnectionPool.returnConnection((Connection)connection);
                throw throwable;
            }
        }
        ConnectionPool.returnConnection((Connection)connection);
        return deviceType;
    }

    public static Identity[] getIDs(ElementType elementType) throws TypeResolutionException {
        Object[] objectArray;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Vector<Identity> vector;
        String string;
        Connection connection;
        block13: {
            connection = null;
            string = null;
            connection = ConnectionPool.getConnection();
            String[] stringArray = new String[3];
            string = QUERY2;
            String string2 = elementType.getFlavor().getName();
            String string3 = elementType.getVendor().getName();
            String string4 = elementType.getModel().getName();
            int n = 0;
            vector = new Vector<Identity>();
            if (string2 != null) {
                stringArray[n++] = string2;
                string = string + " flavor = ?";
            }
            if (string3 != null) {
                if (n != 0) {
                    string = string + " AND";
                }
                stringArray[n++] = string3;
                string = string + " vendor = ?";
            }
            if (string4 != null) {
                if (n != 0) {
                    string = string + " AND";
                }
                stringArray[n++] = string4;
                string = string + " model = ?";
            }
            preparedStatement = connection.prepareStatement(string);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    preparedStatement.setString(n2 + 1, stringArray[n2]);
                }
                ++n2;
            }
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block13;
            Identity[] identityArray = null;
            Object var16_14 = null;
            ConnectionPool.returnConnection((Connection)connection);
            return identityArray;
        }
        try {
            do {
                vector.addElement(new Identity(resultSet.getString(1), IdentityType.DBID));
            } while (resultSet.next());
            preparedStatement.close();
            Object[] objectArray2 = new Identity[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var16_15 = null;
        }
        catch (SQLException sQLException) {
            try {
                TypeResolver.log(Level.SEVERE, CLASS_NAME, "getIds", RES_NAME, ERR_DB, new Object[]{string}, sQLException);
                throw new TypeResolutionException(null, "Exception while querying db.", sQLException);
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                ConnectionPool.returnConnection((Connection)connection);
                throw throwable;
            }
        }
        ConnectionPool.returnConnection((Connection)connection);
        return objectArray;
    }

    private static Identity getDBID(Identity identity) throws RemoteException, IdentityException, IdentityResolutionException {
        if (identity.getType().equals(IdentityType.DBID)) {
            return identity;
        }
        return TypeResolver.getIDResolver().getAlternateIdentifier(identity, IdentityType.DBID);
    }

    private static void log(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        TypeResolver.log(level, string, string2, string3, string4, objectArray, null);
    }

    private static void log(Level level, String string, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
        logger.logrb(level, string, string2, string3, string4, objectArray);
        if (throwable != null) {
            logger.log(level, "", throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

