/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.identity.api;

import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.Serializable;

public abstract class DeviceTypeException
extends LocalizableException {
    private static final String SCCS_ID = "@(#)DeviceTypeException.java 1.4   03/05/02 SMI";
    public static final String INVALID_DEVICE_TYPE = "the specified device type ({0}) is invalid";
    public static final String UNKNOWN_DEVICE_TYPE = "the specified device type ({0}) is unknown by the application";
    public static final String AMBIGUOUS_DEVICE_TYPE = "the specified device type ({0}) is ambiguous in the application\n\twhere the list of matching device types is the following\n";
    private final DeviceType myDeviceType;

    protected DeviceTypeException(DeviceType deviceType) {
        this.myDeviceType = deviceType;
        if (deviceType != null) {
            this.getSupport().addMessageArg((Serializable)deviceType);
        }
    }

    protected DeviceTypeException() {
        this(null);
    }

    public final DeviceType getDeviceType() {
        return this.myDeviceType;
    }

    public static final class AmbiguousDeviceType
    extends DeviceTypeException {
        private final DeviceType[] myCollisions;

        public AmbiguousDeviceType(DeviceType deviceType, DeviceType[] deviceTypeArray) {
            super(deviceType);
            this.myCollisions = deviceTypeArray;
            StringBuffer stringBuffer = new StringBuffer();
            if (deviceTypeArray != null) {
                int n = 0;
                while (n < deviceTypeArray.length) {
                    if (n > 0) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append('\t');
                    stringBuffer.append(deviceTypeArray[n]);
                    ++n;
                }
            } else {
                stringBuffer.append("none");
            }
            this.getSupport().addMessageArg((Serializable)((Object)stringBuffer.toString()));
            this.getSupport().initMessage(Localization.FMT_AMBIGUOUS_DEVICE_TYPE);
        }

        public final DeviceType[] getCollisions() {
            return this.myCollisions;
        }
    }

    public static final class UnknownDeviceType
    extends DeviceTypeException {
        public UnknownDeviceType(DeviceType deviceType) {
            super(deviceType);
            this.getSupport().initMessage(Localization.FMT_UNKNOWN_DEVICE_TYPE);
        }
    }

    public static final class InvalidDeviceType
    extends DeviceTypeException {
        public InvalidDeviceType(DeviceType deviceType) {
            super(deviceType);
            this.getSupport().initMessage(Localization.FMT_INVALID_DEVICE_TYPE);
        }
    }
}

