/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.hds.service;

import com.sun.jade.device.protocol.snmp.SNMPWalk;
import com.sun.jade.device.util.GUIDGenerator;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class HDSOOBProbe
implements Probe {
    private Properties probeProps;
    private static String SERIAL_NUMBER = "1.3.6.1.4.1.116.5.11.4.1.1.5.1.1";
    private static String PROCESSOR = "1.3.6.1.4.1.116.5.11.4.1.1.5.1.2";
    private static String SYSDESCR_9910 = "RAID401";
    private static String SYSDESCR_9960 = "RAID400";
    private static String SYSDESCR_9970 = "RAIDXXX";
    private static String SYSDESCR_9980 = "RAID450";
    private static String MODEL_9910 = "9910";
    private static String MODEL_9960 = "9960";
    private static String MODEL_9970 = "9970";
    private static String MODEL_9980 = "9980";
    private static String GENERIC_MODEL = "9900";
    public static final String sccs_id = "@(#)HDSOOBProbe.java\t1.10 06/23/03 SMI";

    public HDSOOBProbe(Properties properties) {
        this.probeProps = properties;
    }

    public String getName() {
        return "hds";
    }

    public ProbeResult probe(Properties properties) {
        Properties properties2;
        LinkedList<Properties> linkedList = new LinkedList<Properties>();
        String string = properties.getProperty("snmp.sysDescr");
        if (string != null && string.startsWith("RAID4") && (properties2 = this.getDevProps(properties)) != null) {
            linkedList.add(properties2);
        }
        return new ProbeResult(this.probeProps, linkedList);
    }

    private Properties getDevProps(Properties properties) {
        String string;
        InetAddress inetAddress;
        Properties properties2 = new Properties();
        String string2 = properties.getProperty("ip");
        String string3 = properties.getProperty("ipno");
        if (string2 != null) {
            properties2.setProperty("ip", string2);
        }
        if (string3 != null) {
            properties2.setProperty("ipno", string3);
        } else {
            try {
                inetAddress = InetAddress.getByName(string2);
                properties2.setProperty("ipno", inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        inetAddress = new SNMPWalk(string3 != null ? string3 : string2);
        String string4 = null;
        HashMap hashMap = inetAddress.getProperties(SERIAL_NUMBER, PROCESSOR);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.startsWith(SERIAL_NUMBER)) continue;
            string4 = (String)hashMap.get(string);
            break;
        }
        if (string4 != null) {
            String string5;
            string = properties.getProperty("snmp.sysDescr");
            properties2.setProperty("logicalName", string2);
            properties2.setProperty("serialNumber", string4);
            String string6 = null;
            try {
                int n = Integer.parseInt(string4);
                string5 = Integer.toHexString(n).toUpperCase();
                int n2 = string.indexOf("4");
                String string7 = string.substring(n2);
                string6 = "0" + string7 + string5;
            }
            catch (NumberFormatException numberFormatException) {
                string6 = string4;
            }
            properties2.setProperty("name", string6);
            properties2.setProperty("name.oob", string6);
            properties2.setProperty("type", "hds");
            String string8 = GENERIC_MODEL;
            if (string.startsWith(SYSDESCR_9960)) {
                string8 = MODEL_9960;
            } else if (string.startsWith(SYSDESCR_9980)) {
                string8 = MODEL_9980;
            } else if (string.startsWith(SYSDESCR_9910)) {
                string8 = MODEL_9910;
            }
            properties2.setProperty("MODEL", "StorEdge " + string8);
            properties2.setProperty("VENDOR", "Sun");
            string5 = GUIDGenerator.generateGUID((String)"array", (String)"sun", (String)string8, (String)"sn", (String)string4);
            properties2.setProperty("GUID", string5);
        }
        long l = System.currentTimeMillis();
        properties2.setProperty("search.oob", "" + l);
        return properties2;
    }

    public static void main(String[] stringArray) {
        HDSOOBProbe hDSOOBProbe = new HDSOOBProbe(new Properties());
        Properties properties = new Properties();
        properties.setProperty("ip", stringArray[0]);
        properties.setProperty("snmp.sysDescr", "RAID450");
        ProbeResult probeResult = hDSOOBProbe.probe(properties);
        if (probeResult != null) {
            System.out.println(probeResult.toString());
        }
        System.exit(0);
    }
}

