/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.device.rack.serack.io.SERackException;
import com.sun.jade.device.rack.serack.io.SERackTokenList;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.ReportTools;
import com.sun.jade.util.log.Report;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class RackTranslator {
    protected String systemName;
    protected SERackTokenList rack;
    protected static final String OK_STATUS = "OK";
    protected static final String UNKNOWN_STATUS = "Unknown";
    protected static final String UNKNOWN_STATUS_INFO = "2";
    protected static final String UNKNOWN_AVAILABILITY = "2";
    protected static final String OK_AVAILABILITY = "3";
    protected static final String REPORT_OK = "OK";
    protected static final String REPORT_FAIL = "FAILURE";
    protected static final String BLANK = "";
    protected static final String VOLUME = "vol";
    protected static final String LUN = "lun";
    public static final String sccs_id = "@(#)RackTranslator.java\t1.0 05/09/02 SMI";

    public RackTranslator(String string) {
        this.systemName = string;
    }

    protected void updateAdminDomain(DeviceClass deviceClass) {
        deviceClass.setClassName("AdminDomain");
        deviceClass.setProperty("Name", this.systemName);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("Status", "OK");
        deviceClass.setProperty("Description", "Sun Storage Solution Rack");
        deviceClass.setProperty("Caption", "StorEdge Rack");
        String string = this.rack.getStringValue("info", "totalCapacity");
        ReportTools.xmlIntAttr((DeviceClass)deviceClass, (String)"Capacity", (String)this.convertCapacity(string));
        int n = this.getCount("lunTotal") + this.getCount("sliceTotal");
        deviceClass.setProperty("LunTotal", BLANK + n);
        deviceClass.setProperty("PortTotal", this.rack.getStringValue("info", "portTotal"));
    }

    private String convertCapacity(String string) {
        String string2;
        block6: {
            string2 = BLANK;
            if (string == null) break block6;
            int n = string.indexOf("GB");
            int n2 = string.indexOf("TB");
            int n3 = string.indexOf("MB");
            int n4 = string.indexOf("KB");
            try {
                if (n2 > -1) {
                    string2 = string.substring(0, n2).trim();
                    Double d = new Double(string2);
                    double d2 = d * 1024.0 * 1024.0;
                    string2 = this.truncate(Double.toString(d2));
                    break block6;
                }
                if (n > -1) {
                    string2 = string.substring(0, n).trim();
                    Double d = new Double(string2);
                    double d3 = d * 1024.0;
                    string2 = this.truncate(Double.toString(d3));
                    break block6;
                }
                if (n3 > -1) {
                    string2 = string.substring(0, n3).trim();
                    Double d = new Double(string2);
                    double d4 = d;
                    string2 = this.truncate(Double.toString(d4));
                    break block6;
                }
                if (n4 > -1) {
                    string2 = string.substring(0, n4).trim();
                    Double d = new Double(string2);
                    double d5 = d / 1024.0;
                    string2 = this.truncate(Double.toString(d5));
                    break block6;
                }
                Double d = new Double(string);
                long l = d.longValue();
                string2 = BLANK + l;
            }
            catch (Exception exception) {
                Report.debug.log((Object)("Could not convert " + string));
            }
        }
        return string2;
    }

    protected void updateFibrePort(DeviceClass deviceClass, int n) {
        block18: {
            String string = this.rack.getStringValue("fcPort." + n, "status");
            String string2 = this.convertToCIMStatus(string);
            String string3 = this.convertToCIMAvailability(string2);
            deviceClass.setClassName("FibrePort");
            String string4 = this.rack.getStringValue("fcPort." + n, "LocalPortWWN");
            if (string4 != null) {
                deviceClass.setProperty("DeviceID", string4);
            } else {
                deviceClass.setProperty("DeviceID", "fcPort." + n);
            }
            deviceClass.setProperty("CreationClassName", "StorEdgeRack_FibrePort");
            deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
            deviceClass.setProperty("SystemName", this.systemName);
            deviceClass.setProperty("Name", "fcPort");
            deviceClass.setProperty("Status", string2);
            deviceClass.setProperty("Availability", string3);
            deviceClass.setProperty("StatusInfo", "2");
            deviceClass.setProperty("Caption", "StorEdge Rack Fibre Port");
            deviceClass.setProperty("Description", "StorEdge Rack Externally Visible Fibre Port");
            deviceClass.setProperty("PowerManagementSupported", "false");
            String string5 = this.rack.getStringValue("fcPort." + n, "status-sev");
            if (string5 != null) {
                try {
                    int n2 = Integer.parseInt(string5);
                    if (n2 > 0) {
                        deviceClass.setProperty("LastErrorCode", string5);
                        deviceClass.setProperty("ErrorCleared", "false");
                        break block18;
                    }
                    deviceClass.setProperty("LastErrorCode", "0");
                    deviceClass.setProperty("ErrorCleared", "true");
                }
                catch (NumberFormatException numberFormatException) {
                    deviceClass.setProperty("ErrorCleared", "true");
                }
            } else {
                deviceClass.setProperty("LastErrorCode", "0");
                deviceClass.setProperty("ErrorCleared", "true");
            }
        }
        String string = this.rack.getStringValue("fcPort." + n, "status-desc");
        if (string != null) {
            deviceClass.setProperty("ErrorDescription", string);
        } else {
            deviceClass.setProperty("ErrorDescription", "None");
        }
        deviceClass.setProperty("AddressIdentifier", "0");
        deviceClass.setProperty("CurrentPortType", "0");
        String string6 = this.rack.getStringValue("fcPort." + n, "CRC");
        if (string6 != null) {
            deviceClass.setProperty("CRCErrors", string6.trim());
        } else {
            deviceClass.setProperty("CRCErrors", "0");
        }
        String string7 = this.rack.getStringValue("fcPort." + n, "portType");
        if (string7 != null) {
            if (string7.indexOf(".") > 0) {
                int n3 = string7.indexOf(".");
                deviceClass.setProperty("Type", string7.substring(n3 + 1));
            } else {
                deviceClass.setProperty("Type", string7);
            }
        } else {
            deviceClass.setProperty("Type", "unknown");
        }
        deviceClass.setProperty("WWN", this.rack.getStringValue("fcPort." + n, "LocalPortWWN"));
        deviceClass.setProperty("RemoteWWN", this.rack.getStringValue("fcPort." + n, "PortWWN"));
        String string8 = this.rack.getStringValue("fcPort." + n, "encName");
        String string9 = this.rack.getStringValue("fcPort." + n, "nodeId");
        if (string9 != null) {
            String[] stringArray = string9.split(":");
            if (stringArray.length >= 3) {
                deviceClass.setProperty("EnclosureID", string8 + " port " + stringArray[2]);
            } else {
                deviceClass.setProperty("EnclosureID", string8 + " port not specified");
            }
        }
    }

    protected void updateProtocolEndpoint(DeviceClass deviceClass, int n) {
        String string = this.rack.getStringValue("fcPort." + n, "status");
        String string2 = this.convertToCIMStatus(string);
        deviceClass.setClassName("ProtocolEndpoint");
        String string3 = this.rack.getStringValue("fcPort." + n, "LocalPortWWN");
        deviceClass.setProperty("Name", string3);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_ProtocolEndpoint");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("Status", string2);
        deviceClass.setProperty("Caption", "Fibre Channel endpoint");
        deviceClass.setProperty("Description", "Fibre Channel Endpoint");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
        deviceClass.setProperty("NameFormat", "WWN");
        String string4 = this.rack.getStringValue("fcPort." + n, "PortWWN");
        if (string4 != null && !string4.equals(string3)) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ProtocolEndpoint");
            deviceClass2.setProperty("Name", string4);
            deviceClass2.setProperty("CreationClassName", "StorEdgeRack_ProtocolEndpoint");
            deviceClass2.setProperty("SystemName", this.systemName);
            deviceClass2.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
            deviceClass2.setProperty("Status", UNKNOWN_STATUS);
            deviceClass2.setProperty("Caption", "Fibre Channel endpoint");
            deviceClass2.setProperty("Description", "Fibre Channel Endpoint");
            deviceClass2.setProperty("ProtocolType", "Fibre Channel");
            deviceClass2.setProperty("NameFormat", "WWN");
        }
    }

    protected void updatePowerSupply(DeviceClass deviceClass, String string, int n) {
        String string2 = UNKNOWN_STATUS;
        String string3 = UNKNOWN_STATUS;
        if (string.equalsIgnoreCase("psu")) {
            string3 = string2 = this.rack.getStringValue("fru." + n, "State");
            deviceClass.setProperty("Description", "DSP power supply");
        } else {
            string2 = this.rack.getStringValue("fru." + n, "fruStatus");
            string3 = this.rack.getStringValue("fru." + n, "fruState");
            deviceClass.setProperty("Description", "Disk array power supply");
        }
        String string4 = this.convertToCIMStatus(string2);
        String string5 = this.convertToCIMStatusInfo(string3);
        String string6 = this.convertToCIMAvailability(string4, string5);
        deviceClass.setClassName("PowerSupply");
        String string7 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string8 = "s" + string7 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string8);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_PowerSupply");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string7, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string4);
        deviceClass.setProperty("StatusInfo", string5);
        deviceClass.setProperty("Availability", string6);
        deviceClass.setProperty("Caption", "Power supply");
        deviceClass.setProperty("PowerManagementSupported", "false");
    }

    protected void updateVirtualizationEngine(DeviceClass deviceClass, String string, int n) {
        deviceClass.setClassName("VirtualizationEngine");
        String string2 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string3 = "s" + string2 + this.rack.getStringValue("fru." + n, "fruType");
        deviceClass.setProperty("DeviceID", string3);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_VirtualizationEngine");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        String string4 = this.rack.getStringValue("slot." + string2, "status-avail");
        String string5 = this.convertStatusAvailToCIMStatus(string4);
        deviceClass.setProperty("Status", string5);
        deviceClass.setProperty("StatusInfo", this.convertToCIMStatusInfo(string5));
        deviceClass.setProperty("Availability", this.convertToCIMAvailability(string5));
        deviceClass.setProperty("Caption", "Virtualization Engine");
        deviceClass.setProperty("Description", "Virtualization Engine");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", " ");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateDiskDrive(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "fruStatus");
        String string3 = this.rack.getStringValue("fru." + n, "fruState");
        String string4 = this.convertToCIMStatus(string2);
        String string5 = this.convertToCIMStatusInfo(string3);
        String string6 = this.convertToCIMAvailability(string4, string5);
        deviceClass.setClassName("DiskDrive");
        String string7 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string8 = "s" + string7 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string8);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_DiskDrive");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string7, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string4);
        deviceClass.setProperty("StatusInfo", string5);
        deviceClass.setProperty("Availability", string6);
        deviceClass.setProperty("Caption", "Disk Drive");
        deviceClass.setProperty("Description", "Disk Drive");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorCleared", "true");
        deviceClass.setProperty("ErrorDescription", BLANK);
    }

    protected void updateLoopController(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "fruStatus");
        String string3 = this.rack.getStringValue("fru." + n, "fruState");
        String string4 = this.convertToCIMStatus(string2);
        String string5 = this.convertToCIMStatusInfo(string3);
        String string6 = this.convertToCIMAvailability(string4, string5);
        deviceClass.setClassName("Controller");
        String string7 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string8 = "s" + string7 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string8);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_LoopController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string7, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string4);
        deviceClass.setProperty("StatusInfo", string5);
        deviceClass.setProperty("Availability", string6);
        deviceClass.setProperty("Caption", "Loop Controller");
        deviceClass.setProperty("Description", "Fibre channel loop controller");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateSCSIController(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "fruStatus");
        String string3 = this.rack.getStringValue("fru." + n, "fruState");
        String string4 = this.convertToCIMStatus(string2);
        String string5 = this.convertToCIMStatusInfo(string3);
        String string6 = this.convertToCIMAvailability(string4, string5);
        deviceClass.setClassName("SCSIController");
        String string7 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string8 = "s" + string7 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string8);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_SCSIController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string7, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string4);
        deviceClass.setProperty("StatusInfo", string5);
        deviceClass.setProperty("Availability", string6);
        deviceClass.setProperty("Caption", "Disk array controller card");
        deviceClass.setProperty("Description", "Disk array controller card");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateMidplaneDevice(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "fruStatus");
        String string3 = this.rack.getStringValue("fru." + n, "fruState");
        String string4 = this.convertToCIMStatus(string2);
        String string5 = this.convertToCIMStatusInfo(string3);
        String string6 = this.convertToCIMAvailability(string4, string5);
        deviceClass.setClassName("LogicalDevice");
        String string7 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string8 = "s" + string7 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string8);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_MidplaneDevice");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string7, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string4);
        deviceClass.setProperty("StatusInfo", string5);
        deviceClass.setProperty("Availability", string6);
        deviceClass.setProperty("Caption", "Disk array midplane");
        deviceClass.setProperty("Description", "Disk array midplane");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateSwitch(DeviceClass deviceClass, String string, int n) {
        deviceClass.setClassName("Switch");
        String string2 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string3 = "s" + string2 + this.rack.getStringValue("fru." + n, "fruType");
        deviceClass.setProperty("DeviceID", string3);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_Switch");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        String string4 = this.rack.getStringValue("slot." + string2, "status-avail");
        String string5 = this.convertStatusAvailToCIMStatus(string4);
        deviceClass.setProperty("Status", string5);
        deviceClass.setProperty("StatusInfo", this.convertToCIMStatusInfo(string5));
        deviceClass.setProperty("Availability", this.convertToCIMAvailability(string5));
        deviceClass.setProperty("Caption", "Fibre port switch");
        deviceClass.setProperty("Description", "Fibre port switch");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", " ");
        deviceClass.setProperty("ErrorCleared", "true");
        deviceClass.setProperty("Flash", this.rack.getStringValue("fru." + n, "version-FLASH"));
        deviceClass.setProperty("Prom", this.rack.getStringValue("fru." + n, "version-PROM"));
    }

    protected void updateServiceProcessor(DeviceClass deviceClass, String string, int n) {
        deviceClass.setClassName("ServiceProcessor");
        String string2 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string3 = "s" + string2 + this.rack.getStringValue("fru." + n, "fruType");
        deviceClass.setProperty("DeviceID", string3);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_ServiceProcessor");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        String string4 = "OK";
        deviceClass.setProperty("Status", string4);
        deviceClass.setProperty("Availability", this.convertToCIMAvailability(string4));
        deviceClass.setProperty("Caption", "Rack service processor");
        deviceClass.setProperty("Description", "Rack internal service processor");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
        deviceClass.setProperty("OperatingSystemType", this.rack.getStringValue("fru." + n, "info-os"));
        deviceClass.setProperty("OperatingSystemVersion", this.rack.getStringValue("fru." + n, "info-os_version"));
    }

    protected void updateStorageResourceController(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "State");
        String string3 = this.convertToCIMStatus(string2);
        String string4 = this.convertToCIMStatusInfo(string2);
        String string5 = this.convertToCIMAvailability(string3);
        deviceClass.setClassName("StorageResourceController");
        String string6 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string7 = "s" + string6 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string7);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_StorageResourceController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string6, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("Availability", string5);
        deviceClass.setProperty("Caption", "Storage Resource Card");
        deviceClass.setProperty("Description", "Storage Resource Card");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateSwitchFabricController(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "State");
        String string3 = this.convertToCIMStatus(string2);
        String string4 = this.convertToCIMStatusInfo(string2);
        String string5 = this.convertToCIMAvailability(string3, string4);
        deviceClass.setClassName("SwitchFabricController");
        String string6 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string7 = "s" + string6 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string7);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_SwitchFabricController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string6, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("Availability", string5);
        deviceClass.setProperty("Caption", "Switch Fabric Card");
        deviceClass.setProperty("Description", "Switch Fabric Card");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateStorageIOController(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "State");
        String string3 = this.convertToCIMStatus(string2);
        String string4 = this.convertToCIMStatusInfo(string2);
        String string5 = this.convertToCIMAvailability(string3, string4);
        deviceClass.setClassName("StorageIOController");
        String string6 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string7 = "s" + string6 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string7);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_StorageIOController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string6, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("Availability", string5);
        deviceClass.setProperty("Caption", "I/O Controller");
        deviceClass.setProperty("Description", "I/O Controller");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateManagementInterfaceController(DeviceClass deviceClass, String string, int n) {
        String string2 = this.rack.getStringValue("fru." + n, "State");
        String string3 = this.convertToCIMStatus(string2);
        String string4 = this.convertToCIMStatusInfo(string2);
        String string5 = this.convertToCIMAvailability(string3, string4);
        deviceClass.setClassName("ManagementInterfaceController");
        String string6 = this.rack.getStringValue("fru." + n, "fruSlot");
        String string7 = "s" + string6 + this.rack.getStringValue("fru." + n, "fruId");
        deviceClass.setProperty("DeviceID", string7);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_ManagementInterfaceController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string6, "dev-name") + "." + string);
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("Availability", string5);
        deviceClass.setProperty("Caption", "Management Interface Card");
        deviceClass.setProperty("Description", "Management Interface Card");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("LastErrorCode", "0");
        deviceClass.setProperty("ErrorDescription", "String");
        deviceClass.setProperty("ErrorCleared", "true");
    }

    protected void updateVolume(DeviceClass deviceClass, int n) {
        String string;
        String string2;
        String string3 = "vol." + n;
        String string4 = "lun." + n;
        String string5 = "Undefined";
        String string6 = "0";
        String string7 = "OK";
        String string8 = OK_AVAILABILITY;
        deviceClass.setClassName("StorageVolume");
        deviceClass.setProperty("Caption", "Volume");
        deviceClass.setProperty("Description", "Logical storage grouping (aka: storage pool)");
        deviceClass.setProperty("DeviceID", string3);
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_StorageVolume");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        string5 = this.rack.getStringValue(string4, "lunVolName");
        if (string5 == null) {
            string5 = this.rack.getStringValue(string4, "lunName");
        }
        deviceClass.setProperty("Name", string5);
        string6 = this.truncate(this.rack.getStringValue(string4, "lunCapacity"));
        if (string6 != null) {
            deviceClass.setProperty("Capacity", string6);
        }
        if ("VIRTUAL DRV".equals(string2 = this.rack.getStringValue(string4, "lunType")) || "T3".equalsIgnoreCase(string2) || "6120".equals(string2)) {
            string = this.rack.getStringValue(string4, "lunStatus");
            string7 = this.convertToCIMStatus(string);
            string8 = this.convertToCIMAvailability(string7);
        }
        deviceClass.setProperty("Status", string7);
        deviceClass.setProperty("Availability", string8);
        deviceClass.setProperty("WWN", this.rack.getStringValue(string4, "lunWwn"));
        string = this.rack.getStringValue(string4, "lunRaidLevel");
        ReportTools.xmlStringAttr((DeviceClass)deviceClass, (String)"RaidLevel", (String)string, (String)"Not specified");
        String string9 = this.rack.getStringValue(string4, "lunCacheMode");
        ReportTools.xmlStringAttr((DeviceClass)deviceClass, (String)"CacheMode", (String)string9, (String)"Not specified");
        deviceClass.setProperty("PowerManagementSupported", "false");
    }

    protected void updateLogicalDisk(DeviceClass deviceClass, int n, String string) {
        String string2 = string + "." + n;
        String string3 = string + "." + n;
        deviceClass.setClassName("LogicalDisk");
        deviceClass.setProperty("Caption", "Volume");
        deviceClass.setProperty("Description", "Logical division of a storage pool (ie: a volume)");
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_LogicalDisk");
        deviceClass.setProperty("SystemCreationClassName", "StorEdgeRack_AdminDomain");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("DeviceID", string2);
        String string4 = string2;
        String string5 = UNKNOWN_STATUS;
        if ("slice".equals(string)) {
            string4 = this.rack.getStringValue(string3, "volSliceName");
            string5 = this.rack.getStringValue(string3, "volId");
        } else {
            string4 = this.rack.getStringValue(string3, "ElementName");
        }
        deviceClass.setProperty("Name", string4);
        deviceClass.setProperty("SourceVolume", string5);
        String string6 = "0";
        String string7 = "0";
        if ("volume".equals(string)) {
            string6 = this.rack.getStringValue(string3, "VolumeSize");
            string7 = this.convertCapacity(string6);
            String string8 = this.parseVolumeWWN(this.rack.getStringValue(string3, "DeviceID"));
            if (string8 != null) {
                deviceClass.setProperty("DeviceID", string8);
            }
            String string9 = UNKNOWN_STATUS;
            String string10 = "2";
            if (string6 != null) {
                if (string6.equals(BLANK)) {
                    string9 = "Stopped";
                    string10 = "8";
                } else if (string6.equalsIgnoreCase("N/A")) {
                    string9 = "Starting";
                    string10 = "20";
                } else if (string7.length() > 0) {
                    string9 = "OK";
                    string10 = OK_AVAILABILITY;
                }
            }
            deviceClass.setProperty("Status", string9);
            deviceClass.setProperty("Availability", string10);
        } else {
            string6 = this.truncate(this.rack.getStringValue(string3, "volSliceSize"));
            try {
                int n2 = Integer.parseInt(string6);
                if (n2 > 0) {
                    string7 = Integer.toString(n2 /= 1024);
                }
            }
            catch (NumberFormatException numberFormatException) {
                string7 = "0";
            }
            deviceClass.setProperty("Status", UNKNOWN_STATUS);
            deviceClass.setProperty("Availability", "2");
        }
        ReportTools.xmlIntAttr((DeviceClass)deviceClass, (String)"Capacity", (String)string7);
    }

    private String parseVolumeWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
        }
        return stringBuffer.toString().toUpperCase();
    }

    protected void updateRack(DeviceClass deviceClass) {
        deviceClass.setClassName("Rack");
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_Rack");
        deviceClass.setProperty("Tag", this.systemName);
        deviceClass.setProperty("Name", this.systemName);
        deviceClass.setProperty("Status", UNKNOWN_STATUS);
        deviceClass.setProperty("Caption", "Storage Rack");
        deviceClass.setProperty("Description", "Storage Rack");
        deviceClass.setProperty("Manufacturer", this.rack.getStringValue("info", "vendor"));
        deviceClass.setProperty("Model", this.rack.getStringValue("info", "model"));
        deviceClass.setProperty("SerialNumber", this.rack.getStringValue("info", "serialNumber"));
        deviceClass.setProperty("PoweredOn", "true");
        deviceClass.setProperty("Removable", "false");
        deviceClass.setProperty("Replaceable", "false");
        deviceClass.setProperty("HotSwappable", "false");
    }

    protected void updatePhysicalPackage(DeviceClass deviceClass, String string, int n, HashMap hashMap) {
        String string2 = this.rack.getStringValue("fru." + n, "status");
        String string3 = this.convertToCIMStatus(string2);
        String string4 = this.rack.getStringValue("fru." + n, "fruSlot");
        deviceClass.setClassName("PhysicalPackage");
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_PhysicalPackage");
        deviceClass.setProperty("REF", "fru." + n);
        if (hashMap != null) {
            hashMap.put("fru." + n, "slot." + string4);
        }
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("Caption", string);
        deviceClass.setProperty("Description", string);
        if (string.equals("sp")) {
            this.updateSvcProcPhysicalPackage(deviceClass, string, n, string4);
        } else if (string.equals("switch")) {
            this.updateSwitchPhysicalPackage(deviceClass, string, n, string4);
        } else if (string.equals("ve")) {
            this.updateVicommPhysicalPackage(deviceClass, string, n, string4);
        } else if (string.startsWith("SRC") || string.startsWith("SFC") || string.startsWith("SIO") || string.startsWith("MIC")) {
            this.updateDSPPhysicalPackage(deviceClass, string, n, string4);
        } else {
            deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string4, "dev-name") + "." + string);
            String string5 = this.rack.getStringValue("fru." + n, "fruSerialNo");
            if (string5 == null) {
                string5 = BLANK;
            }
            deviceClass.setProperty("Tag", string5);
            String string6 = this.rack.getStringValue("fru." + n, "fruVendor");
            if (string6 == null) {
                string6 = BLANK;
            }
            deviceClass.setProperty("Manufacturer", string6);
            String string7 = this.rack.getStringValue("fru." + n, "fruModel");
            if (string7 == null) {
                string7 = BLANK;
            }
            deviceClass.setProperty("Model", string7);
            String string8 = this.rack.getStringValue("fru." + n, "fruSerialNo");
            if (string8 == null) {
                string8 = BLANK;
            }
            deviceClass.setProperty("SerialNumber", string8);
            String string9 = this.rack.getStringValue("fru." + n, "fruRevision");
            if (string.equals("midplane") || string.equals("controllerCard")) {
                deviceClass.setProperty("Removable", "false");
            } else {
                deviceClass.setProperty("Removable", "true");
            }
            if (string9 == null) {
                string9 = BLANK;
            }
            deviceClass.setProperty("Version", string9);
            deviceClass.setProperty("Replaceable", "true");
            if (string.equals("midplane") || string.equals("sp")) {
                deviceClass.setProperty("HotSwappable", "false");
            } else {
                deviceClass.setProperty("HotSwappable", "true");
            }
        }
    }

    protected void updateSvcProcPhysicalPackage(DeviceClass deviceClass, String string, int n, String string2) {
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        deviceClass.setProperty("Tag", this.rack.getStringValue("slot." + string2, "dev-key"));
        deviceClass.setProperty("Model", this.rack.getStringValue("fru." + n, "info-model"));
        String string3 = this.rack.getStringValue("fru." + n, "info-model");
        if (string3 == null) {
            string3 = BLANK;
        }
        deviceClass.setProperty("Version", string3);
        deviceClass.setProperty("Removable", "false");
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("HotSwappable", "false");
    }

    protected void updateSwitchPhysicalPackage(DeviceClass deviceClass, String string, int n, String string2) {
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        deviceClass.setProperty("Tag", this.rack.getStringValue("slot." + string2, "dev-key"));
        String string3 = this.rack.getStringValue("fru." + n, "version-HW");
        if (string3 == null) {
            string3 = BLANK;
        }
        deviceClass.setProperty("Version", string3);
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("Removable", "false");
        deviceClass.setProperty("HotSwappable", "false");
    }

    protected void updateDSPPhysicalPackage(DeviceClass deviceClass, String string, int n, String string2) {
        String string3;
        this.xmlAttr(deviceClass, "Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        this.xmlAttr(deviceClass, "Model", this.rack.getStringValue("fru." + n, "Type"));
        this.xmlAttr(deviceClass, "Manufacturer", "Sun");
        String string4 = this.rack.getStringValue("fru." + n, "SerialNumber");
        if (string4 == null) {
            string3 = this.rack.getStringValue("fru." + n, "fruId");
            string4 = string + "." + string3;
        }
        this.xmlAttr(deviceClass, "Tag", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string4);
        string3 = this.rack.getStringValue("fru." + n, "HWRev");
        this.xmlAttr(deviceClass, "Version", string3);
        this.xmlAttr(deviceClass, "Removable", "false");
        this.xmlAttr(deviceClass, "Replaceable", "true");
        this.xmlAttr(deviceClass, "HotSwappable", "true");
    }

    protected void updateVicommPhysicalPackage(DeviceClass deviceClass, String string, int n, String string2) {
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + string2, "dev-name"));
        deviceClass.setProperty("Tag", this.rack.getStringValue("slot." + string2, "dev-key"));
        String string3 = this.rack.getStringValue("fru." + n, "fruModel");
        if (string3 == null) {
            string3 = BLANK;
        }
        deviceClass.setProperty("Model", string3);
        String string4 = this.rack.getStringValue("fru." + n, "fruSerialNo");
        if (string4 == null) {
            string4 = BLANK;
        }
        deviceClass.setProperty("SerialNumber", string4);
        String string5 = this.rack.getStringValue("fru." + n, "version");
        if (string5 == null) {
            string5 = BLANK;
        }
        deviceClass.setProperty("Version", string5);
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("Removable", "false");
        deviceClass.setProperty("HotSwappable", "true");
    }

    protected void updateSlot(DeviceClass deviceClass, int n) {
        String string;
        String string2 = this.rack.getStringValue("slot." + n, "dev-type");
        deviceClass.setClassName("Slot");
        deviceClass.setProperty("CreationClassName", "StorEdgeRack_Slot");
        deviceClass.setProperty("REF", "slot." + n);
        deviceClass.setProperty("Tag", this.rack.getStringValue("slot." + n, "dev-key"));
        deviceClass.setProperty("Name", this.rack.getStringValue("slot." + n, "dev-name"));
        String string3 = this.rack.getStringValue("slot." + n, "status-avail");
        if (string3 != null) {
            string = this.convertStatusAvailToCIMStatus(string3);
            deviceClass.setProperty("Status", string);
        } else {
            deviceClass.setProperty("Status", UNKNOWN_STATUS);
        }
        deviceClass.setProperty("Caption", "StorEdge Rack slot");
        deviceClass.setProperty("Description", "This slot holds a component of type " + string2);
        string = this.rack.getStringValue("slot." + n, "dev-type");
        this.xmlAttr(deviceClass, "Model", string);
        deviceClass.setProperty("PoweredOn", "true");
        deviceClass.setProperty("SupportsHotPlug", "true");
        deviceClass.setProperty("Number", Integer.toString(n));
    }

    private void xmlAttr(DeviceClass deviceClass, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        deviceClass.setProperty(string, string2);
    }

    protected void updateFRU(DeviceClass deviceClass, String string, int n) {
        String string2;
        deviceClass.setClassName("FRU");
        deviceClass.setProperty("FRUNumber", Integer.toString(n));
        deviceClass.setProperty("IdentifyingNumber", "fru." + n);
        if (!(string.equals("sp") || string.equals("ve") || string.equals("switch"))) {
            string2 = this.rack.getStringValue("fru." + n, "fruVendor");
            if (string2 == null) {
                string2 = BLANK;
            }
            deviceClass.setProperty("Vendor", string2);
        }
        deviceClass.setProperty("Name", string);
        string2 = null;
        if (string.equals("switch")) {
            string2 = this.rack.getStringValue("fru." + n, "version-HW");
        } else if (string.equals("ve")) {
            string2 = this.rack.getStringValue("fru." + n, "version");
        } else if (string.startsWith("SRC") || string.startsWith("SFC") || string.startsWith("SIO") || string.startsWith("MIC")) {
            string2 = this.rack.getStringValue("fru." + n, "HWRev");
        } else if (!string.equals("sp")) {
            string2 = this.rack.getStringValue("fru." + n, "fruRevision");
        }
        if (string2 == null) {
            string2 = BLANK;
        }
        deviceClass.setProperty("RevisionLevel", string2);
        deviceClass.setProperty("Description", string);
        deviceClass.setProperty("Caption", string);
    }

    protected void updateLocation(DeviceClass deviceClass, String string, int n) {
        deviceClass.setClassName("Location");
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("PhysicalPosition", this.rack.getStringValue("fru." + n, "fruSlot"));
        deviceClass.setProperty("Address", "500 Eldorado Blvd.");
        deviceClass.setProperty("Description", "string");
        deviceClass.setProperty("Caption", "string");
    }

    protected void addPackageInSlotAssociation(DeviceClass deviceClass, String string, String string2) {
        deviceClass.setClassName("PackageInSlot");
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("Antecedent");
        deviceClass2.setProperty("REF", string);
        DeviceClass deviceClass3 = deviceClass.newSubInstance();
        deviceClass3.setClassName("Dependent");
        deviceClass3.setProperty("REF", string2);
    }

    private String convertToCIMStatus(String string) {
        String string2 = UNKNOWN_STATUS;
        try {
            if (string.equalsIgnoreCase("ready") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("mounted") || string.equalsIgnoreCase("online")) {
                string2 = "OK";
            } else if (string.equalsIgnoreCase("fault") || string.equalsIgnoreCase("failed / absent")) {
                string2 = "Error";
            } else if (string.equalsIgnoreCase("offline") || string.equalsIgnoreCase("deleted")) {
                string2 = "NonRecover";
            } else if (string.equalsIgnoreCase("uninitialized") || string.equalsIgnoreCase("unmounted")) {
                string2 = "Service";
            } else if (string.equalsIgnoreCase("Standing By")) {
                string2 = "Stopped";
            } else if (string.equalsIgnoreCase("notInstalled")) {
                string2 = UNKNOWN_STATUS;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return string2;
    }

    private String convertStatusAvailToCIMStatus(String string) {
        String string2 = UNKNOWN_STATUS;
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 0: {
                    string2 = "Error";
                    break;
                }
                case 1: {
                    string2 = "OK";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return string2;
    }

    private String convertToCIMStatusInfo(String string) {
        int n = 2;
        try {
            if (string.equalsIgnoreCase("enabled") || string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("normal")) {
                n = 3;
            } else if (string.equalsIgnoreCase("disabled") || string.equalsIgnoreCase("failed / absent") || string.equalsIgnoreCase("standing by") || string.equalsIgnoreCase("notInstalled")) {
                n = 4;
            } else if (string.equalsIgnoreCase("other") || string.equalsIgnoreCase("fault")) {
                n = 1;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return Integer.toString(n);
    }

    private String convertToCIMAvailability(String string, String string2) {
        int n;
        block9: {
            int n2;
            n = 2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 2;
            }
            try {
                if (string.equals("Service")) {
                    n = 8;
                    break block9;
                }
                if (n2 == 4 || string.equals("NonRecover")) {
                    n = 8;
                    break block9;
                }
                if (string.equals("OK")) {
                    n = 3;
                    break block9;
                }
                if (string.equals("Error")) {
                    if (n2 == 3 || n2 == 2) {
                        n = 10;
                        break block9;
                    }
                    if (n2 != 3) break block9;
                    n = 8;
                    break block9;
                }
                n = 11;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return Integer.toString(n);
    }

    private String convertToCIMAvailability(String string) {
        int n;
        block6: {
            n = 2;
            try {
                if (string.equals("OK")) {
                    n = 3;
                    break block6;
                }
                if (string.equals("Error") || string.equals("Stopped") || string.equals("Service") || string.equals("NonRecover")) {
                    n = 8;
                    break block6;
                }
                if (string.equals("Degraded")) {
                    n = 10;
                    break block6;
                }
                if (string.equals(UNKNOWN_STATUS)) {
                    n = 2;
                    break block6;
                }
                n = 2;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return Integer.toString(n);
    }

    private String truncate(String string) {
        String string2 = null;
        try {
            string2 = string.substring(0, string.indexOf("."));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return string;
        }
        return string2;
    }

    protected int getCount(String string) {
        int n = 0;
        try {
            n = this.rack.getIntValue(string);
        }
        catch (SERackException sERackException) {
            Report.warning.log((Object)("Error getting count " + sERackException.toString()));
        }
        return n;
    }
}

