/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.io;

import com.sun.jade.device.rack.serack.io.SERackException;
import com.sun.jade.device.rack.serack.io.SERackToken;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Vector;

public class SERackTokenList {
    private static final String sccs_id = "@(#)SERackTokenList.java\t1.0 05/22/02 SMI";
    Vector list;

    public SERackTokenList(String string) {
        Vector<SERackToken> vector = new Vector<SERackToken>();
        int n = 0;
        int n2 = 0;
        try {
            while (true) {
                SERackToken sERackToken;
                if ((sERackToken = new SERackToken(string.substring(n, n2 = string.indexOf("\n", n)))).getElementID() != null) {
                    vector.add(sERackToken);
                }
                n = n2 + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.list = vector;
            return;
        }
    }

    public SERackTokenList(Vector vector) {
        this.list = vector;
    }

    public SERackToken findToken(String string) {
        if (this.list == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            SERackToken sERackToken = (SERackToken)this.list.get(n);
            if (string.equals(sERackToken.getPropertyKey())) {
                return sERackToken;
            }
            ++n;
        }
        return null;
    }

    public SERackToken findToken(String string, String string2) {
        if (this.list == null || string == null || string2 == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            SERackToken sERackToken = (SERackToken)this.list.get(n);
            if (string2.equals(sERackToken.getPropertyKey()) && string.equals(sERackToken.getElementID())) {
                return sERackToken;
            }
            ++n;
        }
        return null;
    }

    public String getStringValue(String string) {
        SERackToken sERackToken = this.findToken(string);
        if (sERackToken == null) {
            return null;
        }
        return sERackToken.getPropertyValue();
    }

    public String getStringValue(String string, String string2) {
        SERackToken sERackToken = this.findToken(string, string2);
        if (sERackToken == null) {
            return null;
        }
        return sERackToken.getPropertyValue();
    }

    public int getIntValue(String string, String string2) throws SERackException {
        SERackToken sERackToken = this.findToken(string, string2);
        if (sERackToken == null) {
            throw new SERackException("serack.exception.noToken", string + "," + string2);
        }
        try {
            Integer n = new Integer(sERackToken.getPropertyValue());
            return n;
        }
        catch (Exception exception) {
            throw new SERackException(exception.getLocalizedMessage());
        }
    }

    public int getIntValue(String string) throws SERackException {
        SERackToken sERackToken = this.findToken(string);
        if (sERackToken == null) {
            throw new SERackException("serack.exception.noToken", string);
        }
        try {
            Integer n = new Integer(sERackToken.getPropertyValue());
            return n;
        }
        catch (Exception exception) {
            throw new SERackException(exception.getLocalizedMessage());
        }
    }

    public float getFloatValue(String string, String string2) throws SERackException {
        SERackToken sERackToken = SERackToken.findToken(this.list, string, string2);
        if (sERackToken == null) {
            throw new SERackException("serack.exception.noToken", string + "," + string2);
        }
        try {
            Float f = new Float(sERackToken.getPropertyValue());
            return f.floatValue();
        }
        catch (Exception exception) {
            throw new SERackException(exception.getLocalizedMessage());
        }
    }

    public Vector getElementIDs() {
        Vector<String> vector = new Vector<String>();
        if (this.list != null) {
            int n = 0;
            while (n < this.list.size()) {
                SERackToken sERackToken = (SERackToken)this.list.get(n);
                if (!vector.contains(sERackToken.getElementID())) {
                    vector.add(sERackToken.getElementID());
                }
                ++n;
            }
        }
        return vector;
    }

    public static class Test
    extends UnitTest {
        static void main(String[] stringArray) throws Exception {
            UnitTest unitTest = new UnitTest();
            String string = "fcPort.1.CRC\t0\nfcPort.1.LocalPortWWN\t200700c0dd00b1f4\nfru.1.fruSlot\t1\nfru.1.fruType\tswitch\nfru.2.fruSlot\t2\nfru.2.fruType\tdiskDrive\nlun.107.lunCapacity\t1024\nlun.107.lunId\tVDRV011\nfru.3.capacity\t90.7\nfru.3.name\tG9862\n";
            SERackTokenList sERackTokenList = new SERackTokenList(string);
            unitTest.assertNotNull((Object)sERackTokenList.findToken("fruSlot"));
            unitTest.assertEquals((Object)"VDRV011", (Object)sERackTokenList.findToken("lunId").getPropertyValue());
            unitTest.assertNull((Object)sERackTokenList.findToken("status"));
            unitTest.assertEquals((Object)"diskDrive", (Object)sERackTokenList.findToken("fru.2", "fruType").getPropertyValue());
            unitTest.assertCondition("Did not get 1024 as an integer", 1024 == sERackTokenList.getIntValue("lun.107", "lunCapacity"));
            unitTest.assertCondition("Did not get 90.7 as a float", 90.7f == sERackTokenList.getFloatValue("fru.3", "capacity"));
            unitTest.assertNotNull((Object)sERackTokenList.getElementIDs());
            unitTest.assertCondition("Inaccurate count of unique element IDs", 5 == sERackTokenList.getElementIDs().size());
        }
    }
}

