/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.maps;

import com.sun.netstorage.mgmt.esm.util.l10n.properties.Name;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.maps.IllegalNumberMapException;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberEnum;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberValueConstraint;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberValueException;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings.StringEnum;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings.StringValidator;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings.StringValueException;

public abstract class NumberMap
extends NumberValueConstraint
implements StringValidator {
    private static final String SCCS_ID = "@(#)NumberMap.java 1.2   03/04/07 SMI";
    private final NumberEnum myNumberEnum;
    private final StringEnum myStringEnum;

    public NumberMap(Name name, NumberEnum numberEnum, StringEnum stringEnum) {
        super(name);
        this.myNumberEnum = numberEnum;
        this.myStringEnum = stringEnum;
        this.check();
    }

    public final NumberEnum getNumberEnum() {
        return this.myNumberEnum;
    }

    public final StringEnum getStringEnum() {
        return this.myStringEnum;
    }

    private void check() throws IllegalNumberMapException {
        if (this.myNumberEnum == null) {
            throw new IllegalNumberMapException.NullEnum(this, "NumberEnum");
        }
        if (this.myStringEnum == null) {
            throw new IllegalNumberMapException.NullEnum(this, "StringEnum");
        }
        if (this.myNumberEnum.size() != this.myStringEnum.size()) {
            throw new IllegalNumberMapException.UnequalSize(this, this.myNumberEnum.size(), this.myStringEnum.size());
        }
    }

    public boolean isValueValid(String string) {
        return this.myStringEnum.isValueValid(string);
    }

    public void validateValue(String string) throws StringValueException {
        this.myStringEnum.validateValue(string);
    }

    protected final boolean isValueValid(Number number) {
        return this.myNumberEnum.isValueValid(number);
    }

    protected final void validateValue(Number number) throws NumberValueException {
        this.myNumberEnum.validateValue(number);
    }
}

