/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.component.model.engine;

import com.sun.netstorage.mgmt.component.model.engine.ConnectionException;
import com.sun.netstorage.mgmt.component.model.engine.SyncQueue;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;

class ConnectionPool {
    private String databaseURL_;
    private String databaseUser_;
    private String databasePassword_;
    private SyncQueue pool_;
    private HashSet inUse_ = new HashSet();
    private Object monitor_ = new Object();
    private long maxTimeout_ = 10000L;
    private int maxCount_;
    static final String sccs_id = "@(#)ConnectionPool.java 1.16   02/02/21 SMI";

    ConnectionPool(String string, String string2, String string3, String string4, int n, int n2, long l) throws ClassNotFoundException, SQLException {
        this.loadDriver(string);
        this.databaseURL_ = string2;
        this.databaseUser_ = string3;
        this.databasePassword_ = string4;
        this.maxCount_ = n2;
        this.maxTimeout_ = l;
        this.pool_ = new SyncQueue();
        int n3 = 0;
        while (n3 < n) {
            Connection connection = this.createConnection();
            this.pool_.put(connection);
            this.inUse_.add(connection);
            ++n3;
        }
    }

    private void loadDriver(String string) throws ClassNotFoundException {
        Class.forName(string);
    }

    private Connection createConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.databaseURL_, this.databaseUser_, this.databasePassword_);
        connection.setAutoCommit(false);
        return connection;
    }

    public void releaseConnection(Connection connection) {
        block3: {
            try {
                if (!connection.isClosed()) {
                    connection.clearWarnings();
                    this.pool_.put(connection);
                    break block3;
                }
                this.removeConnection(connection);
            }
            catch (Exception exception) {
                this.removeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connection connection) {
        try {
            Object object = this.monitor_;
            synchronized (object) {
                this.inUse_.remove(connection);
            }
            connection.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws ConnectionException {
        Connection connection = null;
        try {
            while (connection == null) {
                Object object = this.monitor_;
                synchronized (object) {
                    if (this.pool_.isEmpty() && this.inUse_.size() < this.maxCount_) {
                        connection = this.createConnection();
                        this.inUse_.add(connection);
                        return connection;
                    }
                    connection = (Connection)this.pool_.poll(this.maxTimeout_);
                }
                if (connection == null) {
                    throw new ConnectionException("timed_out");
                }
                try {
                    if (!connection.isClosed()) {
                        return connection;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.removeConnection(connection);
                connection = null;
            }
            return connection;
        }
        catch (Exception exception) {
            throw new ConnectionException(exception);
        }
    }
}

