/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t4.service;

import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.device.array.t4.service.T4ReportGenerator;
import com.sun.jade.util.log.Report;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class T4StatusCalculator {
    private static final double FULLY_AVAILABLE_WEIGHT = 0.999;
    private static final double OFFLINE_WEIGHT = 0.0;
    private static final int REQUIRED_LOOP_COUNT = 1;
    private static final int REQUIRED_PCU_COUNT = 1;
    private static final int REQUIRED_MIDPLANE_COUNT = 1;
    private static final int REQUIRED_CONTROLLER_COUNT = 1;
    private static final int REQUIRED_UCS_COUNT = 1;
    private static final int REQUIRED_DISK_COUNT = 4;
    private static final int MAX_REQUIRED_DISK_COUNT = 13;
    private static final int MIN_REQUIRED_DISK_COUNT = 4;
    private static final String FULLY_REDUNDANT = "2";
    private static final String LOG_TAG = "T4_Availability_Algorithm";
    public static final String sccs_id = "@(#)T4StatusCalculator.java\t1.2 10/08/02 SMI";

    public static String deriveClusterStatus(Vector vector) {
        double d = T4StatusCalculator.redundantComponentAvailability(vector, 1);
        if (d < 0.9) {
            return "Error";
        }
        return "OK";
    }

    public static String deriveUnitStatus(T3TokenList t3TokenList, int n) {
        double d = T4StatusCalculator.calculateSystemAvailability(t3TokenList, n);
        if (d < 0.9) {
            return "Error";
        }
        return "OK";
    }

    private static double calculateSystemAvailability(T3TokenList t3TokenList, int n) {
        double d = 1.0;
        String[] stringArray = new String[]{"fruStatus", "fruState"};
        int n2 = 0;
        while (n2 < stringArray.length) {
            Hashtable hashtable = T4StatusCalculator.getFRUCollection(t3TokenList, stringArray[n2], n);
            Iterator iterator = hashtable.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Vector vector = (Vector)entry.getValue();
                double d2 = 0.0;
                int n3 = T4StatusCalculator.getNumReqComponent(string);
                d2 = T4StatusCalculator.redundantComponentAvailability(vector, n3);
                d = d2 * d;
            }
            ++n2;
        }
        Report.debug.log(LOG_TAG, (Object)("Overall Unit " + n + " Status Weight " + d));
        return d;
    }

    private static int getNumReqComponent(String string) {
        if ("diskDrive".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("loopCard".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("powerUnit".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("controller".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("midplane".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("unit".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    private static Hashtable getFRUCollection(T3TokenList t3TokenList, String string, int n) {
        Hashtable<String, Collection> hashtable = new Hashtable<String, Collection>();
        Collection collection = t3TokenList.findTokensWithKey(string);
        hashtable.put("diskDrive", T4StatusCalculator.filterTokens(collection, "u" + n + "d"));
        hashtable.put("loopCard", T4StatusCalculator.filterTokens(collection, "u" + n + "l"));
        hashtable.put("midplane", T4StatusCalculator.filterTokens(collection, "u" + n + "mpn"));
        hashtable.put("controller", T4StatusCalculator.filterTokens(collection, "u" + n + "ctr"));
        hashtable.put("powerUnit", T4StatusCalculator.filterTokens(collection, "u" + n + "pcu"));
        return hashtable;
    }

    private static Collection filterTokens(Collection collection, String string) {
        Vector<T3Token> vector = new Vector<T3Token>();
        if (string == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            T3Token t3Token = (T3Token)iterator.next();
            if (!t3Token.getElementID().startsWith(string) || !(T4StatusCalculator.availabilityWeightMap(t3Token) > 0.9)) continue;
            vector.add(t3Token);
        }
        return vector;
    }

    private static double availabilityWeightMap(T3Token t3Token) {
        if ("fruStatus".equals(t3Token.getPropertyKey())) {
            if ("fault".equalsIgnoreCase(t3Token.getPropertyValue())) {
                return 0.0;
            }
            return 0.999;
        }
        if ("fruState".equals(t3Token.getPropertyKey())) {
            if ("disabled".equalsIgnoreCase(t3Token.getPropertyValue())) {
                return 0.0;
            }
            return 0.999;
        }
        if ("unitStatus".equals(t3Token.getPropertyKey())) {
            if ("OK".equalsIgnoreCase(t3Token.getPropertyValue())) {
                return 0.999;
            }
            return 0.0;
        }
        return 0.999;
    }

    private static double redundantComponentAvailability(Vector vector, int n) {
        double d = 0.0;
        int n2 = n;
        while (n2 <= vector.size()) {
            d += T4StatusCalculator.redundantComponentFormula(vector.elementAt(n2 - 1), n2, vector.size());
            ++n2;
        }
        Report.debug.log(LOG_TAG, (Object)("Redundant Component Availability(inside formula)" + d));
        return d;
    }

    private static double redundantComponentFormula(Object object, int n, int n2) {
        double d = 0.0;
        T3Token t3Token = (T3Token)object;
        try {
            int n3 = n2 - n;
            double d2 = T4StatusCalculator.calculateFactorial(n2) / (T4StatusCalculator.calculateFactorial(n) * T4StatusCalculator.calculateFactorial(n3));
            double d3 = Math.pow(T4StatusCalculator.availabilityWeightMap(t3Token), n);
            Report.debug.log(LOG_TAG, (Object)("The A Value " + d3));
            double d4 = Math.pow(1.0 - T4StatusCalculator.availabilityWeightMap(t3Token), n3);
            Report.debug.log(LOG_TAG, (Object)("The 1-A Value " + d4));
            d = d2 * d3 * d4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Report.debug.log(LOG_TAG, (Object)("Token Name " + t3Token.toString() + " Availability --> " + d));
        return d;
    }

    private static int calculateFactorial(int n) {
        int n2 = 1;
        if (n == 0) {
            return n2;
        }
        int n3 = 1;
        while (n3 <= n) {
            n2 *= n3;
            ++n3;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        Object object;
        T3TokenList t3TokenList = null;
        if (stringArray.length < 1) {
            System.out.println("Usage:java com.sun.jade.device.array.t4.service.T4StatusCalculator < SIMULATEDT4 | REALT4 >");
            System.exit(0);
        }
        if ("SIMULATEDT4".equalsIgnoreCase(stringArray[0].trim())) {
            System.out.println("Availability Fault Injection Choice");
            System.out.println("1. All FRU's Fully Available");
            System.out.println("2. One Disk Drive in Unit 1 not Fully Available");
            System.out.println("3. Two Disk Drive in Unit 1 not Fully Available");
            System.out.println("4. Two Disk Drive in Unit 1 and One Disk Drive in Unit 2 is not Fully Available");
            System.out.println("5. Two Disk Drives, in each of Unit 1 & Unit 2 is not Fully Available");
            System.out.print("Enter Choice -->(1,2,3,4,5):");
            object = ";u1d01,fruStatus,ready;;u1d02,fruStatus,ready;;u1d03,fruStatus,ready;;u1d04,fruStatus,ready;;u1d05,fruStatus,ready;;u1d06,fruStatus,ready;;u1d07,fruStatus,ready;;u1d08,fruStatus,ready;;u1d09,fruStatus,ready;;u1d10,fruStatus,ready;;u1d11,fruStatus,ready;;u1d12,fruStatus,ready;;u1ctr,fruStatus,ready;;u1l1,fruStatus,ready;;u1l2,fruStatus,ready;;u1pcu1,fruStatus,ready;;u1pcu2,fruStatus,ready;;u1mpn,fruStatus,ready;;u1d01,fruState,enabled;;u1d02,fruState,enabled;;u1d03,fruState,enabled;;u1d04,fruState,enabled;;u1d05,fruState,enabled;;u1d06,fruState,enabled;;u1d08,fruState,enabled;;u1d07,fruState,enabled;;u1d09,fruState,enabled;;u1d10,fruState,enabled;;u1d11,fruState,enabled;;u1d12,fruState,enabled;;u1ctr,fruState,enabled;;u1l1,fruState,enabled;;u1l2,fruState,enabled;;u1pcu1,fruState,enabled;;u1pcu2,fruState,enabled;;u1mpn,fruState,enabled;;u2d01,fruStatus,ready;;u2d02,fruStatus,ready;;u2d03,fruStatus,ready;;u2d04,fruStatus,ready;;u2d05,fruStatus,ready;;u2d06,fruStatus,ready;;u2d07,fruStatus,ready;;u2d08,fruStatus,ready;;u2d09,fruStatus,ready;;u2d10,fruStatus,ready;;u2d11,fruStatus,ready;;u2d12,fruStatus,ready;;u2ctr,fruStatus,ready;;u2l1,fruStatus,ready;;u2l2,fruStatus,ready;;u2pcu1,fruStatus,ready;;u2pcu2,fruStatus,ready;;u2mpn,fruStatus,ready;;u2d01,fruState,enabled;;u2d02,fruState,enabled;;u2d03,fruState,enabled;;u2d04,fruState,enabled;;u2d05,fruState,enabled;;u2d06,fruState,enabled;;u2d07,fruState,enabled;;u2d08,fruState,enabled;;u2d09,fruState,enabled;;u2d10,fruState,enabled;;u2d11,fruState,enabled;;u2d12,fruState,enabled;;u2ctr,fruState,enabled;;u2l1,fruState,enabled;;u2l2,fruState,enabled;;u2pcu1,fruState,enabled;;u2pcu2,fruState,enabled;;u2mpn,fruState,enabled;";
            int n = 0;
            try {
                n = System.in.read();
            }
            catch (IOException iOException) {
                System.exit(0);
            }
            switch (n) {
                case 49: {
                    object = (String)object + ";u1d13,fruStatus,ready;" + ";u1d14,fruStatus,ready;" + ";u1d13,fruState,enabled;" + ";u1d14,fruState,enabled;" + ";u2d13,fruStatus,ready;" + ";u2d14,fruStatus,ready;" + ";u2d13,fruState,enabled;" + ";u2d14,fruState,enabled;";
                    break;
                }
                case 50: {
                    object = (String)object + ";u1d13,fruStatus,ready;" + ";u1d14,fruStatus,fault;" + ";u1d13,fruState,enabled;" + ";u1d14,fruState,disabled;" + ";u2d13,fruStatus,ready;" + ";u2d14,fruStatus,ready;" + ";u2d13,fruState,enabled;" + ";u2d14,fruState,enabled;";
                    break;
                }
                case 51: {
                    object = (String)object + ";u1d13,fruStatus,fault;" + ";u1d14,fruStatus,fault;" + ";u1d13,fruState,disabled;" + ";u1d14,fruState,disabled;" + ";u2d13,fruStatus,ready;" + ";u2d14,fruStatus,ready;" + ";u2d13,fruState,enabled;" + ";u2d14,fruState,enabled;";
                    break;
                }
                case 52: {
                    object = (String)object + ";u1d13,fruStatus,fault;" + ";u1d14,fruStatus,fault;" + ";u1d13,fruState,disabled;" + ";u1d14,fruState,disabled;" + ";u2d13,fruStatus,fault;" + ";u2d14,fruStatus,ready;" + ";u2d13,fruState,disabled;" + ";u2d14,fruState,enabled;";
                    break;
                }
                case 53: {
                    object = (String)object + ";u1d13,fruStatus,fault;" + ";u1d14,fruStatus,fault;" + ";u1d13,fruState,disabled;" + ";u1d14,fruState,disabled;" + ";u2d13,fruStatus,fault;" + ";u2d14,fruStatus,fault;" + ";u2d13,fruState,disabled;" + ";u2d14,fruState,disabled;";
                    break;
                }
                default: {
                    System.out.println("Enter again...Invalid Entry");
                }
            }
            t3TokenList = new T3TokenList((String)object);
        } else {
            if (stringArray.length != 2) {
                System.out.println("Usage:java com.sun.jade.device.array.t4.service.T4StatusCalculator REALT4 <ip_address>");
                System.exit(0);
            }
            try {
                object = new Properties();
                ((Properties)object).setProperty("ip", stringArray[1]);
                System.out.println(stringArray[1]);
                T4ReportGenerator t4ReportGenerator = new T4ReportGenerator((Properties)object);
                t4ReportGenerator.collectOutOfBandData();
                t3TokenList = t4ReportGenerator.getCurrentTokenList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            object = new T4StatusCalculator();
            String string = T4StatusCalculator.deriveUnitStatus(t3TokenList, 1);
            System.out.println("The Unit Availability for unit 1 is  " + string);
            String string2 = T4StatusCalculator.deriveUnitStatus(t3TokenList, 2);
            System.out.println("The Unit Availability for unit 2 is  " + string2);
            T3Token t3Token = new T3Token("u1", "unitStatus", string);
            T3Token t3Token2 = new T3Token("u2", "unitStatus", string2);
            Vector<T3Token> vector = new Vector<T3Token>();
            vector.add(t3Token);
            vector.add(t3Token2);
            System.out.println("The Cluster Availability is " + T4StatusCalculator.deriveClusterStatus(vector));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("Usage:java com.sun.jade.device.array.t4.service.T4StatusCalculator  <SIMULATEDT4 | REALT4> <ipAddress>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

