/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.util;

import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.log.Report;

public class ReportUtil {
    public static void updateLogicalDisk(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = deviceClass2.getProperty("BlockSize");
        String string2 = deviceClass2.getProperty("NumBlocks");
    }

    public static boolean isInstalled(DeviceClass deviceClass) {
        boolean bl = true;
        String string = deviceClass.getProperty("Availability");
        if ("11".equals(string)) {
            bl = false;
        }
        return bl;
    }

    public static String convertToLogicalString(String string) {
        String string2 = string;
        try {
            if ("Yes".equalsIgnoreCase(string)) {
                string2 = "true";
            } else if ("No".equalsIgnoreCase(string)) {
                string2 = "false";
            }
        }
        catch (NullPointerException nullPointerException) {
            return string;
        }
        return string2;
    }

    public static String truncate(String string) {
        String string2 = null;
        try {
            string2 = string.substring(0, string.indexOf("."));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return string;
        }
        return string2;
    }

    public static String convertToCIMStatus(String string) {
        String string2 = "Unknown";
        try {
            if (string.equalsIgnoreCase("ready") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("mounted") || string.equalsIgnoreCase("online")) {
                string2 = "OK";
            } else if (string.equalsIgnoreCase("fault")) {
                string2 = "Error";
            } else if (string.equalsIgnoreCase("offline") || string.equalsIgnoreCase("deleted")) {
                string2 = "NonRecover";
            } else if (string.equalsIgnoreCase("unmounted") || string.equalsIgnoreCase("uninitialized") || string.equalsIgnoreCase("refreshing")) {
                string2 = "Service";
            } else if (string.equalsIgnoreCase("booting")) {
                string2 = "Starting";
            } else if (string.equalsIgnoreCase("notinstalled")) {
                string2 = "Stopped";
            }
        }
        catch (NullPointerException nullPointerException) {}
        return string2;
    }

    public static String convertToCIMStatusInfo(String string) {
        int n = 2;
        try {
            if (string.equalsIgnoreCase("enabled") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("online")) {
                n = 3;
            } else if (string.equalsIgnoreCase("disabled") || string.equalsIgnoreCase("offline") || string.equalsIgnoreCase("notInstalled")) {
                n = 4;
            } else if (string.equalsIgnoreCase("other") || string.equalsIgnoreCase("fault")) {
                n = 1;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return Integer.toString(n);
    }

    public static String convertToCIMAvailability(String string, String string2) {
        int n;
        block11: {
            int n2;
            n = 2;
            String string3 = ReportUtil.convertToCIMStatus(string);
            String string4 = ReportUtil.convertToCIMStatusInfo(string2);
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 2;
            }
            try {
                if ("notInstalled".equalsIgnoreCase(string)) {
                    n = 11;
                    break block11;
                }
                if (string3.equals("Starting")) {
                    n = 19;
                    break block11;
                }
                if (n2 == 4 || string3.equals("NonRecover")) {
                    n = 8;
                    break block11;
                }
                if (string3.equals("OK")) {
                    n = 3;
                    break block11;
                }
                if (!string3.equals("Error")) break block11;
                if (n2 == 3 || n2 == 2) {
                    n = 10;
                } else if (n2 == 3) {
                    n = 8;
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return Integer.toString(n);
    }

    public static String convertToCIMAvailability(String string) {
        int n = 2;
        String string2 = ReportUtil.convertToCIMStatus(string);
        try {
            if ("uninitialized".equals(string)) {
                n = 20;
            } else if ("unmounted".equals(string)) {
                n = 8;
            } else if ("refreshing".equals(string)) {
                n = 16;
            } else if (string2.equals("OK")) {
                n = 3;
            } else if ("notInstalled".equalsIgnoreCase(string)) {
                n = 11;
            } else if (string2.equals("Starting")) {
                n = 19;
            } else if (string2.equals("Error") || string2.equals("Service") || string2.equals("NonRecover")) {
                n = 8;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return Integer.toString(n);
    }

    public static String translateDiskCode(String string) {
        String string2 = "No description available";
        int n = 10;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (n) {
            case 0: {
                string2 = "Good drive, good sys area";
                break;
            }
            case 2: {
                string2 = "Unable to open the drive";
                break;
            }
            case 3: {
                string2 = "Unable to open the drive";
                break;
            }
            case 4: {
                string2 = "Temporary state of drive before disable occurs";
                break;
            }
            case 7: {
                string2 = "Drive is good, but has a bad sys area";
                break;
            }
            case 9: {
                string2 = "Drive is bypassed or does not exist";
            }
        }
        return string2;
    }

    public static long calculateBlockCount(String string, int n, String string2, String string3) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.warning.log((Object)("Array " + string2 + " vol " + string3 + " capacity (" + string + ") is not a number."));
            try {
                string = ReportUtil.truncate(string);
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        d *= 1000000.0;
        Double d2 = new Double(d /= (double)n);
        long l = d2.longValue();
        return l;
    }

    public static void xmlAttr(DeviceClass deviceClass, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        deviceClass.setProperty(string, string2);
    }

    public static void xmlStringAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        ReportUtil.xmlAttr(deviceClass, string, string2);
    }

    public static void xmlIntAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = "0";
        } else {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "0";
            }
        }
        ReportUtil.xmlAttr(deviceClass, string, string2);
    }

    public static void xmlFloatAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = "0.0";
        } else {
            try {
                Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "0.0";
            }
        }
        ReportUtil.xmlAttr(deviceClass, string, string2);
    }
}

