/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.service;

import com.sun.jade.cim.bean.StorEdgeArray_LogEntry;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.device.array.t3.service.ParserException;
import com.sun.jade.device.array.t3.service.T3MF;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.EventConstants;
import com.sun.jade.event.EventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMObjectPath;

public class T3SyslogParser {
    private static T3SyslogParser parser;
    private Vector t3List;
    private String syslogFileName;
    private long syslogIndex;
    private long syslogLength;
    private Timer timer;
    private int pollInterval;
    private Pattern diskNotice;
    private Pattern batteryNotice;
    private Pattern holdNotice;
    private Pattern error;
    private Pattern warning;
    private Pattern longWarning;
    private static final String ERROR = ": E: ";
    private static final String WARNING = ": W: ";
    private static final String LONG_WARNING = ": WARNING: ";
    private static final int BUFFER_SIZE = 1024;
    private static final String LAST_FILE_EXT = ".0";
    private static final String TYPE = "SE Array";
    private static final String SYSLOG_LOCATION = "/var/adm/";
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int DEFAULT_INTERVAL = 300;

    private T3SyslogParser(T3MF t3MF) throws ParserException {
        Properties properties = this.getSyslogProps();
        String string = properties.getProperty("SYSLOG_FILE");
        if (string == null) {
            Object[] objectArray = new Object[]{"SYSLOG_FILE", TYPE};
            throw new ParserException("resource.error", 1, objectArray);
        }
        this.syslogFileName = SYSLOG_LOCATION + string;
        this.t3List = new Vector();
        this.diskNotice = Pattern.compile(": [NI]: u\\dd\\d");
        this.batteryNotice = Pattern.compile(": N: u\\dpcu\\d.*Battery .*OK");
        this.holdNotice = Pattern.compile(": N: u\\dpcu\\d.*PCU\\d hold time");
        this.error = Pattern.compile(ERROR);
        this.warning = Pattern.compile(WARNING);
        this.longWarning = Pattern.compile(LONG_WARNING);
        try {
            this.syslogIndex = this.getSyslogLength();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.postParserError(string, t3MF);
            Object[] objectArray = new Object[]{SYSLOG_LOCATION + string};
            throw new ParserException("resource.error", 8, objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{SYSLOG_LOCATION + string};
            throw new ParserException("resource.error", 9, objectArray);
        }
        String string2 = properties.getProperty("SYSLOG_POLL_INTERVAL");
        try {
            this.pollInterval = Integer.parseInt(string2) * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            Report.error.log((Object)"No valid syslog poll interval found in device properties file. Setting interval to 5 minutes");
            this.pollInterval = 300000;
        }
        this.startPolling();
    }

    private Properties getSyslogProps() throws ParserException {
        Properties properties = null;
        try {
            properties = PropertiesPersister.restoreProperties((String)("syslog" + File.separator + "syslog.properties"));
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log((Object)"Failed to load properties from file syslog.properties");
        }
        if (properties == null) {
            Object[] objectArray = new Object[]{"SYSLOG_FILE", TYPE};
            throw new ParserException("resource.error", 1, objectArray);
        }
        return properties;
    }

    public static T3SyslogParser getParser(T3MF t3MF) throws ParserException {
        if (parser == null) {
            parser = new T3SyslogParser(t3MF);
        }
        return parser;
    }

    public synchronized void monitorDevice(T3MF t3MF) throws ParserException {
        if (!this.t3List.contains(t3MF)) {
            this.t3List.add(t3MF);
        }
        this.startPolling();
    }

    public synchronized void removeDevice(T3MF t3MF) {
        this.t3List.remove(t3MF);
        if (this.t3List.size() == 0) {
            this.stopPolling();
        }
    }

    private void parseLog() throws ParserException, FileNotFoundException, IOException {
        String string = null;
        this.syslogLength = this.getSyslogLength();
        if (this.syslogIndex > this.syslogLength) {
            try {
                string = this.readSyslog(this.syslogFileName + LAST_FILE_EXT);
                this.searchBuffer(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.syslogIndex = 0L;
        }
        string = this.readSyslog(this.syslogFileName);
        this.searchBuffer(string);
    }

    /*
     * Unable to fully structure code
     */
    private void searchBuffer(String var1_1) {
        try {
            var2_2 = new SyslogData(var1_1);
            while (var2_2.nextLineExists()) {
                block17: {
                    var3_4 = var2_2.getNextEntry();
                    if (this.error.matcher(var3_4).find()) {
                        while (var2_2.isNextLineAssociated(var3_4, this.error)) {
                            var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                        }
                        this.postEvent(var3_4, 5);
                        continue;
                    }
                    if (this.warning.matcher(var3_4).find()) {
                        while (var2_2.isNextLineAssociated(var3_4, this.warning)) {
                            var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                        }
                        this.postEvent(var3_4, 4);
                        continue;
                    }
                    if (this.longWarning.matcher(var3_4).find()) {
                        while (var2_2.isNextLineAssociated(var3_4, this.longWarning)) {
                            var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                        }
                        this.postEvent(var3_4, 4);
                        continue;
                    }
                    if (this.batteryNotice.matcher(var3_4).find()) {
                        while (var2_2.isNextLineAssociated(var3_4, this.batteryNotice)) {
                            var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                        }
                        this.postEvent(var3_4, 3);
                        continue;
                    }
                    if (this.holdNotice.matcher(var3_4).find()) {
                        while (var2_2.isNextLineAssociated(var3_4, this.holdNotice)) {
                            var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                        }
                        this.postEvent(var3_4, 3);
                        continue;
                    }
                    if (!this.diskNotice.matcher(var3_4).find()) continue;
                    if (!var2_2.lookAheadForPattern("Sense") || !var2_2.isNextLineFromSameT3(var3_4)) ** GOTO lbl44
                    var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                    if (!var2_2.lookAheadForPattern("Sense") || !var2_2.isNextLineFromSameT3(var3_4)) break block17;
                    var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                    if (!var2_2.nextLineExists() || !var2_2.isNextLineFromSameT3(var3_4)) break block17;
                    var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
                    break block17;
lbl-1000:
                    // 1 sources

                    {
                        var3_4 = var3_4.concat("\\\n" + var2_2.getNextEntry());
lbl44:
                        // 2 sources

                        ** while (var2_2.isNextLineAssociated((String)var3_4, (Pattern)this.diskNotice))
                    }
                }
                this.postEvent(var3_4, 3);
            }
        }
        catch (OutOfDataException var2_3) {}
    }

    private String readSyslog(String string) throws ParserException, FileNotFoundException, IOException {
        String string2;
        int n;
        RandomAccessFile randomAccessFile = null;
        StringBuffer stringBuffer = null;
        randomAccessFile = new RandomAccessFile(string, "r");
        long l = this.syslogIndex;
        randomAccessFile.seek(l);
        stringBuffer = new StringBuffer();
        byte[] byArray = new byte[1024];
        while ((n = randomAccessFile.read(byArray)) != -1) {
            string2 = new String(byArray, 0, n);
            stringBuffer.append(string2);
        }
        string2 = stringBuffer.toString();
        try {
            this.syslogIndex = randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            long l2;
            this.syslogIndex = l2 = this.syslogIndex + (long)string2.length();
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Report.error.log((Object)"Error closing the syslog file");
        }
        return string2;
    }

    private void postEvent(String string, int n) {
        int n2 = 0;
        while (n2 < this.t3List.size()) {
            T3MF t3MF = (T3MF)this.t3List.get(n2);
            String string2 = null;
            String string3 = t3MF.getIPAddr();
            String string4 = t3MF.getIPNum();
            if (string3 != null && string.indexOf(t3MF.getIPAddr()) != -1) {
                string2 = string3;
            } else if (string4 != null && string.indexOf(t3MF.getIPNum()) != -1) {
                string2 = string4;
            }
            if (string2 != null) {
                String string5 = ".definition.create.logEntry.array." + t3MF.getType();
                DefinitionEventData definitionEventData = new DefinitionEventData(n, EventConstants.SOURCE_PREFIX + "T3SyslogParser", this.generateSubject(t3MF), string5, "LogEntry", "logEntry", this.createEventPayload(string, string2));
                Object[] objectArray = new Object[]{string2};
                LocalizedString localizedString = new LocalizedString(string);
                definitionEventData.setDescription(localizedString);
                definitionEventData.setSubjectEnclosureIP(t3MF.getIPNum());
                EventGenerator.generateEvent((EventData)definitionEventData);
            }
            ++n2;
        }
    }

    private void postParserError(String string, T3MF t3MF) {
        String string2;
        String string3 = t3MF.getType();
        String string4 = "event.storage." + string3 + ".event";
        int n = 12;
        MessageCode messageCode = new MessageCode(string4, n);
        String string5 = t3MF.getIPAddr();
        String string6 = t3MF.getIPNum();
        String string7 = string2 = string5 != null ? string5 : string6;
        if (string2 == null) {
            string2 = t3MF.getName();
        }
        Object[] objectArray = new Object[]{string2, string};
        String string8 = CIMBeanUtil.getCOPSubject((CIMObjectPath)StoradeEnvironment.getAgentBean().getCIMObjectPath());
        String string9 = ".definition.create.logEntry.array." + string3 + ".notFound";
        DefinitionEventData definitionEventData = new DefinitionEventData(3, EventConstants.SOURCE_PREFIX + "T3SyslogParser", string8, string9, "LogEntry", "logEntry", this.createEventPayload(messageCode.getMessage(objectArray), "localhost"));
        definitionEventData.setDescription(messageCode.getLocalizedStringMessage(objectArray));
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            definitionEventData.setSubjectEnclosureIP(inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        EventGenerator.generateEvent((EventData)definitionEventData);
    }

    private String generateSubject(T3MF t3MF) {
        String string = "\":" + t3MF.getClassName() + ".CreationClassName=\\\"" + t3MF.getClassName() + "\\\",Name=\\\"" + t3MF.getName() + "\\\"\"";
        return string;
    }

    private CIMBean[] createEventPayload(String string, String string2) {
        StorEdgeArray_LogEntry storEdgeArray_LogEntry = new StorEdgeArray_LogEntry();
        storEdgeArray_LogEntry.setCreationClassName("StorEdgeArray_LogEntry");
        storEdgeArray_LogEntry.setLogName(this.syslogFileName);
        storEdgeArray_LogEntry.setDeviceName(string2);
        storEdgeArray_LogEntry.setEntry(string.replace(';', ','));
        return new CIMBean[]{storEdgeArray_LogEntry};
    }

    private long getSyslogLength() throws FileNotFoundException, IOException {
        long l = 0L;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.syslogFileName, "r");
        l = randomAccessFile.length();
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Report.error.log((Object)"Error closing the syslog file");
        }
        return l;
    }

    public void stopPolling() {
        this.timer.cancel();
        this.timer = null;
    }

    public void startPolling() {
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new PollingTask(), 0L, (long)this.pollInterval);
        }
    }

    public void updatePollingInterval(int n) {
        if (this.timer == null) {
            this.pollInterval = n;
        } else {
            this.stopPolling();
            this.pollInterval = n;
            this.startPolling();
        }
    }

    class OutOfDataException
    extends Exception {
        OutOfDataException() {
        }
    }

    private class SyslogData {
        private String syslogData;
        private int current;
        private int lineEnd;

        SyslogData(String string) throws OutOfDataException {
            if (string == null) {
                throw new OutOfDataException();
            }
            this.syslogData = string;
            this.current = 0;
            this.lineEnd = 0;
        }

        String getNextEntry() throws OutOfDataException {
            String string = null;
            if (this.current < this.syslogData.length()) {
                this.lineEnd = this.syslogData.indexOf("\n", this.current);
                string = this.syslogData.substring(this.current, this.lineEnd);
                this.current = this.lineEnd + 1;
            }
            if (string == null) {
                throw new OutOfDataException();
            }
            return string;
        }

        boolean lookAheadForPattern(String string) {
            int n;
            int n2;
            String string2;
            boolean bl = false;
            if (this.current < this.syslogData.length() && (string2 = this.syslogData.substring(n2 = this.current, n = this.syslogData.indexOf("\n", n2))).indexOf(string) != -1) {
                bl = true;
            }
            return bl;
        }

        boolean isNextLineAssociated(String string, Pattern pattern) {
            String string2;
            String string3;
            boolean bl = false;
            String string4 = this.previewNextEntry();
            if (string4 != null && pattern.matcher(string4).find() && (string3 = this.getIP(string)) != null && string4.indexOf(string3) != -1 && (string2 = this.getFruid(string)) != null && string4.indexOf(string2) != -1) {
                bl = true;
            }
            return bl;
        }

        boolean isNextLineFromSameT3(String string) {
            String string2;
            boolean bl = false;
            String string3 = this.previewNextEntry();
            if (string3 != null && (string2 = this.getIP(string)) != null && string3.indexOf(string2) != -1) {
                bl = true;
            }
            return bl;
        }

        boolean nextLineExists() {
            return this.current < this.syslogData.length();
        }

        String previewNextEntry() {
            String string = null;
            if (this.nextLineExists()) {
                int n = this.syslogData.indexOf("\n", this.current);
                string = this.syslogData.substring(this.current, n);
            }
            return string;
        }

        String getIP(String string) {
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 4) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            return string2;
        }

        String getFruid(String string) {
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 7) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                if (string2.indexOf(":") != -1) {
                    string2 = string2.substring(0, string2.indexOf(":"));
                }
            }
            return string2;
        }
    }

    private class PollingTask
    extends TimerTask {
        private PollingTask() {
        }

        public void run() {
            block5: {
                if (StoradeEnvironment.getState() == 2) {
                    T3SyslogParser.this.stopPolling();
                    return;
                }
                if (T3SyslogParser.this.t3List.size() == 0) break block5;
                try {
                    T3SyslogParser.this.parseLog();
                }
                catch (ParserException parserException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
            }
        }
    }
}

