/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.service;

import com.sun.jade.apps.discovery.Probe;
import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3HttpConnection;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.device.protocol.snmp.SNMP;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class T3Probe
implements Probe {
    private boolean verbose;
    private static String probeType = "t3s";
    private static String[] propertyNames = new String[]{"ip", "wwn"};
    public static final String sccs_id = "@(#)T3Probe.java\t1.8 04/02/03 SMI";

    public Iterator probe(String string) {
        Report.trace.log((Object)string);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        SNMP sNMP = new SNMP(100);
        Iterator iterator = sNMP.probe(string);
        while (iterator != null && iterator.hasNext()) {
            Object object;
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("sysDescr");
            if (string2 == null) {
                string2 = "-";
            }
            if (!string2.startsWith("SUN T3")) continue;
            Properties properties2 = new Properties();
            String string3 = properties.getProperty("ip");
            String string4 = properties.getProperty("ipno");
            if (string3 != null) {
                properties2.setProperty("ip", string3);
            }
            if (string4 != null) {
                properties2.setProperty("ipno", string4);
            } else {
                try {
                    object = InetAddress.getByName(string3);
                    properties2.setProperty("ipno", ((InetAddress)object).getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            object = new T3HttpConnection(string4 != null ? string4 : string3);
            try {
                String string5 = null;
                T3TokenList t3TokenList = ((T3HttpConnection)object).getTokenList("/elemprop.htm");
                if (t3TokenList != null) {
                    string5 = t3TokenList.getStringValue("u1p1", "portWWN");
                }
                if (string5 != null) {
                    properties2.setProperty("wwn", string5);
                    properties2.setProperty("name", string5);
                } else {
                    String string6 = null;
                    if (t3TokenList != null) {
                        string6 = t3TokenList.getStringValue("u1vol1", "volWWN");
                    }
                    if (string6 != null) {
                        string6 = "5" + string6.substring(9, 24);
                        properties2.setProperty("wwn", string6);
                        properties2.setProperty("name", string6);
                    }
                }
            }
            catch (T3Exception t3Exception) {
                // empty catch block
            }
            properties2.setProperty("logicalName", string3);
            properties2.setProperty("type", "t3");
            arrayList.add(properties2);
        }
        return arrayList.iterator();
    }

    public String getProbeType() {
        return probeType;
    }

    public String[] getProbeProperties() {
        return propertyNames;
    }

    public static void main(String[] stringArray) {
        T3Probe t3Probe = new T3Probe();
        t3Probe.verbose = true;
        Iterator iterator = t3Probe.probe(stringArray[0]);
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            properties.list(System.out);
        }
        System.exit(0);
    }
}

