/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.service;

import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.device.array.t3.diags.SMI_T3OFDGTest;
import com.sun.jade.device.array.t3.diags.SMI_T3VolumeVerifyTest;
import com.sun.jade.device.array.t3.service.ParserException;
import com.sun.jade.device.array.t3.service.T3MF;
import com.sun.jade.device.array.t3.service.T3Model;
import com.sun.jade.device.array.t3.service.T3ReportGenerator;
import com.sun.jade.device.array.t3.service.T3SyslogParser;
import com.sun.jade.device.array.t3.service.T3Views;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.view.ViewHelper;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.util.Properties;

public class T3MFImpl
extends AbstractMF
implements T3MF,
T3Model {
    private String wwn;
    private String ip;
    private String ipno;
    private InetAddress iaddr;
    private T3SyslogParser logParser;
    private String type;

    public T3MFImpl(Properties properties) {
        super(properties);
        this.type = properties.getProperty("type");
        if (!"t3".equals(this.type)) {
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
        this.ip = this.resolveIP(properties);
        this.ipno = properties.getProperty("ipno");
        this.wwn = properties.getProperty("wwn");
        if (this.wwn == null) {
            Report.debug.log((Object)("wwn not yet set for t3 ip=" + this.ip));
        }
        this.setDeviceReport(new T3ReportGenerator(properties));
        this.addDiagnosticTest((TestTemplate)new SMI_T3VolumeVerifyTest());
        this.addDiagnosticTest(new SMI_T3OFDGTest());
        this.startSyslogParsing();
    }

    public String getClassName() {
        return "StorEdgeT3_Cluster";
    }

    public String getName() {
        return this.wwn;
    }

    public String getIPAddr() {
        return this.ip;
    }

    public String getIPNum() {
        return this.ipno;
    }

    public String getType() {
        return "t3";
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString("Sun StorEdge T3");
    }

    protected ViewHelper newViewHelper() {
        return new T3Views(this);
    }

    protected void shutdown() {
        if (this.logParser != null) {
            this.logParser.removeDevice(this);
        }
    }

    public void startSyslogParsing() {
        block2: {
            if (this.logParser != null) break block2;
            try {
                this.logParser = T3SyslogParser.getParser(this);
                this.logParser.monitorDevice(this);
            }
            catch (ParserException parserException) {
                Report.error.log("SyslogError", (Object)parserException.getMessage());
            }
        }
    }
}

