/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.service;

import com.sun.jade.device.array.t3.io.T3System;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.util.log.Report;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class T3ClusterStatusCalculator {
    private static final double FULLY_AVAILABLE_WEIGHT = 0.999;
    private static final double OFFLINE_WEIGHT = 0.0;
    private static final int NUMBEROF_REQUIREDLOOPCARD = 1;
    private static final int NUMBEROF_REQUIREDPOWERUNIT = 1;
    private static final int NUMBEROF_REQUIREDDISKDRIVE = 8;
    private static final int NUMBEROF_REQUIREDMIDPLANE = 1;
    private static final int NUMBEROF_REQUIREDCONTROLLER = 1;
    private static final int NUMBEROF_REQUIREDUNITARYCOMPUTERSYSTEM = 1;
    private static final String FULLY_REDUNDANT = "2";
    private static final String LOG_TAG = "T3_Availability_Algorithm";
    public static final String sccs_id = "@(#)T3ClusterStatusCalculator.java\t1.2 10/08/02 SMI";

    public static String deriveClusterStatus(Vector vector) {
        double d = T3ClusterStatusCalculator.redundantComponentAvailability(vector, T3ClusterStatusCalculator.getNumReqComponent("unit"), vector.size());
        if (d < 0.9) {
            return "Error";
        }
        return "OK";
    }

    public static String deriveUnitStatus(T3TokenList t3TokenList, int n) {
        double d = T3ClusterStatusCalculator.calculateSystemAvailability(t3TokenList, n);
        if (d < 0.9) {
            return "Error";
        }
        return "OK";
    }

    private static double calculateSystemAvailability(T3TokenList t3TokenList, int n) {
        double d = 1.0;
        String[] stringArray = new String[]{"fruStatus", "fruState"};
        int n2 = 0;
        while (n2 < stringArray.length) {
            Iterator iterator = T3ClusterStatusCalculator.getFRUCollection(t3TokenList, stringArray[0], n).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Vector vector = (Vector)entry.getValue();
                double d2 = 0.0;
                int n3 = T3ClusterStatusCalculator.getNumReqComponent(string);
                d2 = T3ClusterStatusCalculator.redundantComponentAvailability(vector, n3, vector.size());
                d = d2 * d;
            }
            ++n2;
        }
        Report.debug.log(LOG_TAG, (Object)("Overall Unit " + n + " Status Weight " + d));
        return d;
    }

    private static int getNumReqComponent(String string) {
        if ("diskDrive".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("loopCard".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("powerUnit".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("controller".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("midplane".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("unit".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    private static Hashtable getFRUCollection(T3TokenList t3TokenList, String string, int n) {
        Hashtable<String, Collection> hashtable = new Hashtable<String, Collection>();
        Collection collection = t3TokenList.findTokensWithKey(string);
        hashtable.put("diskDrive", T3ClusterStatusCalculator.filterTokens(collection, "u" + n + "d"));
        hashtable.put("loopCard", T3ClusterStatusCalculator.filterTokens(collection, "u" + n + "l"));
        hashtable.put("midplane", T3ClusterStatusCalculator.filterTokens(collection, "u" + n + "mpn"));
        hashtable.put("controller", T3ClusterStatusCalculator.filterTokens(collection, "u" + n + "ctr"));
        hashtable.put("powerUnit", T3ClusterStatusCalculator.filterTokens(collection, "u" + n + "pcu"));
        return hashtable;
    }

    private static Collection filterTokens(Collection collection, String string) {
        Vector<T3Token> vector = new Vector<T3Token>();
        if (string == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            T3Token t3Token = (T3Token)iterator.next();
            if (!t3Token.getElementID().startsWith(string) || !(T3ClusterStatusCalculator.availabilityWeightMap(t3Token) > 0.9)) continue;
            vector.add(t3Token);
        }
        return vector;
    }

    private static double availabilityWeightMap(T3Token t3Token) {
        if ("fruStatus".equals(t3Token.getPropertyKey())) {
            if ("fault".equalsIgnoreCase(t3Token.getPropertyValue())) {
                return 0.0;
            }
            return 0.999;
        }
        if ("fruState".equals(t3Token.getPropertyKey())) {
            if ("disabled".equalsIgnoreCase(t3Token.getPropertyValue())) {
                return 0.0;
            }
            return 0.999;
        }
        if ("unitStatus".equals(t3Token.getPropertyKey())) {
            if ("OK".equalsIgnoreCase(t3Token.getPropertyValue())) {
                return 0.999;
            }
            return 0.0;
        }
        return 0.999;
    }

    private static double redundantComponentAvailability(Vector vector, int n, int n2) {
        double d = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            d += T3ClusterStatusCalculator.redundantComponentFormula(vector.elementAt(n3 - 1), n3, n2);
            ++n3;
        }
        Report.debug.log(LOG_TAG, (Object)("Redundant Component Availability(inside formula)" + d));
        return d;
    }

    private static double redundantComponentFormula(Object object, int n, int n2) {
        double d = 0.0;
        T3Token t3Token = (T3Token)object;
        try {
            int n3 = n2 - n;
            double d2 = T3ClusterStatusCalculator.calculateFactorial(n2) / (T3ClusterStatusCalculator.calculateFactorial(n) * T3ClusterStatusCalculator.calculateFactorial(n3));
            double d3 = Math.pow(T3ClusterStatusCalculator.availabilityWeightMap(t3Token), n);
            Report.debug.log(LOG_TAG, (Object)("The A Value " + d3));
            double d4 = Math.pow(1.0 - T3ClusterStatusCalculator.availabilityWeightMap(t3Token), n3);
            Report.debug.log(LOG_TAG, (Object)("The 1-A Value " + d4));
            d = d2 * d3 * d4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Report.debug.log(LOG_TAG, (Object)("Token Name " + t3Token.toString() + " Availability --> " + d));
        return d;
    }

    private static int calculateFactorial(int n) {
        int n2 = 1;
        if (n == 0) {
            return n2;
        }
        int n3 = 1;
        while (n3 <= n) {
            n2 *= n3;
            ++n3;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string;
        Object object3;
        T3TokenList[] t3TokenListArray = new T3TokenList[2];
        if (stringArray.length < 1) {
            System.out.println("Usage:java com.sun.jade.device.array.t3.service.T3ClusterStatusCalculator < SIMULATEDT3 | REALT3 >");
            System.exit(0);
        }
        if ("SIMULATEDT3".equalsIgnoreCase(stringArray[0].trim())) {
            System.out.println("Availability Fault Injection Choice");
            System.out.println("1. All FRU's Fully Available");
            System.out.println("2. One Disk Drive in Unit 1 not Fully Available");
            System.out.println("3. Two Disk Drive in Unit 1 not Fully Available");
            System.out.println("4. Two Disk Drive in Unit 1 and One Disk Drive in Unit 2 is not Fully Available");
            System.out.println("5. Two Disk Drives, in each of Unit 1 & Unit 2 is not Fully Available");
            System.out.print("Enter Choice -->(1,2,3,4,5):");
            object3 = ";u1d1,fruStatus,ready;;u1d2,fruStatus,ready;;u1d3,fruStatus,ready;;u1d4,fruStatus,ready;;u1d5,fruStatus,ready;;u1d6,fruStatus,ready;;u1d7,fruStatus,ready;;u1ctr,fruStatus,ready;;u1l1,fruStatus,ready;;u1l2,fruStatus,ready;;u1pcu1,fruStatus,ready;;u1pcu2,fruStatus,ready;;u1mpn,fruStatus,ready;;u1d1,fruState,enabled;;u1d2,fruState,enabled;;u1d3,fruState,enabled;;u1d4,fruState,enabled;;u1d5,fruState,enabled;;u1d6,fruState,enabled;;u1d7,fruState,enabled;;u1ctr,fruState,enabled;;u1l1,fruState,enabled;;u1l2,fruState,enabled;;u1pcu1,fruState,enabled;;u1pcu2,fruState,enabled;;u1mpn,fruState,enabled;";
            string = ";u2d1,fruStatus,ready;;u2d2,fruStatus,ready;;u2d3,fruStatus,ready;;u2d4,fruStatus,ready;;u2d5,fruStatus,ready;;u2d6,fruStatus,ready;;u2d7,fruStatus,ready;;u2ctr,fruStatus,ready;;u2l1,fruStatus,ready;;u2l2,fruStatus,ready;;u2pcu1,fruStatus,ready;;u2pcu2,fruStatus,ready;;u2mpn,fruStatus,ready;;u2d1,fruState,enabled;;u2d2,fruState,enabled;;u2d3,fruState,enabled;;u2d4,fruState,enabled;;u2d5,fruState,enabled;;u2d6,fruState,enabled;;u2d7,fruState,enabled;;u2ctr,fruState,enabled;;u2l1,fruState,enabled;;u2l2,fruState,enabled;;u2pcu1,fruState,enabled;;u2pcu2,fruState,enabled;;u2mpn,fruState,enabled;";
            int n = 0;
            try {
                n = System.in.read();
            }
            catch (IOException iOException) {
                System.exit(0);
            }
            switch (n) {
                case 49: {
                    object3 = (String)object3 + ";u1d8,fruStatus,ready;" + ";u1d9,fruStatus,ready;" + ";u1d8,fruState,enabled;" + ";u1d9,fruState,enabled;";
                    string = string + ";u2d8,fruStatus,ready;" + ";u2d9,fruStatus,ready;" + ";u2d8,fruState,enabled;" + ";u2d9,fruState,enabled;";
                    break;
                }
                case 50: {
                    object3 = (String)object3 + ";u1d8,fruStatus,ready;" + ";u1d9,fruStatus,fault;" + ";u1d8,fruState,enabled;" + ";u1d9,fruState,disabled;";
                    string = string + ";u2d8,fruStatus,ready;" + ";u2d9,fruStatus,ready;" + ";u2d8,fruState,enabled;" + ";u2d9,fruState,enabled;";
                    break;
                }
                case 51: {
                    object3 = (String)object3 + ";u1d8,fruStatus,fault;" + ";u1d9,fruStatus,fault;" + ";u1d8,fruState,disabled;" + ";u1d9,fruState,disabled;";
                    string = string + ";u2d8,fruStatus,ready;" + ";u2d9,fruStatus,ready;" + ";u2d8,fruState,enabled;" + ";u2d9,fruState,enabled;";
                    break;
                }
                case 52: {
                    object3 = (String)object3 + ";u1d8,fruStatus,fault;" + ";u1d9,fruStatus,fault;" + ";u1d8,fruState,disabled;" + ";u1d9,fruState,disabled;";
                    string = string + ";u2d8,fruStatus,fault;" + ";u2d9,fruStatus,ready;" + ";u2d8,fruState,disabled;" + ";u2d9,fruState,enabled;";
                    break;
                }
                case 53: {
                    object3 = (String)object3 + ";u1d8,fruStatus,fault;" + ";u1d9,fruStatus,fault;" + ";u1d8,fruState,disabled;" + ";u1d9,fruState,disabled;";
                    string = string + ";u2d8,fruStatus,fault;" + ";u2d9,fruStatus,fault;" + ";u2d8,fruState,disabled;" + ";u2d9,fruState,disabled;";
                    break;
                }
                default: {
                    System.out.println("Enter again...Invalid Entry");
                }
            }
            object2 = new T3TokenList((String)object3);
            object = new T3TokenList(string);
            t3TokenListArray[0] = object2;
            t3TokenListArray[1] = object;
        } else {
            if (stringArray.length != 2) {
                System.out.println("Usage:java com.sun.jade.device.array.t3.service.T3ClusterStatusCalculator REALT3 <ip_address>");
                System.exit(0);
            }
            try {
                object3 = new T3System(stringArray[1]);
                ((T3System)object3).updateSystem();
                t3TokenListArray = ((T3System)object3).getUnitProperties();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            object3 = new T3ClusterStatusCalculator();
            string = T3ClusterStatusCalculator.deriveUnitStatus(t3TokenListArray[0], 1);
            System.out.println("The Unit Availability for unit 1 is  " + string);
            String string2 = T3ClusterStatusCalculator.deriveUnitStatus(t3TokenListArray[1], 2);
            System.out.println("The Unit Availability for unit 2 is  " + string2);
            object2 = new T3Token("u1", "unitStatus", string);
            object = new T3Token("u2", "unitStatus", string2);
            Vector<Object> vector = new Vector<Object>();
            vector.add(object2);
            vector.add(object);
            System.out.println("The Cluster Availability is " + T3ClusterStatusCalculator.deriveClusterStatus(vector));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("Usage:java com.sun.jade.device.array.t3.service.T3ClusterStatusCalculator  <SIMULATEDT3 | REALT3> <ipAddress>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

