/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.io;

import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.util.unittest.UnitTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class T3TokenList {
    private static final String sccs_id = "@(#)T3TokenList.java\t1.8 06/17/02 SMI";
    Vector list;

    public T3TokenList(String string) {
        Vector<T3Token> vector = new Vector<T3Token>();
        int n = 0;
        int n2 = 0;
        try {
            n = string.indexOf(";");
            while (true) {
                T3Token t3Token;
                if ((t3Token = new T3Token(string.substring(n + 1, n2 = string.indexOf(";", n + 1)))).getElementID() != null) {
                    n = n2 + 1;
                    vector.add(t3Token);
                    continue;
                }
                n = n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.list = vector;
            return;
        }
    }

    public T3TokenList(Vector vector) {
        this.list = vector;
    }

    public T3Token findToken(String string) {
        if (this.list == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            T3Token t3Token = (T3Token)this.list.get(n);
            if (string.equals(t3Token.getPropertyKey())) {
                return t3Token;
            }
            ++n;
        }
        return null;
    }

    public Collection findTokensWithKey(String string) {
        ArrayList<T3Token> arrayList = new ArrayList<T3Token>();
        if (this.list == null || string == null) {
            return arrayList;
        }
        int n = 0;
        while (n < this.list.size()) {
            T3Token t3Token = (T3Token)this.list.get(n);
            if (string.equals(t3Token.getPropertyKey())) {
                arrayList.add(t3Token);
            }
            ++n;
        }
        return arrayList;
    }

    public T3Token findToken(String string, String string2) {
        if (this.list == null || string == null || string2 == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            T3Token t3Token = (T3Token)this.list.get(n);
            if (string2.equals(t3Token.getPropertyKey()) && string.equals(t3Token.getElementID())) {
                return t3Token;
            }
            ++n;
        }
        return null;
    }

    public String getStringValue(String string) {
        T3Token t3Token = this.findToken(string);
        if (t3Token == null) {
            return null;
        }
        return t3Token.getPropertyValue();
    }

    public String getStringValue(String string, String string2) {
        T3Token t3Token = this.findToken(string, string2);
        if (t3Token == null) {
            return null;
        }
        return t3Token.getPropertyValue();
    }

    public int getIntValue(String string, String string2) throws T3Exception {
        T3Token t3Token = this.findToken(string, string2);
        if (t3Token == null) {
            throw new T3Exception("t3.exception.noToken", string + "," + string2);
        }
        try {
            Integer n = new Integer(t3Token.getPropertyValue());
            return n;
        }
        catch (Exception exception) {
            throw new T3Exception(exception.getLocalizedMessage());
        }
    }

    public int getIntValue(String string) throws T3Exception {
        T3Token t3Token = this.findToken(string);
        if (t3Token == null) {
            throw new T3Exception("t3.exception.noToken", string);
        }
        try {
            Integer n = new Integer(t3Token.getPropertyValue());
            return n;
        }
        catch (Exception exception) {
            throw new T3Exception(exception.getLocalizedMessage());
        }
    }

    public float getFloatValue(String string, String string2) throws T3Exception {
        T3Token t3Token = T3Token.findToken(this.list, string, string2);
        if (t3Token == null) {
            throw new T3Exception("t3.exception.noToken", string + "," + string2);
        }
        try {
            Float f = new Float(t3Token.getPropertyValue());
            return f.floatValue();
        }
        catch (Exception exception) {
            throw new T3Exception(exception.getLocalizedMessage());
        }
    }

    public boolean assertCondition(String string, String string2, String string3) throws T3Exception {
        T3Token t3Token = T3Token.findToken(this.list, string, string2);
        if (t3Token == null) {
            throw new T3Exception("t3.exception.noToken", string + "," + string2);
        }
        return t3Token.getPropertyValue().equals(string3);
    }

    public boolean assertCondition(String string, String string2) throws T3Exception {
        T3Token t3Token = T3Token.findToken(this.list, string);
        if (t3Token == null) {
            throw new T3Exception("t3.exception.noToken", string);
        }
        return t3Token.getPropertyValue().equals(string2);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public static class Test
    extends UnitTest {
        public void test() throws T3Exception {
            String string = "...;a,b,5;;d,e,2.2;...";
            T3TokenList t3TokenList = new T3TokenList(string);
            this.assertCondition(t3TokenList.assertCondition("b", "5"));
            this.assertCondition(t3TokenList.assertCondition("d", "e", "2.2"));
            this.assertCondition(t3TokenList.getIntValue("b") == 5);
            this.assertEquals(t3TokenList.findToken("none"), null);
        }
    }
}

