/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.io;

import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.device.protocol.http.HttpReply;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import sun.misc.BASE64Encoder;

public class T3HttpConnection {
    private String encoding;
    private String host;
    private String path;
    private int port;
    private boolean abortUpdate;
    private int responseCode;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int TIMEOUT = 60;
    private static final int PORT = 80;
    private static final int HTTP_OK = 200;
    private static final int HTTP_UNAUTHORIZED = 401;
    public static final int INVALID_RESPONSE = -1;
    public static final String sccs_id = "@(#)T3HttpConnection.java\t1.6 01/29/03 SMI";

    public T3HttpConnection(String string) {
        this.setHost(string);
        this.setAuthentication("guest", "");
    }

    public T3HttpConnection(String string, String string2) {
        this.setHost(string);
        this.path = string2;
        this.setAuthentication("guest", "");
    }

    public T3HttpConnection(String string, String string2, String string3, String string4) {
        this.setHost(string);
        this.path = string2;
        this.setAuthentication(string3, string4);
    }

    public void setAuthentication(String string, String string2) {
        String string3 = string + ":" + string2;
        this.encoding = new BASE64Encoder().encode(string3.getBytes());
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setHost(String string) {
        this.port = 80;
        if (string == null) {
            string = "localhost";
        } else if (string.indexOf(58) == -1) {
            this.host = string;
        } else {
            this.host = string.substring(0, string.indexOf(58));
            try {
                this.port = Integer.parseInt(string.substring(string.indexOf(58) + 1));
            }
            catch (Exception exception) {}
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public T3TokenList getTokenList(String string) throws T3Exception {
        this.setPath(string);
        String string2 = this.get();
        if (string2.equals("")) {
            throw new T3Exception("No tokens");
        }
        return new T3TokenList(string2);
    }

    public String get() throws T3Exception {
        return this.get(60);
    }

    public String post(String string) throws T3Exception {
        return this.post(60, string);
    }

    public String post(String string, String string2) throws T3Exception {
        this.setPath(string);
        return this.post(60, string2);
    }

    public String get(int n) throws T3Exception {
        Socket socket;
        block12: {
            String string;
            block13: {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("GET ");
                stringBuffer.append(this.path);
                stringBuffer.append("  HTTP/1.0\r\n");
                if (this.encoding != null) {
                    stringBuffer.append("Authorization: Basic ");
                    stringBuffer.append(this.encoding);
                    stringBuffer.append("\r\n");
                }
                stringBuffer.append("Accept: text/html\r\n");
                stringBuffer.append("\r\n");
                socket = null;
                socket = new Socket(this.host, this.port);
                socket.setSoTimeout(1000 * n);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.flush();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                HttpReply httpReply = new HttpReply((Reader)bufferedReader);
                Properties properties = httpReply.readHeader();
                this.responseCode = httpReply.getResponseCode();
                if (this.responseCode != 200) break block12;
                StringBuffer stringBuffer2 = new StringBuffer();
                while (-1 != (n2 = bufferedReader.read())) {
                    stringBuffer2.append((char)n2);
                }
                string = stringBuffer2.toString();
                Object var12_13 = null;
                if (socket == null) break block13;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
        }
        try {
            try {
                if (this.responseCode == 401) {
                    throw new T3Exception("t3.exception.notAllowed");
                }
                throw new T3Exception("t3.exception.communicationError");
            }
            catch (UnknownHostException unknownHostException) {
                throw new T3Exception("t3.exception.unknownHost", this.host);
            }
            catch (IOException iOException) {
                throw new T3Exception("t3.exception.communicationError");
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var12_14 = null;
                if (socket == null) break block14;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }

    public String post(int n, String string) throws T3Exception {
        Socket socket;
        block12: {
            String string2;
            block13: {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("POST ");
                stringBuffer.append(this.path);
                stringBuffer.append("  HTTP/1.0\r\n");
                if (this.encoding != null) {
                    stringBuffer.append("Authorization: Basic ");
                    stringBuffer.append(this.encoding);
                    stringBuffer.append("\r\n");
                }
                stringBuffer.append("Accept: text/html\r\n");
                stringBuffer.append("Content-Type: application/x-www-form-urlencoded\r\n");
                stringBuffer.append("Content-length:");
                stringBuffer.append(" " + string.length());
                stringBuffer.append("\r\n\r\n");
                stringBuffer.append(string);
                socket = null;
                socket = new Socket(this.host, this.port);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.flush();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                HttpReply httpReply = new HttpReply((Reader)bufferedReader);
                Properties properties = httpReply.readHeader();
                this.responseCode = httpReply.getResponseCode();
                if (this.responseCode != 200) break block12;
                StringBuffer stringBuffer2 = new StringBuffer();
                while (-1 != (n2 = bufferedReader.read())) {
                    stringBuffer2.append((char)n2);
                }
                string2 = stringBuffer2.toString();
                Object var13_14 = null;
                if (socket == null) break block13;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string2;
        }
        try {
            try {
                if (this.responseCode == 401) {
                    throw new T3Exception("t3.exception.notAllowed");
                }
                throw new T3Exception("t3.exception.communicationError");
            }
            catch (UnknownHostException unknownHostException) {
                Report.warning.log((Throwable)unknownHostException, (Object)"Unknown host");
                throw new T3Exception("t3.exception.unknownHost", this.host);
            }
            catch (IOException iOException) {
                Report.warning.log((Throwable)iOException, (Object)"T3 IO Error");
                throw new T3Exception("t3.exception.communicationError");
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var13_15 = null;
                if (socket == null) break block14;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }

    public synchronized void abort() {
        this.abortUpdate = true;
    }

    public static class Test
    extends UnitTest {
        private static void usage() {
            System.out.println("usage <host> <path>");
            System.out.println("usage <host> <path> <post>");
            System.out.println("usage <host> <path> <post> <user> <passwd>\n");
            System.out.println("Host is the IP address of the T3.");
            System.out.println("Path is a T3 HTML file or /update?setting=value string. ie:\n\t( /elemprop.htm /enclmap.htm /sysprop.htm /voloper.htm\n\t  /loopinf.htm /ofdgoper.htm /logprop.htm )");
            System.out.println("\t/update?unitIndex=0&volIndex=0&volVerifyRate=0&volSaftey=0");
            System.out.println("\t/update?unitIndex=0&loopIndex=0");
            System.out.println("Post commands for /update?:");
            System.out.println("\tvolVerify=Verify, volAbort=Abort");
            System.out.println("\tondgTest=Test, ondgFastFind=FastFind, ondgFastTest=FastTest, ondgHealthCheck=HealthCheck");
            System.out.println("\tondgFind=Find, loopAbort=Abort");
            System.out.println("\tsysApplySettings=Apply");
        }

        public static void main(String[] stringArray) {
            T3HttpConnection t3HttpConnection = null;
            String string = null;
            if (stringArray.length == 2) {
                t3HttpConnection = new T3HttpConnection(stringArray[0], stringArray[1]);
            } else if (stringArray.length == 3) {
                t3HttpConnection = new T3HttpConnection(stringArray[0], stringArray[1]);
                string = stringArray[2];
            } else if (stringArray.length == 5) {
                t3HttpConnection = new T3HttpConnection(stringArray[0], stringArray[1], stringArray[3], stringArray[4]);
                string = stringArray[2];
            } else {
                Test.usage();
                System.exit(-1);
            }
            try {
                if (string == null) {
                    String string2 = t3HttpConnection.get(30);
                    Vector vector = T3Token.createTokens(string2);
                    int n = 0;
                    while (n < vector.size()) {
                        T3Token t3Token = (T3Token)vector.get(n);
                        System.out.println(t3Token.toString());
                        ++n;
                    }
                } else {
                    System.out.println(t3HttpConnection.post(30, string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                exception.toString();
            }
            System.exit(0);
        }

        public void test() throws Exception {
            T3HttpConnection t3HttpConnection = new T3HttpConnection("localhost:0", "/index.html");
            this.assertNotNull(t3HttpConnection.host);
            this.assertNotNull(t3HttpConnection.path);
            this.assertCondition(0 == t3HttpConnection.port);
        }
    }
}

