/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.io;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;
import sun.misc.BASE64Encoder;

public class T3Connection {
    private String host;
    private int port;
    private String path;
    private String user;
    private String password;
    private static final int TIMEOUT = 120;
    public static final int INVALID_RESPONSE = -1;
    private int responseCode = -1;
    private HttpURLConnection connection;
    private boolean abortConnection;
    AbortTimer abortTimer;
    private InputStream inputStream;
    private IOException inputError;
    private static final String sccs_id = "@(#)T3Connection.java\t1.13 11/05/02 SMI";

    public T3Connection(String string) {
        this.setHost(string);
        this.path = "/sysprop.htm";
        this.user = "guest";
        this.password = "";
    }

    public T3Connection(String string, String string2) {
        this.setHost(string);
        this.path = string2;
        this.user = "guest";
        this.password = "";
    }

    public T3Connection(String string, String string2, String string3, String string4) {
        this.setHost(string);
        this.path = string2;
        this.user = string3;
        this.password = string4;
    }

    public void setHost(String string) {
        if (string == null) {
            string = null;
            this.port = -1;
        } else if (string.indexOf(58) == -1) {
            this.host = string;
            this.port = -1;
        } else {
            this.host = string.substring(0, string.indexOf(58));
            this.port = new Integer(string.substring(string.indexOf(58) + 1));
        }
    }

    public void setAuthentication(String string, String string2) {
        this.user = string;
        this.password = string2;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public synchronized void open() throws T3Exception {
    }

    private synchronized void closeConnection() {
        if (this.connection == null) {
            return;
        }
        this.connection.disconnect();
        this.connection = null;
        this.endAbortTimer();
        this.notifyAll();
    }

    private synchronized HttpURLConnection getConnection() throws T3Exception {
        HttpURLConnection httpURLConnection;
        URL uRL;
        while (this.connection != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.inputStream = null;
        this.inputError = null;
        try {
            uRL = new URL("http", this.host, this.port, this.path);
        }
        catch (MalformedURLException malformedURLException) {
            throw new T3Exception(malformedURLException.getLocalizedMessage());
        }
        String string = this.user + ":" + this.password;
        String string2 = new BASE64Encoder().encode(string.getBytes());
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setUseCaches(false);
        }
        catch (Exception exception) {
            this.connection = null;
            throw new T3Exception(exception.getLocalizedMessage());
        }
        this.connection = httpURLConnection;
        return httpURLConnection;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String get() throws T3Exception {
        return this.get(120);
    }

    public String post(String string) throws T3Exception {
        return this.post(120, string);
    }

    public String get(int n) throws T3Exception {
        block13: {
            int n2;
            this.startAbortTimer(n);
            this.getConnection();
            this.responseCode = -1;
            try {
                this.connection.setRequestMethod("GET");
            }
            catch (ProtocolException protocolException) {
                throw new T3Exception("t3.exception.protocol");
            }
            this.connection.setDoOutput(false);
            this.connection.setDoInput(true);
            InputStream inputStream = this.getInput();
            if (inputStream == null) {
                throw new T3Exception("t3.exception.communicationError");
            }
            if (this.abortConnection) {
                throw new T3Exception("t3.exception.communicationError");
            }
            this.responseCode = this.connection.getResponseCode();
            if (this.responseCode != 200) break block13;
            if (this.abortConnection) {
                throw new T3Exception("t3.exception.communicationError");
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (-1 != (n2 = inputStream.read())) {
                stringBuffer.append((char)n2);
            }
            String string = stringBuffer.toString();
            Object var11_10 = null;
            this.closeConnection();
            return string;
        }
        try {
            try {
                throw new T3Exception("t3.exception.communicationError");
            }
            catch (UnknownHostException unknownHostException) {
                throw new T3Exception("t3.exception.unknownHost", this.host);
            }
            catch (ConnectException connectException) {
                throw new T3Exception("t3.exception.connect");
            }
            catch (Exception exception) {
                throw new T3Exception(exception.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.closeConnection();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String post(int n, String string) throws T3Exception {
        String string2;
        this.startAbortTimer(n);
        this.connection = this.getConnection();
        this.responseCode = -1;
        try {
            this.connection.setRequestMethod("POST");
        }
        catch (ProtocolException protocolException) {
            throw new T3Exception("t3.exception.protocol");
        }
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        try {
            try {
                this.connection.connect();
                DataOutputStream dataOutputStream = new DataOutputStream(this.connection.getOutputStream());
                dataOutputStream.writeBytes(string);
                dataOutputStream.flush();
                dataOutputStream.close();
                InputStream inputStream = this.getInput();
                if (inputStream == null) {
                    String string3 = null;
                    Object var15_10 = null;
                    this.closeConnection();
                    return string3;
                }
                if (this.abortConnection) {
                    throw new T3Exception("t3.exception.communicationError");
                }
                this.responseCode = this.connection.getResponseCode();
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    int n2;
                    if (-1 == (n2 = inputStream.read())) {
                        string2 = stringBuffer.toString();
                        break;
                    }
                    stringBuffer.append((char)n2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.connection.disconnect();
                throw new T3Exception("t3.exception.notAllowed");
            }
            catch (UnknownHostException unknownHostException) {
                throw new T3Exception("t3.exception.unknownHost", this.host);
            }
            catch (ConnectException connectException) {
                throw new T3Exception("t3.exception.connect");
            }
            catch (Exception exception) {
                this.connection.disconnect();
                throw new T3Exception("t3.exception.notAllowedOrError");
            }
        }
        catch (Throwable throwable) {
            Object var15_12 = null;
            this.closeConnection();
            throw throwable;
        }
        Object var15_11 = null;
        this.closeConnection();
        return string2;
    }

    private void startAbortTimer(int n) {
        this.abortTimer = new AbortTimer(n);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)this.abortTimer);
    }

    private void endAbortTimer() {
        if (this.abortTimer != null) {
            this.abortTimer.neverMind();
            this.abortTimer = null;
        }
    }

    private synchronized void setInput(InputStream inputStream) {
        this.inputStream = inputStream;
        this.notifyAll();
    }

    private synchronized void setInputError(IOException iOException) {
        this.inputError = iOException;
        this.notifyAll();
    }

    private synchronized InputStream getInput() throws IOException {
        if (this.connection == null) {
            return null;
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.inputError != null) {
            throw this.inputError;
        }
        ConnectionGetter connectionGetter = new ConnectionGetter();
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)connectionGetter);
        while (this.inputStream == null && this.inputError == null) {
            if (this.abortConnection) {
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.inputError != null) {
            throw this.inputError;
        }
        return this.inputStream;
    }

    public synchronized void abort() {
        if (this.connection != null) {
            Report.trace.log((Object)"T3Connection timout. close connection");
        }
        this.closeConnection();
        this.abortConnection = true;
        this.notifyAll();
    }

    public static void usage() {
        System.out.println("usage <host> <path>");
        System.out.println("usage <host> <path> <post>");
        System.out.println("usage <host> <path> <post> <user> <passwd>\n");
        System.out.println("Host is the IP address of the T3.");
        System.out.println("Path is a T3 HTML file or /update?setting=value string. ie:\n\t( /elemprop.htm /enclmap.htm /sysprop.htm /voloper.htm\n\t  /loopinf.htm /ofdgoper.htm /logprop.htm )");
        System.out.println("\t/update?unitIndex=0&volIndex=0&volVerifyRate=0&volSaftey=0");
        System.out.println("\t/update?unitIndex=0&loopIndex=0");
        System.out.println("Post commands for /update?:");
        System.out.println("\tvolVerify=Verify, volAbort=Abort");
        System.out.println("\tondgTest=Test, ondgFastFind=FastFind, ondgFastTest=FastTest, ondgHealthCheck=HealthCheck");
        System.out.println("\tondgFind=Find, loopAbort=Abort");
        System.out.println("\tsysApplySettings=Apply");
    }

    public static void main(String[] stringArray) {
        T3Connection t3Connection = null;
        String string = null;
        if (stringArray.length == 2) {
            t3Connection = new T3Connection(stringArray[0], stringArray[1]);
        } else if (stringArray.length == 3) {
            t3Connection = new T3Connection(stringArray[0], stringArray[1]);
            string = stringArray[2];
        } else if (stringArray.length == 5) {
            t3Connection = new T3Connection(stringArray[0], stringArray[1], stringArray[3], stringArray[4]);
            string = stringArray[2];
        } else {
            T3Connection.usage();
            System.exit(-1);
        }
        try {
            t3Connection.open();
            if (string == null) {
                String string2 = t3Connection.get(30);
                Vector vector = T3Token.createTokens(string2);
                int n = 0;
                while (n < vector.size()) {
                    T3Token t3Token = (T3Token)vector.get(n);
                    System.out.println(t3Token.toString());
                    ++n;
                }
            } else {
                System.out.println(t3Connection.post(30, string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.toString();
        }
        System.exit(0);
    }

    public static class Test
    extends UnitTest {
        public void testConnection() throws T3Exception {
            T3Connection t3Connection = new T3Connection("TestHost", "c1t0d0s0");
            this.assertNotNull(t3Connection.host);
            this.assertNotNull(t3Connection.path);
            T3Connection t3Connection2 = new T3Connection("TestHost", "c1t0d0s0", "Some User", "User Password");
            this.assertNotNull(t3Connection2.host);
            this.assertNotNull(t3Connection2.path);
            this.assertNotNull(t3Connection2.user);
            this.assertNotNull(t3Connection2.password);
            t3Connection = new T3Connection("abcd:1234");
        }
    }

    private class ConnectionGetter
    implements Runnable {
        ConnectionGetter() {
            T3Connection.this.inputStream = null;
        }

        public void run() {
            try {
                T3Connection.this.connection.connect();
                InputStream inputStream = T3Connection.this.connection.getInputStream();
                T3Connection.this.setInput(inputStream);
            }
            catch (IOException iOException) {
                T3Connection.this.setInputError(iOException);
            }
        }
    }

    private class AbortTimer
    implements Runnable {
        int seconds;
        boolean neverMind;

        AbortTimer(int n) {
            T3Connection.this.abortConnection = false;
            this.seconds = n;
        }

        public synchronized void neverMind() {
            this.neverMind = true;
            this.notify();
        }

        public synchronized void run() {
            try {
                this.wait(this.seconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.neverMind) {
                T3Connection.this.abort();
            }
        }
    }
}

