/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.diags;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.array.t3.diags.Messages;
import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3HttpConnection;
import com.sun.jade.device.array.t3.io.T3System;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.PrintWriter;
import java.io.StringWriter;

public class SMI_T3OFDGTestExecutable
extends TestExecutableImpl {
    public static final int HEALTH_CHECK = 0;
    public static final int FAST_TEST = 1;
    public static final int FAST_FIND = 2;
    public static final int LOOP_TEST = 3;
    public static final int LOOP_FIND = 4;
    public static final int ALL_TEST = 5;
    private static final Localizer msgs = Messages.getLocalizer();
    private static final long TIMEOUT = 300000L;
    private static final int POLL_INTERVAL = 10000;
    private static final String LOG_TAG = "T3";
    private T3HttpConnection t3 = null;
    private T3System t3Sys;
    private DiagnosticResult result;
    private boolean abort = false;
    private boolean isRunning = false;
    private boolean testing = false;
    private boolean debug = false;
    private String userName = "root";
    private String password = "";
    private String ip;
    private String wwn;
    private int unit = 0;
    private int loop = 0;
    private int testType = 0;
    private int numTests;
    private int testsComplete;
    private int testPercent;
    private static final String sccs_id = "@(#)SMI_T3OFDGTestExecutable.java\t1.28 11/14/02 SMI";

    SMI_T3OFDGTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        this.result = diagnosticResult;
        this.parseSettings();
        Report.debug.log((Object)("OFDG runTest: mse = " + this.mse));
        Report.debug.log((Object)("OFDG runTest: setting = " + this.setting));
        if (null == this.ip || "".equals(this.ip)) {
            diagnosticResult.setFinalResults(TestState.FAILED, msgs.getString("oob.noipaddr"));
            return;
        }
        this.isRunning = true;
        try {
            try {
                if (this.reportStatus) {
                    diagnosticResult.addTestResults(msgs.getString("ofdg.msg.starting"));
                    diagnosticResult.update();
                }
                this.t3 = new T3HttpConnection(this.ip);
                this.t3.setAuthentication(this.userName, this.password);
                this.t3.getTokenList("/voloper.htm");
                this.t3Sys = new T3System(this.ip);
                String string = this.checkForOFDGOperation();
                if (string != null) {
                    if (this.reportErrors) {
                        diagnosticResult.addTestResults(string);
                        diagnosticResult.update();
                    }
                    this.waitForResult();
                    this.setTestPassResult("ofdg.passed");
                } else {
                    if (this.reportStatus) {
                        diagnosticResult.addTestResults(msgs.getString("ofdg.msg.noConflictOp"));
                        diagnosticResult.update();
                    }
                    this.numTests = 1;
                    this.testsComplete = 0;
                    switch (this.testType) {
                        case 5: {
                            this.numTests = 3;
                            this.runTest(5, "ofdg.healthCheck");
                            ++this.testsComplete;
                            this.runTest(1, "ofdg.loopTest");
                            ++this.testsComplete;
                            this.runTest(2, "ofdg.loopFind");
                            break;
                        }
                        case 1: {
                            this.runTest(3, "ofdg.fastTest");
                            break;
                        }
                        case 2: {
                            this.runTest(4, "ofdg.fastFind");
                            break;
                        }
                        case 3: {
                            this.runTest(1, "ofdg.loopTest");
                            break;
                        }
                        case 4: {
                            this.runTest(2, "ofdg.loopFind");
                            break;
                        }
                        case 0: {
                            this.runTest(5, "ofdg.healthCheck");
                            break;
                        }
                        default: {
                            throw new DiagnosticException("DIAG_ERR_FAILED");
                        }
                    }
                }
                if (this.abort && !diagnosticResult.isTestCompleted()) {
                    if (this.reportStatus) {
                        diagnosticResult.addTestResults(msgs.getString("ofdg.aborted"));
                    }
                    diagnosticResult.setFinalResults(TestState.STOPPED);
                }
            }
            catch (T3Exception t3Exception) {
                String string = t3Exception.getError();
                if (!"t3.exception.aborted".equals(string)) {
                    LocalizedString localizedString = new LocalizedString((Exception)t3Exception);
                    diagnosticResult.addTestResults(localizedString.toString());
                    diagnosticResult.setFinalResults(TestState.FAILED);
                    Object var8_6 = null;
                    this.isRunning = false;
                    this.abort = false;
                    this.cleanUp();
                    return;
                }
                if (!diagnosticResult.isTestCompleted()) {
                    if (this.reportStatus) {
                        diagnosticResult.addTestResults(msgs.getString("ofdg.aborted"));
                    }
                    diagnosticResult.setFinalResults(TestState.STOPPED);
                }
                Object var8_5 = null;
                this.isRunning = false;
                this.abort = false;
                this.cleanUp();
                return;
            }
            catch (DiagnosticException diagnosticException) {
                LocalizedString localizedString = new LocalizedString((Exception)((Object)diagnosticException));
                diagnosticResult.addTestResults(localizedString.toString());
                diagnosticResult.setFinalResults(TestState.FAILED);
                Object var8_7 = null;
                this.isRunning = false;
                this.abort = false;
                this.cleanUp();
                return;
            }
            catch (Exception exception) {
                StringWriter stringWriter;
                if (this.debug) {
                    stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    diagnosticResult.addTestResults(stringWriter.toString());
                }
                stringWriter = new LocalizedString(exception);
                diagnosticResult.addTestResults(stringWriter.toString());
                stringWriter = new DiagnosticException().getLocalizedString();
                diagnosticResult.addTestResults(stringWriter.toString());
                diagnosticResult.setFinalResults(TestState.FAILED);
                Object var8_8 = null;
                this.isRunning = false;
                this.abort = false;
                this.cleanUp();
                return;
            }
            Object var8_4 = null;
            this.isRunning = false;
            this.abort = false;
            this.cleanUp();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.isRunning = false;
            this.abort = false;
            this.cleanUp();
            throw throwable;
        }
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        if (this.debug) {
            this.result.addTestResults("abortTest called");
        }
        if (!this.isRunning || this.abort) {
            return false;
        }
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString("ofdg.msg.aborting"));
            this.result.update();
        }
        this.abort = true;
        this.t3.abort();
        ((Object)((Object)this)).notify();
        return true;
    }

    private short calculatePercentComplete(int n) {
        if (this.numTests < 2) {
            return (short)n;
        }
        return (short)((this.testsComplete * 100 + n) / this.numTests);
    }

    private void setTestPassResult(String string) {
        if (this.abort) {
            this.result.setFinalResults(TestState.STOPPED, msgs.getString("ofdg.aborted"));
        } else if (this.numTests < 2 || this.testsComplete == this.numTests - 1) {
            this.result.setFinalResults(TestState.PASSED, msgs.getString(string));
        } else if (this.reportStatus) {
            this.result.addTestResults(msgs.getString(string));
        }
    }

    private void runTest(int n, String string) throws T3Exception, DiagnosticException {
        if (this.abort) {
            return;
        }
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString(string + ".start"));
        }
        switch (n) {
            case 2: {
                this.t3Sys.loopFind(this.unit, this.loop, this.userName, this.password);
                break;
            }
            case 1: {
                this.t3Sys.loopTest(this.unit, this.loop, this.userName, this.password);
                break;
            }
            case 4: {
                this.t3Sys.loopFastFind(this.unit, this.loop, this.userName, this.password);
                break;
            }
            case 3: {
                this.t3Sys.loopFastTest(this.unit, this.loop, this.userName, this.password);
                break;
            }
            case 5: {
                this.t3Sys.healthCheck(this.unit, this.loop, this.userName, this.password);
                break;
            }
            default: {
                throw new DiagnosticException("DIAG_ERR_FAILED");
            }
        }
        this.testing = true;
        this.checkOFDGStarted(n);
        this.waitForResult();
        this.setTestPassResult(string + ".passed");
    }

    private String checkForOFDGOperation() throws DiagnosticException, T3Exception {
        this.t3Sys.updateLoopOperation();
        if (this.t3Sys.getLoopOperationPending()) {
            int n = this.t3Sys.getLoopOperation();
            switch (n) {
                case 2: {
                    return msgs.getString("ofdg.find.conflict");
                }
                case 1: {
                    return msgs.getString("ofdg.test.conflict");
                }
                case 4: {
                    return msgs.getString("ofdg.fastfind.conflict");
                }
                case 3: {
                    return msgs.getString("ofdg.fasttest.conflict");
                }
                case 5: {
                    return msgs.getString("ofdg.health.conflict");
                }
            }
            return msgs.getString("ofdg.op.conflict");
        }
        return null;
    }

    private synchronized void checkOFDGStarted(int n) throws T3Exception, DiagnosticException {
        Report.trace.log((Object)"checkOFDGStarted");
        if (this.abort) {
            return;
        }
        this.t3Sys.updateLoopOperation();
        if (!this.t3Sys.getLoopOperationPending()) {
            throw new DiagnosticException(msgs.getString("ofdg.msg.notStarted"));
        }
        if (this.t3Sys.getLoopOperation() != n) {
            throw new DiagnosticException(msgs.getString("ofdg.msg.notStarted"));
        }
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString("ofdg.msg.runConfirm"));
        }
    }

    private synchronized boolean waitForResult() throws DiagnosticException {
        int n;
        int n2 = 0;
        Report.trace.log((Object)"waitForResult");
        do {
            block8: {
                if (this.abort) {
                    return false;
                }
                try {
                    this.t3Sys.updateLoopOperation();
                    n2 = 0;
                }
                catch (T3Exception t3Exception) {
                    Report.debug.log((Throwable)t3Exception, (Object)"Update error");
                    if (++n2 <= 5) break block8;
                    throw new DiagnosticException(msgs.getString("ofdg.msg.oob.lost"));
                }
            }
            if (n2 == 0) {
                int n3 = this.t3Sys.getLoopOperationProgress();
                n = this.calculatePercentComplete(n3);
                this.result.setPercentComplete((short)n);
            }
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.t3Sys.getLoopOperationPending());
        String string = this.t3Sys.getLoopError();
        if (string != null && (n = string.indexOf("fail")) > 0) {
            throw new DiagnosticException(msgs.getFormattedString("ofdg.msg.failure", (Object)string));
        }
        return true;
    }

    private String parseError(String string) {
        int n = string.indexOf("fail");
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n);
        int n2 = string2.indexOf("u", n);
        int n3 = string2.indexOf("l", n);
        return msgs.getFormattedString("ofdg.msg.failure", (Object)string2.substring(n2 + 1, n3), (Object)string2.substring(n3 + 1));
    }

    private boolean cleanUp() {
        Report.trace.log((Object)"cleanUp");
        if (!this.testing) {
            Report.trace.log((Object)"Not testing. All cleaned up.");
            return true;
        }
        this.testing = false;
        Report.trace.log((Object)"cleanUp finished");
        return true;
    }

    protected void parseSettings() {
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("user");
        if (testParameter != null) {
            this.userName = (String)testParameter.getCurrentValue();
        }
        if ((testParameter = this.setting.getTestParameter("password")) != null) {
            this.password = (String)testParameter.getCurrentValue();
        }
        if ((testParameter = this.setting.getTestParameter("loop")) != null) {
            this.loop = testParameter.choiceValue(this.loop);
        }
        if ((testParameter = this.setting.getTestParameter("test")) != null) {
            this.testType = testParameter.choiceValue(this.testType);
        }
        if ((testParameter = this.setting.getTestParameter("ip")) != null) {
            this.ip = (String)testParameter.getCurrentValue();
            Report.debug.log(LOG_TAG, (Object)("ip=" + this.ip));
            this.wwn = this.mse.getKeyValue();
        }
        if ((testParameter = this.setting.getTestParameter("unit")) != null) {
            this.unit = ((Number)testParameter.getCurrentValue()).intValue();
        }
        if (this.ip == null || "".equals(this.ip)) {
            this.ip = DiagUtil.getIP((ReferenceForMSE)this.mse);
        }
    }

    public static class Test
    extends UnitTest {
        public void testParse() {
            SMI_T3OFDGTestExecutable sMI_T3OFDGTestExecutable = new SMI_T3OFDGTestExecutable(null, null);
        }
    }
}

