/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.util.unittest.UnitTest;

public class RHBAConverter {
    public static final String UNKNOWN = "Unknown";
    public static final String OTHER = "Other";
    public static final String MISSING = "Not Present";
    public static final String N_PORT = "N_Port";
    public static final String NL_PORT = "NL_Port";
    public static final String FL_PORT = "FL_Port";
    public static final String F_PORT = "F_Port";
    public static final String L_PORT = "L_Port";
    public static final String POINT_TO_POINT = "Point to Point";
    public static final int GIGABIT = 0x40000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String derivePortType(String string) {
        int n = 0;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        finally {
            switch (n2) {
                case 5: {
                    n = 1;
                    break;
                }
                case 6: {
                    n = 3;
                    break;
                }
                case 7: {
                    n = 6;
                    break;
                }
                case 8: {
                    n = 5;
                    break;
                }
                case 20: {
                    n = 2;
                    break;
                }
                case 21: {
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return "" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String derivePortSpeed(String string) {
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            switch (n) {
                case 1: {
                    n2 = 0x40000000;
                    break;
                }
                case 2: {
                    n2 = Integer.MIN_VALUE;
                    break;
                }
                case 4: {
                    n2 = Integer.MIN_VALUE;
                    break;
                }
                case 8: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 0;
                    break;
                }
            }
            catch (Throwable throwable) {
                switch (n) {
                    case 1: {
                        n2 = 0x40000000;
                        break;
                    }
                    case 2: {
                        n2 = Integer.MIN_VALUE;
                        break;
                    }
                    case 4: {
                        n2 = Integer.MIN_VALUE;
                        break;
                    }
                    case 8: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                throw throwable;
            }
        }
        switch (n) {
            case 1: {
                n2 = 0x40000000;
                break;
            }
            case 2: {
                n2 = Integer.MIN_VALUE;
                break;
            }
            case 4: {
                n2 = Integer.MIN_VALUE;
                break;
            }
            case 8: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
                break;
            }
        }
        return "" + n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String derivePortStatus(String string) {
        String string2 = UNKNOWN;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            switch (n) {
                case 2: {
                    string2 = "OK";
                    break;
                }
                case 3: {
                    string2 = "Stopped";
                    break;
                }
                case 4: {
                    string2 = "Lost Comm";
                    break;
                }
                case 5: {
                    string2 = "Service";
                    break;
                }
                case 6: {
                    string2 = "Error";
                    break;
                }
                case 7: {
                    string2 = "Error";
                    break;
                }
                case 8: {
                    string2 = "Service";
                    break;
                }
                default: {
                    string2 = UNKNOWN;
                    break;
                }
            }
            catch (Throwable throwable) {
                switch (n) {
                    case 2: {
                        string2 = "OK";
                        break;
                    }
                    case 3: {
                        string2 = "Stopped";
                        break;
                    }
                    case 4: {
                        string2 = "Lost Comm";
                        break;
                    }
                    case 5: {
                        string2 = "Service";
                        break;
                    }
                    case 6: {
                        string2 = "Error";
                        break;
                    }
                    case 7: {
                        string2 = "Error";
                        break;
                    }
                    case 8: {
                        string2 = "Service";
                        break;
                    }
                    default: {
                        string2 = UNKNOWN;
                    }
                }
                throw throwable;
            }
        }
        switch (n) {
            case 2: {
                string2 = "OK";
                break;
            }
            case 3: {
                string2 = "Stopped";
                break;
            }
            case 4: {
                string2 = "Lost Comm";
                break;
            }
            case 5: {
                string2 = "Service";
                break;
            }
            case 6: {
                string2 = "Error";
                break;
            }
            case 7: {
                string2 = "Error";
                break;
            }
            case 8: {
                string2 = "Service";
                break;
            }
            default: {
                string2 = UNKNOWN;
                break;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String derivePortAvailability(String string) {
        int n = 2;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            switch (n2) {
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: {
                    n = 9;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 7: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 5;
                    break;
                }
                default: {
                    n = 2;
                    break;
                }
            }
            catch (Throwable throwable) {
                switch (n2) {
                    case 2: {
                        n = 3;
                        break;
                    }
                    case 3: {
                        n = 8;
                        break;
                    }
                    case 4: {
                        n = 9;
                        break;
                    }
                    case 5: {
                        n = 5;
                        break;
                    }
                    case 6: {
                        n = 4;
                        break;
                    }
                    case 7: {
                        n = 4;
                        break;
                    }
                    case 8: {
                        n = 5;
                        break;
                    }
                    default: {
                        n = 2;
                    }
                }
                throw throwable;
            }
        }
        switch (n2) {
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            case 4: {
                n = 9;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 5;
                break;
            }
            default: {
                n = 2;
                break;
            }
        }
        return "" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String derivePortState(String string) {
        String string2 = UNKNOWN;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            switch (n) {
                case 2: {
                    string2 = "Online";
                    break;
                }
                case 3: {
                    string2 = "Offline";
                    break;
                }
                case 4: {
                    string2 = "Bypassed";
                    break;
                }
                case 5: {
                    string2 = "Diagnostic";
                    break;
                }
                case 6: {
                    string2 = "Link Down";
                    break;
                }
                case 7: {
                    string2 = "Error";
                    break;
                }
                case 8: {
                    string2 = "LoopBack";
                }
            }
        }
        return string2;
    }

    public static class Test
    extends UnitTest {
        public void test() {
            this.assertEquals("0", RHBAConverter.derivePortType(""));
            this.assertEquals("0", RHBAConverter.derivePortType("1"));
            this.assertEquals("0", RHBAConverter.derivePortType("Type"));
            this.assertEquals("1", RHBAConverter.derivePortType("5"));
            this.assertEquals("3", RHBAConverter.derivePortType("6"));
            this.assertEquals("6", RHBAConverter.derivePortType("7"));
            this.assertEquals("5", RHBAConverter.derivePortType("8"));
            this.assertEquals("2", RHBAConverter.derivePortType("20"));
            this.assertEquals("0", RHBAConverter.derivePortType("21"));
            this.assertEquals("0", RHBAConverter.derivePortType(null));
            this.assertEquals("1073741824", RHBAConverter.derivePortSpeed("1"));
            this.assertEquals("-2147483648", RHBAConverter.derivePortSpeed("2"));
            this.assertEquals("-2147483648", RHBAConverter.derivePortSpeed("4"));
            this.assertEquals("0", RHBAConverter.derivePortSpeed("8"));
            this.assertEquals("0", RHBAConverter.derivePortSpeed("5"));
            this.assertEquals("0", RHBAConverter.derivePortSpeed(""));
            this.assertEquals("0", RHBAConverter.derivePortSpeed("Speed"));
            this.assertEquals("0", RHBAConverter.derivePortSpeed(null));
            this.assertEquals("Online", RHBAConverter.derivePortState("2"));
            this.assertEquals("Offline", RHBAConverter.derivePortState("3"));
            this.assertEquals("Bypassed", RHBAConverter.derivePortState("4"));
            this.assertEquals("Diagnostic", RHBAConverter.derivePortState("5"));
            this.assertEquals("Link Down", RHBAConverter.derivePortState("6"));
            this.assertEquals("Error", RHBAConverter.derivePortState("7"));
            this.assertEquals("LoopBack", RHBAConverter.derivePortState("8"));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortState("1"));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortState(""));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortState("State"));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortState(null));
            this.assertEquals("OK", RHBAConverter.derivePortStatus("2"));
            this.assertEquals("Stopped", RHBAConverter.derivePortStatus("3"));
            this.assertEquals("Lost Comm", RHBAConverter.derivePortStatus("4"));
            this.assertEquals("Service", RHBAConverter.derivePortStatus("5"));
            this.assertEquals("Error", RHBAConverter.derivePortStatus("6"));
            this.assertEquals("Error", RHBAConverter.derivePortStatus("7"));
            this.assertEquals("Service", RHBAConverter.derivePortStatus("8"));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortStatus("1"));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortStatus(""));
            this.assertEquals(RHBAConverter.UNKNOWN, RHBAConverter.derivePortStatus(null));
            this.assertEquals("3", RHBAConverter.derivePortAvailability("2"));
            this.assertEquals("2", RHBAConverter.derivePortAvailability(""));
            this.assertEquals("2", RHBAConverter.derivePortAvailability(null));
            this.assertEquals("2", RHBAConverter.derivePortAvailability("funky"));
        }
    }
}

