/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolutionException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.services.topology.Configuration;
import com.sun.netstorage.mgmt.services.topology.TSTopologyEdge;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraphAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyPredicate;
import diva.graph.modular.CompositeNode;
import diva.graph.modular.Edge;
import diva.graph.modular.Graph;
import diva.util.ArrayIterator;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TopologyNodeAdapter
implements TSTopologyNode,
CompositeNode {
    static final String sccs_id = "@(#)TopologyNodeAdapter.java 1.42  03/07/28 SMI";
    private String delegate_ = null;
    private List childNodes_ = new ArrayList();
    private List inEdges_ = new ArrayList();
    private List outEdges_ = new ArrayList();
    private TopologyNodeAdapter root_ = null;
    private String domainId_ = null;
    private String type_ = null;
    private Map properties_ = new HashMap();
    private TopologyNodeAdapter immediateParent_ = null;
    private static final String ID_RESOLVER_PKG_NAME = "com.sun.netstorage.mgmt.esm.logic.identity.api";

    protected void add(TSTopologyNode tSTopologyNode) {
        this.childNodes_.add(tSTopologyNode);
    }

    protected void remove(TSTopologyNode tSTopologyNode) {
        this.childNodes_.remove(tSTopologyNode);
    }

    protected void addInEdge(Edge edge) {
        this.inEdges_.add(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.outEdges_.add(edge);
    }

    public synchronized boolean contains(TSTopologyNode tSTopologyNode) {
        return this.childNodes_.contains(tSTopologyNode);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TSTopologyNode) {
            TopologyNodeAdapter topologyNodeAdapter = (TopologyNodeAdapter)object;
            if (this.delegate_ != null && this.domainId_ != null && this.type_ != null) {
                return this.delegate_.equals(topologyNodeAdapter.delegate_) && this.domainId_.equals(topologyNodeAdapter.domainId_) && this.type_.equals(topologyNodeAdapter.type_);
            }
        }
        return false;
    }

    public synchronized int getNodeCount() {
        return this.childNodes_.size();
    }

    public Iterator nodes() {
        return this.childNodes_.iterator();
    }

    public synchronized TSTopologyNode[] getChildren() {
        return this.childNodes_.toArray(new TSTopologyNode[this.childNodes_.size()]);
    }

    public synchronized TSTopologyNode[] getChildSubset(TopologyPredicate topologyPredicate) {
        ArrayList<TSTopologyNode> arrayList = new ArrayList<TSTopologyNode>();
        if (topologyPredicate != null) {
            Iterator iterator = this.childNodes_.iterator();
            while (iterator.hasNext()) {
                TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
                if (!topologyPredicate.execute(tSTopologyNode)) continue;
                arrayList.add(tSTopologyNode);
            }
        }
        return arrayList.toArray(new TSTopologyNode[arrayList.size()]);
    }

    public synchronized String getId() {
        return this.domainId_;
    }

    public Graph getParent() {
        return this.root_;
    }

    public synchronized Map getProperties() {
        return Collections.unmodifiableMap(this.properties_);
    }

    public synchronized Object getProperty(String string) {
        return this.properties_.get(string);
    }

    public synchronized Object getSemanticObject() {
        return this.delegate_;
    }

    public synchronized String getType() {
        return this.type_;
    }

    public synchronized boolean hasChild(TSTopologyNode tSTopologyNode) {
        return this.childNodes_.contains(tSTopologyNode);
    }

    public int hashCode() {
        return this.delegate_.hashCode() + this.type_.hashCode() + this.domainId_.hashCode();
    }

    public Iterator inEdges() {
        return new ArrayIterator(this.inEdges_.toArray());
    }

    public Date lastUpdated() {
        return null;
    }

    public Iterator outEdges() {
        return new ArrayIterator(this.outEdges_.toArray());
    }

    protected void removeInEdge(Edge edge) {
        this.inEdges_.remove(edge);
    }

    protected void removeOutEdge(Edge edge) {
        this.outEdges_.remove(edge);
    }

    public void setParent(Graph graph) {
        if (this.root_ != null) {
            this.root_.remove(this);
        }
        this.root_ = (TopologyNodeAdapter)graph;
        if (this.root_ != null) {
            this.root_.add(this);
        }
    }

    public void setProperty(String string, Object object) {
        this.properties_.put(string, object);
    }

    public void setSemanticObject(Object object) {
    }

    public String toString() {
        String string = "TSTopologyNode[ delegate = " + this.delegate_ + ", domainId = " + this.domainId_ + ", type = " + this.type_ + " ]";
        return string;
    }

    protected void setProperty(Object object, Object object2) {
        this.properties_.put(object, object2);
    }

    public TopologyNodeAdapter(TopologyNodeAdapter topologyNodeAdapter) {
        this.root_ = topologyNodeAdapter;
    }

    public TopologyNodeAdapter(String string, String string2, String string3, Map map, TSTopologyNode[] tSTopologyNodeArray, TopologyNodeAdapter topologyNodeAdapter, TopologyNodeAdapter topologyNodeAdapter2, List list, List list2) {
        this.delegate_ = string;
        this.domainId_ = string2;
        this.type_ = string3;
        this.root_ = topologyNodeAdapter;
        this.immediateParent_ = topologyNodeAdapter2;
        if (map != null) {
            this.properties_ = map;
        }
        if (tSTopologyNodeArray != null) {
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                this.add(tSTopologyNodeArray[n]);
                ((TopologyNodeAdapter)tSTopologyNodeArray[n]).setImmediateParent(this);
                ++n;
            }
        }
        if (list != null) {
            this.inEdges_ = list;
        }
        if (list2 != null) {
            this.outEdges_ = list2;
        }
    }

    protected TopologyNodeAdapter copy(TopologyGraphAdapter topologyGraphAdapter) {
        String string = new String(this.delegate_);
        String string2 = new String(this.domainId_);
        String string3 = new String(this.type_);
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.properties_);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.inEdges_);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.outEdges_);
        TSTopologyNode[] tSTopologyNodeArray = this.childNodes_.toArray(new TSTopologyNode[this.childNodes_.size()]);
        return new TopologyNodeAdapter(string, string2, string3, hashMap, tSTopologyNodeArray, (TopologyNodeAdapter)topologyGraphAdapter.getRoot(), this.immediateParent_, arrayList, arrayList2);
    }

    private String doEdgesToXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<inputEdges>");
        TSTopologyEdge[] tSTopologyEdgeArray = this.getInEdges();
        int n = 0;
        while (n < tSTopologyEdgeArray.length) {
            stringBuffer.append(tSTopologyEdgeArray[n].toXML());
            ++n;
        }
        stringBuffer.append("</inputEdges>");
        stringBuffer.append("<outputEdges>");
        TSTopologyEdge[] tSTopologyEdgeArray2 = this.getOutEdges();
        int n2 = 0;
        while (n2 < tSTopologyEdgeArray2.length) {
            stringBuffer.append(tSTopologyEdgeArray2[n2].toXML());
            ++n2;
        }
        stringBuffer.append("</outputEdges>");
        return stringBuffer.toString();
    }

    public synchronized TSTopologyNode getImmediateParent() {
        return this.immediateParent_;
    }

    public synchronized TSTopologyEdge[] getInEdges() {
        return this.inEdges_.toArray(new TSTopologyEdge[this.inEdges_.size()]);
    }

    public synchronized String getOid() {
        if (this.delegate_ != null) {
            return this.delegate_;
        }
        return "null";
    }

    public synchronized TSTopologyEdge[] getOutEdges() {
        return this.outEdges_.toArray(new TSTopologyEdge[this.outEdges_.size()]);
    }

    public boolean isIdEqual(String string) throws NotBoundException, RemoteException, IdentityException, IdentityResolutionException {
        Identity identity;
        IdentityType identityType;
        Identity identity2 = Identity.reconstitute((String)this.delegate_);
        IdentityType identityType2 = identity2.getType();
        if (identityType2.equals((Object)(identityType = (identity = Identity.reconstitute((String)string)).getType()))) {
            return identity2.equals((Object)identity);
        }
        int n = -1;
        String string2 = Configuration.getProperty("TR_REGISTRY_HOST");
        String string3 = Configuration.getProperty("TR_RMI_REGISTRY_PORT");
        if (string3 != null) {
            n = Integer.parseInt(string3);
        }
        Registry registry = LocateRegistry.getRegistry(string2, n);
        IdentityResolver identityResolver = (IdentityResolver)registry.lookup(ID_RESOLVER_PKG_NAME);
        return identityResolver.isEqual(identity2, identity);
    }

    protected void removeProperty(Object object) {
        if (object != null) {
            this.properties_.remove(object);
        }
    }

    protected void setImmediateParent(TopologyNodeAdapter topologyNodeAdapter) {
        this.immediateParent_ = topologyNodeAdapter;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<node>");
        stringBuffer.append("<delegate>" + this.getOid() + "</delegate>");
        stringBuffer.append("<domainId>" + this.domainId_ + "</domainId>");
        stringBuffer.append("<type>" + this.type_ + "</type>");
        stringBuffer.append(this.doEdgesToXML());
        stringBuffer.append("</node>");
        return stringBuffer.toString();
    }
}

