/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.FabricId;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.FabricTopologyImpl;
import com.sun.netstorage.mgmt.services.topology.OrphanTopologyImpl;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopologyImpl;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import java.util.Map;

public class ManagementDomain {
    static final String sccs_id = "@(#)ManagementDomain.java 1.39  03/09/02 SMI";
    private OrphanTopologyImpl orphanTopology_ = new OrphanTopologyImpl();
    SanTopologyImpl rootSan_ = new SanTopologyImpl("Default Root SAN");

    protected int getOrphanNodeCount() {
        return this.orphanTopology_.getNodeCount();
    }

    protected TSTopologyNode[] getOrphanNodes() {
        return this.orphanTopology_.getMembers();
    }

    protected SanTopology getSan(String string) {
        return this.rootSan_;
    }

    protected boolean orphanNodeExists(TSTopologyNode tSTopologyNode) {
        return this.orphanTopology_.contains(tSTopologyNode);
    }

    protected void removeEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, Object object) throws TopologyElementNotFoundException {
        this.rootSan_.removeEdge(tSTopologyNode, tSTopologyNode2, object);
    }

    private void removeFromOrphan(TSTopologyNode tSTopologyNode) {
        this.orphanTopology_.removeMember(tSTopologyNode);
    }

    protected void removeNode(TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        if (this.orphanTopology_.contains(tSTopologyNode)) {
            this.removeFromOrphan(tSTopologyNode);
            return;
        }
        this.rootSan_.removeNode(tSTopologyNode);
    }

    protected void addZone(FabricId fabricId, String string) throws TopologyElementNotFoundException, TopologyDuplicateElementException {
        this.rootSan_.addZone(fabricId.getFabricName(), string);
    }

    protected void removeZone(FabricId fabricId, String string) throws TopologyElementNotFoundException {
        this.rootSan_.removeZone(fabricId.getFabricName(), string);
    }

    protected void addZoneMember(FabricId fabricId, String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException, TopologyDuplicateElementException {
        this.rootSan_.addZoneMember(fabricId.getFabricName(), string, tSTopologyNode);
    }

    protected void removeZoneMember(FabricId fabricId, String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        this.rootSan_.removeZoneMember(fabricId.getFabricName(), string, tSTopologyNode);
    }

    public String toString() {
        return "ROOT SAN fabric count: " + this.rootSan_.getFabricCount();
    }

    private void addDasEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) throws TopologyElementNotFoundException {
        if (this.orphanNodeExists(tSTopologyNode)) {
            this.orphanTopology_.removeMember(tSTopologyNode);
        }
        if (this.orphanNodeExists(tSTopologyNode2)) {
            this.orphanTopology_.removeMember(tSTopologyNode2);
        }
        this.rootSan_.addDasEdge(tSTopologyNode, tSTopologyNode2, string, map);
    }

    protected void addEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, boolean bl, Map map) throws TopologyElementNotFoundException {
        if (!bl) {
            this.addFabricEdge(tSTopologyNode, tSTopologyNode2, string, map);
        } else {
            this.addDasEdge(tSTopologyNode, tSTopologyNode2, string, map);
        }
    }

    private void addFabricEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) throws TopologyElementNotFoundException {
        if (this.orphanTopology_.contains(tSTopologyNode) && this.orphanTopology_.contains(tSTopologyNode2)) {
            this.makeLinkNewFabric(tSTopologyNode, tSTopologyNode2, string, map);
        } else if (!this.orphanTopology_.contains(tSTopologyNode) && !this.orphanTopology_.contains(tSTopologyNode2)) {
            this.makeLink(tSTopologyNode, tSTopologyNode2, string, map);
        } else if (this.orphanTopology_.contains(tSTopologyNode) && !this.orphanTopology_.contains(tSTopologyNode2)) {
            this.makeLinkHeadOrphaned(tSTopologyNode, tSTopologyNode2, string, map);
        } else if (this.orphanTopology_.contains(tSTopologyNode2) && !this.orphanTopology_.contains(tSTopologyNode)) {
            this.makeLinkTailOrphaned(tSTopologyNode, tSTopologyNode2, string, map);
        }
    }

    protected TSTopologyNode addNode(String string, String string2, String string3, Map map, TSTopologyNode[] tSTopologyNodeArray, FabricId fabricId, TopologyNodeAdapter topologyNodeAdapter) throws TopologyDuplicateElementException {
        TSTopologyNode tSTopologyNode = null;
        if (fabricId == null) {
            tSTopologyNode = this.orphanTopology_.addMember(string, string2, string3, map, tSTopologyNodeArray, topologyNodeAdapter);
        } else {
            tSTopologyNode = this.addNodeToRootSan(string, string2, string3, map, tSTopologyNodeArray, fabricId, topologyNodeAdapter);
            TSTopologyNode tSTopologyNode2 = this.orphanTopology_.findNode(string);
            if (tSTopologyNode2 != null) {
                this.orphanTopology_.removeMember(tSTopologyNode2);
            }
        }
        return tSTopologyNode;
    }

    private TSTopologyNode addNodeToRootSan(String string, String string2, String string3, Map map, TSTopologyNode[] tSTopologyNodeArray, FabricId fabricId, TopologyNodeAdapter topologyNodeAdapter) throws TopologyDuplicateElementException {
        TSTopologyNode tSTopologyNode = null;
        FabricTopologyImpl fabricTopologyImpl = null;
        String string4 = fabricId.getFabricName();
        if (string4.equals("DAS Topology")) {
            tSTopologyNode = this.rootSan_.addDasNode(string.toString(), string2, string3, map, tSTopologyNodeArray, topologyNodeAdapter);
        } else if (this.rootSan_.contains(string4)) {
            fabricTopologyImpl = (FabricTopologyImpl)this.rootSan_.getFabric(string4);
            String string5 = fabricId.getLogicalNameCached();
            if (string5 != null) {
                fabricTopologyImpl.setLogicalName(string5);
            }
            tSTopologyNode = fabricTopologyImpl.addNode(string, string2, string3, map, tSTopologyNodeArray, topologyNodeAdapter);
        } else {
            fabricTopologyImpl = (FabricTopologyImpl)this.rootSan_.createFabric(fabricId);
            tSTopologyNode = fabricTopologyImpl.addNode(string, string2, string3, map, tSTopologyNodeArray, topologyNodeAdapter);
        }
        return tSTopologyNode;
    }

    private void makeLink(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) throws TopologyElementNotFoundException {
        FabricTopology[] fabricTopologyArray = this.rootSan_.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            if (fabricTopologyArray[n].contains(tSTopologyNode) && fabricTopologyArray[n].contains(tSTopologyNode2)) {
                ((FabricTopologyImpl)fabricTopologyArray[n]).addEdge(tSTopologyNode, tSTopologyNode2, string, map);
                return;
            }
            ++n;
        }
        throw new TopologyElementNotFoundException("Node not found within topology.");
    }

    private void makeLinkHeadOrphaned(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) throws TopologyElementNotFoundException {
        FabricTopology[] fabricTopologyArray = this.rootSan_.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            if (fabricTopologyArray[n].contains(tSTopologyNode2)) {
                this.orphanTopology_.removeMember(tSTopologyNode);
                ((FabricTopologyImpl)fabricTopologyArray[n]).addEdge(tSTopologyNode, tSTopologyNode2, string, map);
                return;
            }
            ++n;
        }
        throw new TopologyElementNotFoundException("Node not found within topology.");
    }

    private void makeLinkNewFabric(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) throws TopologyElementNotFoundException {
        this.orphanTopology_.removeMember(tSTopologyNode);
        this.orphanTopology_.removeMember(tSTopologyNode2);
        FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)this.rootSan_.createFabric();
        fabricTopologyImpl.addEdge(tSTopologyNode, tSTopologyNode2, string, map);
    }

    private void makeLinkTailOrphaned(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) throws TopologyElementNotFoundException {
        FabricTopology[] fabricTopologyArray = this.rootSan_.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            if (fabricTopologyArray[n].contains(tSTopologyNode)) {
                this.orphanTopology_.removeMember(tSTopologyNode2);
                ((FabricTopologyImpl)fabricTopologyArray[n]).addEdge(tSTopologyNode, tSTopologyNode2, string, map);
                return;
            }
            ++n;
        }
        throw new TopologyElementNotFoundException("Node not found within topology.");
    }

    protected void moveAllOrphans() {
        FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)this.rootSan_.getFabric("DEFAULT_FABRIC");
        TSTopologyNode[] tSTopologyNodeArray = this.getOrphanNodes();
        if (fabricTopologyImpl == null && tSTopologyNodeArray.length > 0) {
            FabricId fabricId = new FabricId("DEFAULT_FABRIC", "Default Root SAN");
            fabricTopologyImpl = (FabricTopologyImpl)this.rootSan_.createFabric(fabricId);
        }
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            this.removeFromOrphan(tSTopologyNodeArray[n]);
            try {
                fabricTopologyImpl.addNode(tSTopologyNodeArray[n]);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                // empty catch block
            }
            ++n;
        }
    }
}

