#!/bin/ksh
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2002 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#

# Sun Cluster Data Services Builder template version 1.0
#
# Monitor stop method for scmtp
#
# Stops the monitor that is running. This is done via PMF.

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in
		R)
		# Name of the scmtp resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err \
		-t [$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done
}

###############################################################################
# MAIN
##############################################################################
DEBUG_PARMS="$*"

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method
parse_args "$@"

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.mon
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

emp_debug_info="`scha_resource_get -O Extension -R $RESOURCE_NAME \
        -G $RESOURCEGROUP_NAME Debug`"
EMP_DEBUG=`echo $emp_debug_info | awk '{print $2}'`

if [ "$EMP_DEBUG" = "ON" ]
then
	logger -p ${SYSLOG_FACILITY}.notice \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Starting monitor stop for scmtp with parameters $DEBUG_PARMS"
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# See if the monitor (probe) is running, and if so, kill it. 
if pmfadm -q $PMF_TAG >/dev/null 2>&1; then 
	# User added code -- BEGIN vvvvvvvvvvvvvvv
	# User added code -- END   ^^^^^^^^^^^^^^^

	pmfadm -s $PMF_TAG KILL >/dev/null 2>&1
	if [ $? -ne 0 ]; then 
		logger -p ${SYSLOG_FACILITY}.err \
			-t [$SYSLOG_TAG] \
			"${ARGV0} Could not stop monitor for resource $RESOURCE_NAME"
		exit 1
	else
          if [ "$EMP_DEBUG" = "ON" ]
          then
		# could successfully stop the monitor. Log a message.
		logger -p ${SYSLOG_FACILITY}.notice \
			-t [$SYSLOG_TAG] \
			"${ARGV0} Monitor for resource $RESOURCE_NAME successfully stopped"
          fi
	fi

	# User added code -- BEGIN vvvvvvvvvvvvvvv
	# User added code -- END   ^^^^^^^^^^^^^^^

else
  # Monitor already stopped. Log a message.
  if [ "$EMP_DEBUG" = "ON" ]
  then
	logger -p ${SYSLOG_FACILITY}.notice \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Monitor for resource $RESOURCE_NAME found already stopped"
  fi
fi

exit 0
