#!/bin/ksh
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2002 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#

# Sun Cluster Data Services Builder template version 1.0
#
# Monitor start Method for scmtp.
#

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in
		R)
		# Name of the scmtp resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err \
	    	-t [$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done

}

###############################################################################
# MAIN
##############################################################################
DEBUG_PARMS="$*"

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method
parse_args "$@"

# We need to know where the probe method resides. This is specified in the 
# RT_BASEDIR property of the resource type.
RT_BASEDIR=`scha_resource_get -O RT_BASEDIR -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME`

emp_monitor_info="`scha_resource_get -O Extension -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME Monitor`"
EMP_MONITOR=`echo $emp_monitor_info | awk '{print $2}'`

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.mon
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

emp_debug_info="`scha_resource_get -O Extension -R $RESOURCE_NAME \
        -G $RESOURCEGROUP_NAME Debug`"
EMP_DEBUG=`echo $emp_debug_info | awk '{print $2}'`

if [ "$EMP_DEBUG" = "ON" ]
then
	logger -p ${SYSLOG_FACILITY}.notice \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Starting monitor start for scmtp with parameters $DEBUG_PARMS"
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

if [ "$EMP_MONITOR" = "NONE" -o "$EMP_MONITOR" = "none" ]
then
# Log a message indicating that the monitor for scmtp will not be started.
  if [ "$EMP_DEBUG" = "ON" ]
  then
	logger -p ${SYSLOG_FACILITY}.notice \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Monitor for scmtp will not be started, EMP_MONITOR=$EMP_MONITOR"
  fi
else
# Start the probe for the data service under PMF. Use the infinite retries 
# option to start the probe. Pass the the Resource name, type and group to the 
# probe method. 
  pmfadm -c $PMF_TAG -n -1 -t -1 \
	$RT_BASEDIR/scmtp_probe.ksh -R $RESOURCE_NAME -G $RESOURCEGROUP_NAME \
	-T $RESOURCETYPE_NAME >/dev/null 2>&1
  ret_status=$?

# Log a message indicating that the monitor for scmtp has been started.
  if [ $ret_status -eq 0 ]
  then
    if [ "$EMP_DEBUG" = "ON" ]
    then
	logger -p ${SYSLOG_FACILITY}.notice \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Monitor for scmtp successfully started"
    fi
  else
	logger -p ${SYSLOG_FACILITY}.err \
		-t [$SYSLOG_TAG] \
		"${ARGV0} PMF failed to start monitor for scmtp, status=$ret_status"
  fi
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

exit 0
 
