/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.ConnectionInfo;
import com.netscape.admin.dirserv.status.ConnectionTableModel;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.ResourceSummaryInfo;
import com.netscape.admin.dirserv.status.ResourceSummaryTableModel;
import com.netscape.admin.dirserv.status.ResourceUsageInfo;
import com.netscape.admin.dirserv.status.ResourceUsageTableModel;
import com.netscape.admin.dirserv.status.StatusRefreshPanel;
import com.netscape.admin.dirserv.status.ToolTipCellRenderer;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

class StatusRootPanel
extends StatusRefreshPanel {
    private LDAPEntry _configEntry;
    private LDAPEntry _monitorEntry;
    private JTable _tResourceSummary;
    private ResourceSummaryTableModel _modelResourceSummary;
    private JTable _tResourceUsage;
    private ResourceUsageTableModel _modelResourceUsage;
    private JTable _tConnections;
    private ConnectionTableModel _modelConnection;
    private JScrollPane _scrollConnections;
    private JLabel _lStartupTime;
    private JLabel _lCurrentTime;
    private final JLabel REFRESH_LABEL;
    private JLabel NO_CONNECTION_AVAILABLE;
    private static final int SUMMARY_ROWS = 5;
    private static final int USAGE_ROWS = 5;
    private static final int CONNECTION_COLUMNS = 6;
    private static final String[] CONFIG_ATTRS = new String[]{"nsslapd-maxdescriptors", "nsslapd-reservedescriptors"};
    private static final String[] MONITOR_ATTRS = new String[]{"currenttime", "starttime", "connection", "totalconnections", "opsinitiated", "opscompleted", "entriessent", "bytessent", "threads", "currentconnections", "dtablesize", "readwaiters", "nbackends"};
    private final String CANNOT_CALCULATE_AVERAGE;
    private final String NOT_BOUND;
    private final String NOT_BLOCKED;
    private final String BLOCKED;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JLabel;

    public StatusRootPanel(IStatusModel iStatusModel) {
        super(iStatusModel, true);
        this.REFRESH_LABEL = new JLabel(this._resource.getString("rootpanel", "reading-label"));
        this.CANNOT_CALCULATE_AVERAGE = this._resource.getString("rootpanel", "cannotcalculateaverage-label");
        this.NOT_BOUND = this._resource.getString("rootpanel", "notbound-label");
        this.NOT_BLOCKED = this._resource.getString("rootpanel", "notblocked-label");
        this.BLOCKED = this._resource.getString("rootpanel", "blocked-label");
    }

    protected void initResources() {
        this._helpToken = "status-globalcounters-help";
        this._taRights = new MultilineLabel(this._resource.getString("rootpanel", "rights-label"), 2, 50);
        this._taError = new MultilineLabel(2, 50);
    }

    protected void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            try {
                if (this._contentPane == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusRootPanel.this.showComponent(StatusRootPanel.this.REFRESH_LABEL, true);
                        }
                    });
                    this.createContentPane();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusRootPanel.this._lUpdating.setVisible(true);
                        }
                    });
                }
                this.readEntries();
                final String string = DSUtil.formatDateTime(DSUtil.getAttrValue(this._monitorEntry, "currenttime"));
                final String string2 = DSUtil.formatDateTime(DSUtil.getAttrValue(this._monitorEntry, "starttime"));
                final ConnectionInfo[] connectionInfoArray = this.getConnectionInfo(this._monitorEntry);
                final ResourceSummaryInfo resourceSummaryInfo = this.getResourceSummaryInfo(this._monitorEntry);
                final ResourceUsageInfo resourceUsageInfo = this.getResourceUsageInfo(this._monitorEntry, this._configEntry);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusRootPanel.this._lStartupTime.setText(string2);
                        StatusRootPanel.this._lCurrentTime.setText(string);
                        StatusRootPanel.this._modelResourceSummary.updateData(resourceSummaryInfo);
                        StatusRootPanel.this._modelResourceUsage.updateData(resourceUsageInfo);
                        StatusRootPanel.this._modelConnection.updateData(connectionInfoArray);
                        StatusRootPanel.this._scrollConnections.setVisible(connectionInfoArray.length > 0);
                        StatusRootPanel.this.NO_CONNECTION_AVAILABLE.setVisible(connectionInfoArray.length == 0);
                        StatusRootPanel.this.updateTableSizes();
                        StatusRootPanel.this.showComponent(StatusRootPanel.this._contentPane, false);
                        StatusRootPanel.this._lUpdating.setVisible(false);
                    }
                });
            }
            catch (NullPointerException nullPointerException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusRootPanel.this.showComponent(StatusRootPanel.this._taRights, true);
                    }
                });
            }
            catch (LDAPException lDAPException) {
                final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusRootPanel.this._taError.setText(StatusRootPanel.this._resource.getString("rootpanel", "error-reloading-label", stringArray));
                        StatusRootPanel.this.showComponent(StatusRootPanel.this._taError, true);
                    }
                });
            }
            this._isReloading = false;
        }
    }

    private void createContentPane() {
        this._contentPane = new JPanel(new GridBagLayout());
        JPanel jPanel = this.createRefreshArea();
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        JLabel jLabel = UIFactory.makeJLabel("rootpanel", "lstartuptime", this._resource);
        this._lStartupTime = new JLabel();
        jLabel.setLabelFor(this._lStartupTime);
        this._lStartupTime.setLabelFor(jLabel);
        JLabel jLabel2 = UIFactory.makeJLabel("rootpanel", "lcurrenttime", this._resource);
        this._lCurrentTime = new JLabel();
        jLabel2.setLabelFor(this._lCurrentTime);
        this._lCurrentTime.setLabelFor(jLabel2);
        String[] stringArray = new String[]{this._resource.getString("rootpanel", "summaryheader0"), this._resource.getString("rootpanel", "summaryheader1"), this._resource.getString("rootpanel", "summaryheader2")};
        JLabel[] jLabelArray = new JLabel[5];
        int n = 0;
        while (n < 5) {
            jLabelArray[n] = UIFactory.makeJLabel("rootpanel", "summarylabel" + n, this._resource);
            ++n;
        }
        this._modelResourceSummary = new ResourceSummaryTableModel();
        this._modelResourceSummary.setHeaders(stringArray);
        this._modelResourceSummary.setLabels(jLabelArray);
        JLabel jLabel3 = UIFactory.makeJLabel("rootpanel", "lresourcesummary", this._resource);
        this._tResourceSummary = new JTable(this._modelResourceSummary);
        this._tResourceSummary.setAutoResizeMode(3);
        this._tResourceSummary.setColumnSelectionAllowed(false);
        this._tResourceSummary.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusRootPanel.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        this._tResourceSummary.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = StatusRootPanel.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, labelCellRenderer);
        this._tResourceSummary.getTableHeader().setReorderingAllowed(false);
        jLabel3.setLabelFor(this._tResourceSummary);
        JScrollPane jScrollPane = new JScrollPane(this._tResourceSummary, 21, 30);
        JLabel[] jLabelArray2 = new JLabel[5];
        int n2 = 0;
        while (n2 < 5) {
            jLabelArray2[n2] = UIFactory.makeJLabel("rootpanel", "usagelabel" + n2, this._resource);
            ++n2;
        }
        this._modelResourceUsage = new ResourceUsageTableModel();
        this._modelResourceUsage.setLabels(jLabelArray2);
        JLabel jLabel4 = UIFactory.makeJLabel("rootpanel", "lresourceusage", this._resource);
        this._tResourceUsage = new JTable(this._modelResourceUsage);
        this._tResourceUsage.setAutoResizeMode(3);
        this._tResourceUsage.setColumnSelectionAllowed(false);
        this._tResourceUsage.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusRootPanel.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        this._tResourceUsage.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = StatusRootPanel.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, labelCellRenderer);
        this._tResourceUsage.getTableHeader().setReorderingAllowed(false);
        jLabel4.setLabelFor(this._tResourceUsage);
        JScrollPane jScrollPane2 = new JScrollPane(this._tResourceUsage, 21, 30);
        String[] stringArray2 = new String[6];
        int n3 = 0;
        while (n3 < 6) {
            stringArray2[n3] = this._resource.getString("rootpanel", "connectionheader" + n3);
            ++n3;
        }
        this._modelConnection = new ConnectionTableModel();
        this._modelConnection.setHeaders(stringArray2);
        JLabel jLabel5 = UIFactory.makeJLabel("rootpanel", "lconnections", this._resource);
        this._tConnections = new JTable(this._modelConnection);
        this._tConnections.setAutoResizeMode(3);
        this._tConnections.setColumnSelectionAllowed(false);
        String[] stringArray3 = new String[6];
        int n4 = 0;
        while (n4 < 6) {
            stringArray3[n4] = this._resource.getString("rootpanel-connectionheader" + n4, "tooltip");
            ++n4;
        }
        ToolTipCellRenderer toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(stringArray3);
        this._tConnections.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusRootPanel.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        jLabel5.setLabelFor(this._tConnections);
        this._scrollConnections = new JScrollPane(this._tConnections, 21, 30);
        this.NO_CONNECTION_AVAILABLE = UIFactory.makeJLabel("rootpanel", "lnoconnectionavailable", this._resource);
        this.NO_CONNECTION_AVAILABLE.setFont(this.NO_CONNECTION_AVAILABLE.getFont().deriveFont(2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this._contentPane.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        this._contentPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this._contentPane.add((Component)this._lStartupTime, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        this._contentPane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this._contentPane.add((Component)this._lCurrentTime, gridBagConstraints);
        gridBagConstraints.fill = 2;
        this._contentPane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this._contentPane.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this._contentPane.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this._contentPane.add((Component)this._scrollConnections, gridBagConstraints);
        this._contentPane.add((Component)this.NO_CONNECTION_AVAILABLE, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPane.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void readEntries() throws LDAPException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        this._monitorEntry = lDAPConnection.read("cn=monitor", MONITOR_ATTRS);
        this._configEntry = lDAPConnection.read("cn=config", CONFIG_ATTRS);
        if (this._monitorEntry == null || this._configEntry == null) {
            throw new NullPointerException();
        }
    }

    private ConnectionInfo[] getConnectionInfo(LDAPEntry lDAPEntry) {
        ConnectionInfo[] connectionInfoArray;
        ArrayList<ConnectionInfo> arrayList = new ArrayList<ConnectionInfo>();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("connection");
        if (lDAPAttribute != null) {
            connectionInfoArray = lDAPAttribute.getStringValues();
            boolean bl = false;
            while (connectionInfoArray.hasMoreElements()) {
                String string = (String)connectionInfoArray.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                bl = false;
                ConnectionInfo connectionInfo = new ConnectionInfo();
                try {
                    Integer.parseInt(stringTokenizer.nextToken());
                    connectionInfo.timeOpened = stringTokenizer.nextToken();
                    connectionInfo.opInitiated = stringTokenizer.nextToken();
                    if (connectionInfo.opInitiated.equals("")) {
                        connectionInfo.opInitiated = "0";
                    }
                    connectionInfo.opCompleted = stringTokenizer.nextToken();
                    if (connectionInfo.opCompleted.equals("")) {
                        connectionInfo.opCompleted = "0";
                    }
                    connectionInfo.state = stringTokenizer.nextToken();
                    connectionInfo.boundAs = stringTokenizer.nextToken();
                    connectionInfo.type = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    connectionInfo.type = connectionInfo.boundAs;
                    connectionInfo.boundAs = connectionInfo.state;
                    connectionInfo.state = "";
                }
                connectionInfo.timeOpened = DSUtil.getDateTime(connectionInfo.timeOpened).toString();
                if (connectionInfo.boundAs.equals("NULLDN")) {
                    connectionInfo.boundAs = this.NOT_BOUND;
                }
                if (connectionInfo.state.equals("")) {
                    connectionInfo.state = this.NOT_BLOCKED;
                } else if (connectionInfo.state.charAt(0) == 'r') {
                    connectionInfo.state = this.BLOCKED;
                }
                arrayList.add(connectionInfo);
            }
        }
        connectionInfoArray = new ConnectionInfo[arrayList.size()];
        arrayList.toArray(connectionInfoArray);
        return connectionInfoArray;
    }

    private ResourceUsageInfo getResourceUsageInfo(LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2) {
        ResourceUsageInfo resourceUsageInfo = new ResourceUsageInfo();
        resourceUsageInfo.activeThreads = DSUtil.getAttrValue(lDAPEntry, "threads");
        resourceUsageInfo.openConnections = DSUtil.getAttrValue(lDAPEntry, "currentconnections");
        resourceUsageInfo.threadsWaiting = DSUtil.getAttrValue(lDAPEntry, "readwaiters");
        resourceUsageInfo.databasesNumber = DSUtil.getAttrValue(lDAPEntry, "nbackends");
        String string = DSUtil.getAttrValue(lDAPEntry, "dtablesize");
        String string2 = DSUtil.getAttrValue(lDAPEntry, "currentconnections");
        String string3 = DSUtil.getAttrValue(lDAPEntry2, "nsslapd-maxdescriptors");
        String string4 = DSUtil.getAttrValue(lDAPEntry2, "nsslapd-reservedescriptors");
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        int n3 = string3.length() == 0 ? n : Integer.parseInt(string3);
        int n4 = string4.length() == 0 ? 0 : Integer.parseInt(string4);
        int n5 = n3 - n4 - n2;
        resourceUsageInfo.remainingAvailableConnections = String.valueOf(n5);
        return resourceUsageInfo;
    }

    private ResourceSummaryInfo getResourceSummaryInfo(LDAPEntry lDAPEntry) {
        Object object;
        Object object2;
        String string = DSUtil.getAttrValue(lDAPEntry, "starttime");
        String string2 = DSUtil.getAttrValue(lDAPEntry, "currenttime");
        long l = -1L;
        if (string.length() > 0 && string2.length() > 0) {
            object2 = DSUtil.getDateTime(string);
            object = DSUtil.getDateTime(string2);
            l = (((Date)object).getTime() - ((Date)object2).getTime()) / 60000L;
            if (l < 1L) {
                l = 1L;
            }
        }
        object2 = new ResourceSummaryInfo();
        ((ResourceSummaryInfo)object2).connections = DSUtil.getAttrValue(lDAPEntry, "totalconnections");
        ((ResourceSummaryInfo)object2).connectionsAverage = this.getAverage(((ResourceSummaryInfo)object2).connections, l);
        ((ResourceSummaryInfo)object2).opInitiated = DSUtil.getAttrValue(lDAPEntry, "opsinitiated");
        ((ResourceSummaryInfo)object2).opInitiatedAverage = this.getAverage(((ResourceSummaryInfo)object2).opInitiated, l);
        ((ResourceSummaryInfo)object2).opCompleted = DSUtil.getAttrValue(lDAPEntry, "opscompleted");
        ((ResourceSummaryInfo)object2).opCompletedAverage = this.getAverage(((ResourceSummaryInfo)object2).opCompleted, l);
        ((ResourceSummaryInfo)object2).entriesSent = DSUtil.getAttrValue(lDAPEntry, "entriessent");
        ((ResourceSummaryInfo)object2).entriesSentAverage = this.getAverage(((ResourceSummaryInfo)object2).entriesSent, l);
        object = DSUtil.getAttrValue(lDAPEntry, "bytessent");
        float f = Long.parseLong((String)object);
        float f2 = f / 1024.0f;
        f2 = (float)((double)((long)(((double)f2 + 0.05) * 10.0)) / 10.0);
        ((ResourceSummaryInfo)object2).kbSent = String.valueOf(f2);
        ((ResourceSummaryInfo)object2).kbSentAverage = this.getAverage(((ResourceSummaryInfo)object2).kbSent, l);
        return object2;
    }

    private String getAverage(String string, long l) {
        String string2;
        if (l > 0L) {
            float f = Float.valueOf(string).floatValue() / (float)l;
            f = (float)((double)((long)(((double)f + 0.05) * 10.0)) / 10.0);
            string2 = Float.toString(f);
        } else {
            string2 = this.CANNOT_CALCULATE_AVERAGE;
        }
        return string2;
    }

    private void updateTableSizes() {
        int n = this.getTotalHeight(this._tResourceSummary);
        this._tResourceSummary.setPreferredScrollableViewportSize(new Dimension(10, n));
        n = this.getTotalHeight(this._tResourceUsage);
        this._tResourceUsage.setPreferredScrollableViewportSize(new Dimension(10, n));
        n = this.getTotalHeight(this._tConnections);
        this._tConnections.setPreferredScrollableViewportSize(new Dimension(10, n));
    }

    private int getTotalHeight(JTable jTable) {
        return jTable.getRowCount() * jTable.getRowHeight();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

