/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.roledit;

import com.netscape.admin.dirserv.DSResourceEditor;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.roledit.RoleCache;
import com.netscape.admin.dirserv.roledit.RoleEditorTab;
import com.netscape.admin.dirserv.roledit.RolePickerDialog;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class RoleEditorDialog
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    JFrame _frame;
    ConsoleInfo _info;
    RoleCache _managedRoleCache;
    RoleCache _complexRoleCache;
    JTabbedPane _tabPane;
    RoleEditorTab _managedRoleTab;
    RoleEditorTab _complexRoleTab;
    private static final ResourceSet _resource = DSUtil._resource;
    private static final String _section = "roleEditorDialog";
    private static final String NSROLEDN_ATTR = "nsRoleDN";
    private static final String NSROLE_ATTR = "nsRole";
    private static final String[] ROLE_ATTRS = new String[]{"objectclass", "nsRoleDN", "nsRole"};
    private static final String CN_ATTR = "cn";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String OBJECTCLASS_ATTR = "objectclass";
    private static final String[] BASIC_ATTRS = new String[]{"cn", "description", "objectclass"};

    public RoleEditorDialog(JFrame jFrame, ConsoleInfo consoleInfo) {
        super((Frame)jFrame, _resource.getString(_section, "title"), true, 11);
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, DESCRIPTION_ATTR));
        this._frame = jFrame;
        this._info = consoleInfo;
        this._managedRoleCache = new RoleCache(true);
        this._complexRoleCache = new RoleCache(true);
        this._tabPane = new JTabbedPane();
        this._managedRoleTab = new RoleEditorTab(true);
        this._managedRoleTab.getAddButton().addActionListener(this);
        this._managedRoleTab.getAddButton().getAccessibleContext().setAccessibleDescription(this._managedRoleTab.getAddButton().getText());
        this._managedRoleTab.getRemoveButton().addActionListener(this);
        this._managedRoleTab.getRemoveButton().getAccessibleContext().setAccessibleDescription(this._managedRoleTab.getRemoveButton().getText());
        this._managedRoleTab.getEditButton().addActionListener(this);
        this._managedRoleTab.getEditButton().getAccessibleContext().setAccessibleDescription(this._managedRoleTab.getEditButton().getText());
        this._managedRoleTab.getTableSelectionModel().addListSelectionListener(this);
        this._complexRoleTab = new RoleEditorTab(false);
        this._complexRoleTab.getEditButton().addActionListener(this);
        this._complexRoleTab.getEditButton().getAccessibleContext().setAccessibleDescription(this._complexRoleTab.getEditButton().getText());
        this._complexRoleTab.getTableSelectionModel().addListSelectionListener(this);
        this.loadRoleCaches();
        this.layoutComponents();
    }

    void layoutComponents() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        container.add(this._tabPane);
        gridBagLayout.setConstraints(this._tabPane, gridBagConstraints);
        this._tabPane.addTab(_resource.getString(_section, "tab-managed-roles"), this._managedRoleTab);
        this._managedRoleTab.getTable().getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "tab-managed-roles"));
        this._tabPane.addTab(_resource.getString(_section, "tab-complex-roles"), this._complexRoleTab);
        this._complexRoleTab.getTable().getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "tab-complex-roles"));
        this._tabPane.setSelectedIndex(0);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBusyCursor(true);
        Object object = actionEvent.getSource();
        if (object == this._managedRoleTab.getEditButton()) {
            int n = this._managedRoleTab.getTableSelectionModel().getMinSelectionIndex();
            this.actionEdit(this._managedRoleCache, n);
        } else if (object == this._managedRoleTab.getAddButton()) {
            this.actionAdd();
        } else if (object == this._managedRoleTab.getRemoveButton()) {
            this.actionRemove();
        } else if (object == this._complexRoleTab.getEditButton()) {
            int n = this._complexRoleTab.getTableSelectionModel().getMinSelectionIndex();
            this.actionEdit(this._complexRoleCache, n);
        }
        this.setBusyCursor(false);
    }

    void actionAdd() {
        Object object;
        Object object2;
        String string;
        Vector vector = null;
        try {
            string = RolePickerDialog.makeParentDn(this._info.getCurrentDN());
            object2 = new RolePickerDialog(this._frame, this._info);
            object = this._managedRoleCache.getRoleDNs().elements();
            ((RolePickerDialog)object2).load(string, "nsmanagedroledefinition", (Enumeration)object);
            object2.showModal();
            if (!object2.isCancel()) {
                vector = ((RolePickerDialog)object2).getSelectedRoles();
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("RoleEditorDialog.actionAdd: reading roles failed with " + (Object)((Object)lDAPException)));
            DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "fetching-server-unavailable");
        }
        if (vector != null) {
            try {
                string = this._info.getLDAPConnection();
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    DN dN = new DN((String)object);
                    if (this._managedRoleCache.contains(dN)) continue;
                    this._managedRoleCache.add((String)object, (LDAPConnection)string);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("RoleEditorDialog.actionAdd: reading roles failed with " + (Object)((Object)lDAPException)));
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "updating-directory-title");
            }
        }
    }

    void actionRemove() {
        JTable jTable = this._managedRoleTab.getTable();
        int n = jTable.getModel().getRowCount();
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        int n2 = 0;
        while (n2 < n) {
            if (listSelectionModel.isSelectedIndex(n2)) {
                this._managedRoleCache.remove(n2);
            }
            ++n2;
        }
    }

    void actionEdit(RoleCache roleCache, int n) {
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        String string = roleCache.getRoleDN(n);
        try {
            String[] stringArray = new String[]{NSROLEDN_ATTR, "*"};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, string, stringArray, null);
            DSResourceEditor dSResourceEditor = new DSResourceEditor(this._frame, this._info, lDAPEntry);
            dSResourceEditor.showModal();
            DSUtil.dialogCleanup();
            String string2 = dSResourceEditor.getLDAPEntry().getDN();
            if (string.equals(string2)) {
                roleCache.sync(string, lDAPConnection);
            } else {
                roleCache.remove(string);
                roleCache.add(string2, lDAPConnection);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("RoleEditorDialog.actionEdit: " + string + " is obsolete"));
            JOptionPane.showMessageDialog((Component)((Object)this), _resource.getString(_section, "dangling-role-message"), _resource.getString(_section, "dangling-role-title"), 0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        RoleCache roleCache;
        JTable jTable;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel == this._managedRoleTab.getTableSelectionModel()) {
            jTable = this._managedRoleTab.getTable();
            roleCache = this._managedRoleCache;
        } else {
            jTable = this._complexRoleTab.getTable();
            roleCache = this._complexRoleCache;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 - n + 1 > 1 || roleCache.isEmpty()) {
            jTable.setToolTipText(null);
        } else {
            jTable.setToolTipText(roleCache.getRoleDN(n));
        }
    }

    protected void okInvoked() {
        String string = this._info.getCurrentDN();
        if (this._managedRoleCache.isRecordingEmpty()) {
            super.okInvoked();
        } else {
            try {
                this._managedRoleCache.saveRecording(string, this._info.getLDAPConnection());
                super.okInvoked();
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("RoleEditorDialog.okInvoked: failed to change roles of " + string));
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "updating-directory-title");
            }
        }
    }

    protected void helpInvoked() {
        DSUtil.help("configuration-set-role", this._info.getAdminURL());
    }

    void loadRoleCaches() {
        String string = this._info.getCurrentDN();
        String string2 = "RoleEditorDialog.loadRoleCaches(" + string + "): ";
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        try {
            Enumeration enumeration;
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, string, ROLE_ATTRS, null);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(NSROLEDN_ATTR);
            if (lDAPAttribute != null) {
                enumeration = lDAPAttribute.getStringValues();
                if (enumeration != null) {
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        this._managedRoleCache.add(string3, lDAPConnection);
                        ++n;
                    }
                    if (n == 0) {
                        Debug.println((int)0, (String)(string2 + "getStringValues(" + NSROLEDN_ATTR + ") returned an empty Enumeration !"));
                    }
                } else {
                    Debug.println((int)0, (String)(string2 + "getStringValues(" + NSROLEDN_ATTR + ") returned null !"));
                }
            } else {
                Debug.println((String)(string2 + "no " + NSROLEDN_ATTR + " attribute"));
            }
            if ((enumeration = lDAPEntry.getAttribute(NSROLE_ATTR)) != null) {
                Enumeration enumeration2 = enumeration.getStringValues();
                if (enumeration2 != null) {
                    int n = 0;
                    while (enumeration2.hasMoreElements()) {
                        String string4 = (String)enumeration2.nextElement();
                        LDAPEntry lDAPEntry2 = DSUtil.readEntry(lDAPConnection, string4, BASIC_ATTRS, null);
                        if (lDAPEntry2 == null) {
                            Debug.println((int)0, (String)(string2 + " readEntry(" + string4 + ") returned null !"));
                        } else if (RoleEditorDialog.isComplexRole(lDAPEntry2)) {
                            this._complexRoleCache.add(lDAPEntry2, lDAPConnection);
                        }
                        ++n;
                    }
                    if (n == 0) {
                        Debug.println((int)0, (String)(string2 + "getStringValues(" + NSROLE_ATTR + ") returned an empty Enumeration !"));
                    }
                } else {
                    Debug.println((int)0, (String)(string2 + "getStringValues(" + NSROLE_ATTR + ") returned NULL !"));
                }
            } else {
                Debug.println((String)(string2 + "no " + NSROLE_ATTR + " attribute"));
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)(string2 + "exception " + (Object)((Object)lDAPException)));
            Debug.println((int)0, (String)(string2 + "no roles have been loaded"));
        }
        this._managedRoleTab.getTable().setModel(this._managedRoleCache.getTableModel());
        this._complexRoleTab.getTable().setModel(this._complexRoleCache.getTableModel());
        this._managedRoleCache.enableRecording(true);
    }

    static boolean isComplexRole(LDAPEntry lDAPEntry) {
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(OBJECTCLASS_ATTR);
        if (lDAPAttribute == null) {
            Debug.println((int)0, (String)"RoleEditorDialog.isComplexRole: cannot find objectclass !");
        } else {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements() && !bl) {
                String string = (String)enumeration.nextElement();
                bl = string.equalsIgnoreCase("nscomplexroledefinition");
            }
        }
        return bl;
    }
}

