/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.roledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.roledit.RoleCache;
import com.netscape.admin.dirserv.roledit.RolePickerDialog;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.IResourceEditorPage;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class ResEditorNestedRole
extends JPanel
implements IResourceEditorPage,
Observer,
ActionListener,
ListSelectionListener {
    ResourceEditor _parent;
    ResourcePageObservable _observable;
    String _id = _resource.getString("nestedRolePage", "id");
    RoleCache _roleCache;
    boolean _isReadOnly = false;
    boolean _isEnabled = true;
    SuiTable _table;
    JButton _addButton;
    JButton _removeButton;
    static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "nestedRolePage";
    private static final String NSROLEDN_ATTR = "nsRoleDN";
    private static final String NSROLE_ATTR = "nsRole";
    private static final String[] ROLE_ATTRS = new String[]{"nsRoleDN"};

    public void update(Observable observable, Object object) {
        String string;
        if (!(observable instanceof ResourcePageObservable)) {
            return;
        }
        ResourcePageObservable resourcePageObservable = (ResourcePageObservable)observable;
        if (object instanceof String && (string = (String)object).equalsIgnoreCase(NSROLEDN_ATTR)) {
            this.loadCache();
        }
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._parent = resourceEditor;
        this._observable = resourcePageObservable;
        this._roleCache = new RoleCache(true);
        if (this._table == null) {
            JLabel jLabel = new JLabel(_resource.getString(_section, "label"));
            this._table = new SuiTable();
            jLabel.setLabelFor((Component)this._table);
            this._table.setModel(this._roleCache.getTableModel());
            this._table.setAutoResizeMode(4);
            this._table.getSelectionModel().addListSelectionListener(this);
            this._table.setPreferredScrollableViewportSize(new Dimension(10, 10));
            JScrollPane jScrollPane = SuiTable.createScrollPaneForTable((JTable)this._table);
            jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            this._addButton = UIFactory.makeJButton(this, _section, "addButton", _resource);
            this._removeButton = UIFactory.makeJButton(this, _section, "removeButton", _resource);
            JButtonFactory.resizeGroup((JButton)this._addButton, (JButton)this._removeButton);
            Box box = new Box(0);
            box.add(Box.createHorizontalGlue());
            box.add(this._addButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(this._removeButton);
            this.setLayout(new GridBagLayout());
            GridBagUtil.constrain((Container)this, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)17, (int)2, (int)9, (int)9, (int)0, (int)9);
            GridBagUtil.constrain((Container)this, (Component)jScrollPane, (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)17, (int)1, (int)0, (int)9, (int)0, (int)9);
            GridBagUtil.constrain((Container)this, (Component)box, (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0, (int)13, (int)0, (int)12, (int)6, (int)9, (int)9);
        }
        this.loadCache();
        this.valueChanged(null);
    }

    void loadCache() {
        this._roleCache.clear();
        this._roleCache.enableRecording(false);
        try {
            LDAPConnection lDAPConnection = this._parent.getConsoleInfo().getLDAPConnection();
            Vector vector = this._observable.get(NSROLEDN_ATTR);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._roleCache.add(string, lDAPConnection);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ResEditorNestedRole.loadCache: " + (Object)((Object)lDAPException) + " while loading the roles"));
        }
        this._roleCache.enableRecording(true);
    }

    public String getID() {
        return this._id;
    }

    public boolean afterSave(ResourcePageObservable resourcePageObservable) throws Exception {
        return true;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        if (!this._roleCache.isRecordingEmpty()) {
            Vector vector = this._roleCache.getRoleDNs();
            if (vector == null) {
                this._observable.delete(NSROLEDN_ATTR);
            } else {
                this._observable.replace(NSROLEDN_ATTR, vector);
            }
            this._roleCache.enableRecording(false);
            this._roleCache.enableRecording(true);
        }
        return true;
    }

    public void clear() {
    }

    public void reset() {
    }

    public void setDefault() {
    }

    public boolean isModified() {
        return !this._roleCache.isRecordingEmpty();
    }

    public void setModified(boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("Can't set to true");
        }
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public void setEnable(boolean bl) {
        this._isEnabled = bl;
    }

    public boolean isComplete() {
        boolean bl = true;
        if (this._roleCache.isEmpty()) {
            JOptionPane.showMessageDialog(null, _resource.getString(_section, "IncompleteText"), _resource.getString(_section, "IncompleteTitle"), 0);
            ModalDialogUtil.sleep();
            bl = false;
        }
        return bl;
    }

    public String getDisplayName() {
        return this._id;
    }

    public void help() {
        DSUtil.help("configuration-role-member-nested-help", this._observable.getConsoleInfo().getAdminURL());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._parent.setBusyCursor(true);
        if (actionEvent.getSource() == this._addButton) {
            this.actionAdd();
        } else if (actionEvent.getSource() == this._removeButton) {
            this.actionRemove();
        }
        this._parent.setBusyCursor(false);
    }

    void actionAdd() {
        Object object;
        String string;
        ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
        Vector vector = null;
        Vector vector2 = this._roleCache.getRoleDNs();
        String string2 = this._observable.getDN();
        if (string2 != null) {
            vector2.addElement(string2);
        }
        try {
            string = this._observable.isNewUser() ? this._observable.getCreateBaseDN() : RolePickerDialog.makeParentDn(this._observable.getDN());
            object = new RolePickerDialog(this._parent.getFrame(), consoleInfo);
            ((RolePickerDialog)object).loadWithNestableRoles(string, vector2.elements());
            ((RolePickerDialog)object).allowMultipleSelection(true);
            object.showModal();
            if (!object.isCancel()) {
                vector = ((RolePickerDialog)object).getSelectedRoles();
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ResEditorNestedRole.actionAdd: reading roles failed with " + (Object)((Object)lDAPException)));
            DSUtil.showLDAPErrorDialog(this._parent.getFrame(), lDAPException, "fetching-server-unavailable");
        }
        if (vector != null) {
            try {
                string = consoleInfo.getLDAPConnection();
                object = vector.elements();
                while (object.hasMoreElements()) {
                    String string3 = (String)object.nextElement();
                    DN dN = new DN(string3);
                    if (this._roleCache.contains(dN)) continue;
                    this._roleCache.add(string3, (LDAPConnection)string);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("RoleEditorDialog.actionAdd: reading roles failed with " + (Object)((Object)lDAPException)));
                DSUtil.showLDAPErrorDialog(this._parent.getFrame(), lDAPException, "updating-directory-title");
            }
        }
    }

    void actionRemove() {
        int n = this._table.getModel().getRowCount();
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        int n2 = 0;
        while (n2 < n) {
            if (listSelectionModel.isSelectedIndex(n2)) {
                this._roleCache.remove(n2);
            }
            ++n2;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 - n + 1 > 1 || this._table.getRowCount() <= 0) {
            this._table.setToolTipText(null);
        } else {
            this._table.setToolTipText(this._roleCache.getRoleDN(n));
        }
        this._removeButton.setEnabled(this._table.getSelectedRowCount() > 0 && this._table.getRowCount() > 0);
    }
}

