/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.ppoledit;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.ppoledit.PasswordPolicyEditorDialog;
import com.netscape.admin.dirserv.ppoledit.RoleAndCosAndPpolLinker;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class PasswordPolicyEditorDialogForRoles
extends PasswordPolicyEditorDialog {
    private RoleAndCosAndPpolLinker _linker;
    private String _oldPpolEntryDN = null;
    private LDAPEntry _oldCosTemplateEntry = null;
    private LDAPEntry _oldContainerEntry = null;
    private LDAPEntry _oldCosEntry = null;

    public PasswordPolicyEditorDialogForRoles(DSFramework dSFramework, ConsoleInfo consoleInfo) {
        super(dSFramework, consoleInfo);
    }

    protected void setAllTextPPolAssigned(boolean bl) {
        super.setAllTextPPolAssigned(bl);
        this._lInfoLabel.setText(PasswordPolicyEditorDialog._resource.getString("passwordPolicyEditorDialog", "roleImpact"));
        this._lInfoLabel.setColumns(50);
        this.pack();
    }

    protected void setAllTextPPolNotAssigned() {
        this._replaceButton.setText(PasswordPolicyEditorDialog._resource.getString("passwordPolicyEditorDialog", "assignButton-label"));
        this._lAssignedPpol.setText(PasswordPolicyEditorDialog._resource.getString("passwordPolicyEditorDialog", "noPPolAssigned-role"));
        this._lInfoLabel.setText("");
        this._lInfoLabel.setColumns(2);
        this._lWarningLabel.setText("");
        this._lWarningLabel.setIcon(null);
        this.pack();
    }

    protected void initialize() {
        String string = this._info.getCurrentDN();
        DN dN = new DN(string);
        DN dN2 = dN.getParent();
        String string2 = dN2.toString();
        this._linker = new RoleAndCosAndPpolLinker(this._info.getLDAPConnection(), string2, string);
        this._linker.initializeCosSchemaIfExists();
        Object var5_5 = null;
        if (this._linker.isSchemaExist()) {
            this._oldContainerEntry = this._linker.getContainerGuessed();
            this._oldCosTemplateEntry = this._linker.getCosTemplateGuessed();
            this._oldCosEntry = this._linker.getCosGuessed();
            LDAPEntry lDAPEntry = this._linker.getPpolGuessed();
            this._oldPpolEntryDN = this._linker.guessPPolDN();
        } else {
            Debug.println((int)0, (String)"PasswordPolicyEditorDialogForRole.initialize() : Status of the cos/role schema :\n   'Does not exist or is not complete'");
        }
        if (this._oldPpolEntryDN != null) {
            this._ppolIsAssigned = true;
            this._ppolEntryDN = this._oldPpolEntryDN;
            this.displayNewPPol(this._ppolEntryDN);
            this._roleGivingPPol = this.guessRoleGivenPPol();
            this.setAllTextPPolAssigned(this.ppolAssignedExist());
        } else {
            this._ppolIsAssigned = false;
            this._oldPpolEntryDN = "";
            this.setAllTextPPolNotAssigned();
        }
    }

    protected void okInvoked() {
        if (this._ppolIsAssigned) {
            if (this._oldPpolEntryDN != null && !this._oldPpolEntryDN.equals("")) {
                if (!this._oldPpolEntryDN.equals(this._ppolEntryDN)) {
                    try {
                        this._linker.updateCosTemplate(this._ppolEntryDN);
                        Debug.println((int)0, (String)("PasswordPolicyEditorDialogForRole.okinvoked: UPDATE CosTemplate, new ppol = " + this._ppolEntryDN));
                    }
                    catch (LDAPException lDAPException) {
                        int n = lDAPException.getLDAPResultCode();
                        Debug.println((String)("PasswordPolicyEditorDialogForRoles.okInvoked() - WARNING - PPol not saved properly : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
                    }
                }
            } else {
                try {
                    this._linker.createNewSchema(this._ppolEntryDN);
                    Debug.println((int)0, (String)"PasswordPolicyEditorDialogForRole.okinvoked: ppol assigned for the first time : COS/Role schema created");
                }
                catch (LDAPException lDAPException) {
                    int n = lDAPException.getLDAPResultCode();
                    Debug.println((String)("PasswordPolicyEditorDialogForRoles.okInvoked() - WARNING - PPol not saved properly : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
                }
            }
        } else if (this._oldPpolEntryDN != null && !this._oldPpolEntryDN.equals("")) {
            try {
                this._linker.removeSchema();
                Debug.println((int)0, (String)"PasswordPolicyEditorDialogForRole.okinvoked: no assigned ppol anymore : COS/Role schema removed");
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                Debug.println((String)("PasswordPolicyEditorDialogForRoles.okInvoked() - WARNING - PPol not saved properly : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
            }
        }
        ((Component)((Object)this)).setVisible(false);
    }
}

