/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.IReplicaPanel;
import com.netscape.admin.dirserv.config.replication.IReplicaWizard;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ReplicaChangelogPanel
extends JPanel
implements IReplicaPanel,
ActionListener,
DocumentListener {
    private IReplicaWizard _wizard;
    private JTextField _tfChangelogPath;
    private JButton _bBrowse;
    private String _defaultLocation;
    private static ResourceSet _resource = ReplicaWizard._resource;

    public ReplicaChangelogPanel(IReplicaWizard iReplicaWizard) {
        super(new GridBagLayout());
        this._wizard = iReplicaWizard;
        this.layoutComponents();
    }

    public String getChangelogPath() {
        return this._tfChangelogPath.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bBrowse) {
            String string;
            String string2 = this._tfChangelogPath.getText().trim();
            if (string2.length() == 0) {
                if (DSFileDialog.getDefaultDirectory() == null) {
                    DSFileDialog.setDefaultDirectory(this._defaultLocation);
                }
            } else {
                DSFileDialog.setDefaultDirectory(string2);
            }
            if ((string = DSFileDialog.browseDirectories(true, this._bBrowse)) != null) {
                this._tfChangelogPath.setText(string);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl = this._tfChangelogPath.getText().trim().length() > 0;
        this._wizard.setEnabledNextButton(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void helpInvoked() {
        DSUtil.help("configuration-replication-replicawizard-changelog-dbox-help", ReplicaWizard._adminURL);
    }

    public void reset() {
        this.insertUpdate(null);
        this._tfChangelogPath.grabFocus();
    }

    private void layoutComponents() {
        String string = (String)this._wizard.getFramework().getServerObject().getServerInfo().get("InstallPath");
        String string2 = (String)this._wizard.getFramework().getServerObject().getServerInfo().get("ServerInstance");
        this._defaultLocation = string + '/' + string2 + "/changelogdb";
        this._tfChangelogPath = UIFactory.makeJTextField(this, "replicachangelogpanel", "lchangelogpath", this._defaultLocation, 20, _resource);
        this._bBrowse = UIFactory.makeJButton(this, "replicachangelogpanel", "bbrowse", _resource);
        boolean bl = DSUtil.isLocal(this._wizard.getFramework().getServerObject().getServerInfo().getHost());
        this._bBrowse.setEnabled(bl);
        JLabel jLabel = UIFactory.makeJLabel("replicachangelogpanel", "lchangelogpath", _resource);
        jLabel.setLabelFor(this._tfChangelogPath);
        JLabel jLabel2 = UIFactory.makeJLabel("replicachangelogpanel", "ldescription", _resource);
        JTextArea jTextArea = UIFactory.makeDescriptionArea(_resource.getString("replicachangelogpanel", "description-label"), 9);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, UIFactory.getComponentSpace(), 0);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.bottom = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = 0;
        this.add((Component)this._tfChangelogPath, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

