/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.replication.AgreementCellRenderer;
import com.netscape.admin.dirserv.config.replication.PartialAttributeElementDialog;
import com.netscape.admin.dirserv.config.replication.PartialReplication;
import com.netscape.admin.dirserv.config.replication.PartialRule;
import com.netscape.admin.dirserv.config.replication.PartialSubRule;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.config.replication.RuleCellRenderer;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class PartialReplicationRuleManager
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    private DSFramework _framework;
    private JLabel _lRules;
    private JList _listRules;
    private JButton _bAddRule;
    private JButton _bDeleteRule;
    private JButton _bEditRule;
    private JLabel _lUsedIn;
    private JList _listUsedIn;
    private static final ResourceSet _resource = ReplicaWizard._resource;
    private static final String HELP_TOKEN = "configuration-data-replication-attributes-dbox-help";

    public PartialReplicationRuleManager(DSFramework dSFramework) {
        super((Frame)((Object)dSFramework), _resource.getString("partialreplicationrulemanager", "title"), true, 12);
        this._framework = dSFramework;
        this.setComponent(this.createContentPanel());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bEditRule) {
            this.actionEditRule();
        } else if (object == this._bAddRule) {
            this.actionAddRule();
        } else if (object == this._bDeleteRule) {
            this.actionDeleteRule();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this._listRules) {
            DefaultListModel defaultListModel = (DefaultListModel)this._listUsedIn.getModel();
            defaultListModel.clear();
            Object[] objectArray = this._listRules.getSelectedValues();
            if (objectArray != null && objectArray.length > 0) {
                boolean bl = objectArray.length == 1;
                this._bEditRule.setEnabled(bl);
                this._bDeleteRule.setEnabled(true);
                if (bl) {
                    PartialRule partialRule = (PartialRule)objectArray[0];
                    List list = partialRule.getAgreementList();
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        defaultListModel.addElement(listIterator.next());
                    }
                }
            } else {
                this._bEditRule.setEnabled(false);
                this._bDeleteRule.setEnabled(false);
            }
        }
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._lRules = UIFactory.makeJLabel("partialreplicationrulemanager", "lrules", _resource);
        PartialReplication partialReplication = this._framework.getServerObject().getPartialReplication();
        Enumeration enumeration = partialReplication.getRules();
        DefaultListModel defaultListModel = new DefaultListModel();
        while (enumeration.hasMoreElements()) {
            defaultListModel.addElement(enumeration.nextElement());
        }
        this._listRules = new JList(defaultListModel);
        this._listRules.addListSelectionListener(this);
        this._listRules.setCellRenderer(new RuleCellRenderer(partialReplication));
        PartialRule partialRule = new PartialRule();
        partialRule.name = "12345";
        partialRule.description = "123456789012345678901234567890";
        this._listRules.setPrototypeCellValue(partialRule);
        this._listRules.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object[] objectArray;
                if (mouseEvent.getClickCount() == 2 && (objectArray = PartialReplicationRuleManager.this._listRules.getSelectedValues()) != null && objectArray.length == 1) {
                    PartialReplicationRuleManager.this.actionEditRule();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._listRules);
        this._lRules.setLabelFor(this._listRules);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this._bAddRule = UIFactory.makeJButton(this, "partialreplicationrulemanager", "baddrule", _resource);
        this._bEditRule = UIFactory.makeJButton(this, "partialreplicationrulemanager", "beditrule", _resource);
        this._bDeleteRule = UIFactory.makeJButton(this, "partialreplicationrulemanager", "bdeleterule", _resource);
        this._bEditRule.setEnabled(false);
        this._bDeleteRule.setEnabled(false);
        this._lUsedIn = UIFactory.makeJLabel("partialreplicationrulemanager", "lusedin", _resource);
        this._listUsedIn = new JList(new DefaultListModel());
        this._listUsedIn.setCellRenderer(new AgreementCellRenderer());
        this._listUsedIn.setVisibleRowCount(3);
        this._listUsedIn.setBackground(jPanel.getBackground());
        this._listUsedIn.setSelectionBackground(jPanel.getBackground());
        JScrollPane jScrollPane2 = new JScrollPane(this._listUsedIn);
        jScrollPane2.setBorder(UITools.createLoweredBorder());
        this._lUsedIn.setLabelFor(this._listUsedIn);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this._bAddRule, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._bEditRule, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)this._bDeleteRule, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.top = 0;
        jPanel.add((Component)this._lRules, gridBagConstraints);
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.gridwidth = -1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 2 * UIFactory.getComponentSpace();
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this._lUsedIn, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 0.3;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        return jPanel;
    }

    private void actionEditRule() {
        PartialReplication partialReplication = this._framework.getServerObject().getPartialReplication();
        PartialRule partialRule = (PartialRule)this._listRules.getSelectedValue();
        int n = this._listRules.getSelectedIndex();
        PartialAttributeElementDialog partialAttributeElementDialog = new PartialAttributeElementDialog(this._framework, partialRule);
        partialAttributeElementDialog.pack();
        partialAttributeElementDialog.show();
        PartialRule partialRule2 = partialAttributeElementDialog.getPartialRule();
        if (partialRule2 != null) {
            ((DefaultListModel)this._listRules.getModel()).set(n, partialRule2);
            this._listRules.setSelectedValue(partialRule2, true);
        }
    }

    private void actionAddRule() {
        PartialAttributeElementDialog partialAttributeElementDialog = new PartialAttributeElementDialog(this._framework);
        partialAttributeElementDialog.pack();
        partialAttributeElementDialog.show();
        PartialRule partialRule = partialAttributeElementDialog.getPartialRule();
        if (partialRule != null) {
            ((DefaultListModel)this._listRules.getModel()).addElement(partialRule);
            this._listRules.setSelectedValue(partialRule, true);
        }
    }

    private void actionDeleteRule() {
        int n = DSUtil.showConfirmationDialog((Component)((Object)this), "deleterule-confirmation", (String[])null, "partialreplicationrulemanager", _resource);
        if (n == 0) {
            final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("partialreplicationrulemanager", "deleting-title"), (Component)((Object)this));
            genericProgressDialog.setTextInLabel(_resource.getString("partialreplicationrulemanager", "deleting-msg"));
            genericProgressDialog.setLabelRows(1);
            genericProgressDialog.setLabelColumns(30);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PartialReplication partialReplication = PartialReplicationRuleManager.this._framework.getServerObject().getPartialReplication();
                    LDAPConnection lDAPConnection = PartialReplicationRuleManager.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    Object[] objectArray = PartialReplicationRuleManager.this._listRules.getSelectedValues();
                    boolean bl = false;
                    int n = 0;
                    while (n < objectArray.length && !bl) {
                        Object object;
                        PartialRule partialRule = (PartialRule)objectArray[n];
                        String string = partialRule.name;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ListIterator listIterator = partialRule.getSubRuleList().listIterator();
                        while (listIterator.hasNext()) {
                            object = (PartialSubRule)listIterator.next();
                            if (((PartialSubRule)object).attributeElementName != "any") {
                                arrayList.add(((PartialSubRule)object).attributeElementName);
                            }
                            if (((PartialSubRule)object).subtreeElementName != "any") {
                                arrayList.add(((PartialSubRule)object).subtreeElementName);
                            }
                            if (((PartialSubRule)object).sparseElementName == "any") continue;
                            arrayList.add(((PartialSubRule)object).sparseElementName);
                        }
                        try {
                            block13: {
                                try {
                                    lDAPConnection.delete("cn=" + string + ", cn=sets, cn=filtering service, cn=features, cn=config");
                                }
                                catch (LDAPException lDAPException) {
                                    if (lDAPException.getLDAPResultCode() == 32) break block13;
                                    throw lDAPException;
                                }
                            }
                            partialReplication.notifyRuleDeleted(string);
                            listIterator = arrayList.listIterator();
                            while (listIterator.hasNext()) {
                                block14: {
                                    object = (String)listIterator.next();
                                    try {
                                        lDAPConnection.delete("cn=" + (String)object + ", cn=elements, cn=filtering service, cn=features, cn=config");
                                    }
                                    catch (LDAPException lDAPException) {
                                        if (lDAPException.getLDAPResultCode() == 32) break block14;
                                        throw lDAPException;
                                    }
                                }
                                partialReplication.notifyElementDeleted((String)object);
                            }
                        }
                        catch (LDAPException lDAPException) {
                            bl = true;
                            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                            SwingUtilities.invokeLater(new Runnable(this, stringArray){
                                private final /* synthetic */ String[] val$arg;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$arg = stringArray;
                                }

                                public void run() {
                                    DSUtil.showErrorDialog((Component)((Object)2.access$300(this.this$1)), "error-deleting-title", "error-deleting-msg", this.val$arg, "partialreplicationrulemanager", PartialReplicationRuleManager.access$400());
                                }
                            });
                        }
                        ++n;
                    }
                    genericProgressDialog.closeCallBack();
                }

                static /* synthetic */ PartialReplicationRuleManager access$300(2 var0) {
                    return var0.PartialReplicationRuleManager.this;
                }
            });
            thread.start();
            genericProgressDialog.packAndShow();
            DefaultListModel defaultListModel = (DefaultListModel)this._listRules.getModel();
            defaultListModel.clear();
            PartialReplication partialReplication = this._framework.getServerObject().getPartialReplication();
            Enumeration enumeration = partialReplication.getRules();
            while (enumeration.hasMoreElements()) {
                defaultListModel.addElement(enumeration.nextElement());
            }
        }
    }

    static /* synthetic */ ResourceSet access$400() {
        return _resource;
    }
}

