/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.config.replication.AgreementAuthenticationTypeDialog;
import com.netscape.admin.dirserv.config.replication.AvailableServerListModel;
import com.netscape.admin.dirserv.config.replication.AvailableServers;
import com.netscape.admin.dirserv.config.replication.AvailableServersCellRenderer;
import com.netscape.admin.dirserv.config.replication.BasicServer;
import com.netscape.admin.dirserv.config.replication.NewAgreementDialog;
import com.netscape.admin.dirserv.config.replication.RemoteReplicaDialog;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.components.SwingWorker;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class NewAgreementDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private JPanel _contentPanel;
    private JPanel _replicaPanel;
    private ReplicationAgreement[] _existingAgreements;
    private JPanel _authenticationPanel;
    private JComboBox _comboReplica;
    private JLabel _lAuthentication;
    private JButton _bChangeAuthentication;
    private JButton _bChangeReplica;
    private JPanel _simpleAuthenticationPanel;
    private JTextField _tfBindDn;
    private JPasswordField _pfBindPwd;
    private JTextField _tfDescription;
    private boolean _serverValid = false;
    private boolean _dnValid = true;
    private boolean _pwdValid = false;
    private boolean _isInitialized;
    private boolean _isCreated;
    private boolean _isLocal;
    private boolean _ignoreComboEvents;
    private AvailableServerListModel _listModel;
    private ReplicationAgreement _agreement;
    private Suffix _suffix;
    private String _helpToken = "configuration-replication-new-agreement-dbox-help";
    private static final ResourceSet _resource = ReplicaWizard._resource;
    private final JLabel REFRESH_LABEL = new JLabel(_resource.getString("newagreementdialog-reading", "label"));

    public NewAgreementDialog(DSFramework dSFramework, Suffix suffix, ReplicationAgreement[] replicationAgreementArray) {
        super((Frame)((Object)dSFramework), _resource.getString("newagreementdialog", "title"), true, 11);
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("newagreementdialog", "description"));
        this._framework = dSFramework;
        this._suffix = suffix;
        this._existingAgreements = replicationAgreementArray;
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        this._contentPanel = new JPanel(new GridBagLayout());
        this.setComponent(this._contentPanel);
        this._agreement = new ReplicationAgreement();
        this.layoutReplicaPane();
        this.checkOKButton();
        this.showComponent(this._replicaPanel);
    }

    public boolean isCreated() {
        return this._isCreated;
    }

    public void show() {
        this.showComponent(this.REFRESH_LABEL);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                LDAPConnection lDAPConnection = NewAgreementDialog.this._framework.getServerObject().getConsoleInfo().getLDAPConnection();
                AvailableServers availableServers = new AvailableServers();
                try {
                    availableServers.findServers(lDAPConnection);
                    String string = NewAgreementDialog.this._framework.getServerObject().getServerInfo().getHost();
                    int n = NewAgreementDialog.this._framework.getServerObject().getServerInfo().getPort();
                    boolean bl = false;
                    Enumeration enumeration = availableServers.elements();
                    int n2 = 0;
                    while (enumeration.hasMoreElements() && !bl) {
                        BasicServer basicServer = (BasicServer)enumeration.nextElement();
                        if (basicServer.port == n && basicServer.name.equals(string)) {
                            bl = true;
                            if (basicServer.isSecurePort) {
                                availableServers.removeElementAt(n2);
                                availableServers.removeElementAt(n2 - 1);
                            } else {
                                availableServers.removeElementAt(n2 + 1);
                                availableServers.removeElementAt(n2);
                            }
                        }
                        ++n2;
                    }
                    int n3 = availableServers.size() - 1;
                    while (n3 >= 0) {
                        BasicServer basicServer = (BasicServer)availableServers.elementAt(n3);
                        if (!basicServer.isEnabled) {
                            availableServers.removeElementAt(n3);
                        }
                        --n3;
                    }
                    int n4 = 0;
                    while (n4 < NewAgreementDialog.this._existingAgreements.length) {
                        string = ((NewAgreementDialog)NewAgreementDialog.this)._existingAgreements[n4].host;
                        n = ((NewAgreementDialog)NewAgreementDialog.this)._existingAgreements[n4].port;
                        bl = false;
                        int n5 = availableServers.size() - 1;
                        while (n5 >= 0) {
                            BasicServer basicServer = (BasicServer)availableServers.elementAt(n5);
                            if (basicServer.port == n && basicServer.name.equals(string)) {
                                bl = true;
                                availableServers.removeElementAt(n5);
                            }
                            --n5;
                        }
                        ++n4;
                    }
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(this, availableServers){
                    private final /* synthetic */ AvailableServers val$avServers;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$avServers = availableServers;
                    }

                    public void run() {
                        NewAgreementDialog.access$302(1.access$200(this.this$1), new AvailableServerListModel());
                        Enumeration<E> enumeration = this.val$avServers.elements();
                        while (enumeration.hasMoreElements()) {
                            NewAgreementDialog.access$300(1.access$200(this.this$1)).addElement((Object)enumeration.nextElement());
                        }
                        if (NewAgreementDialog.access$300(1.access$200(this.this$1)).getServerNumber() == 0) {
                            NewAgreementDialog.access$300(1.access$200(this.this$1)).addElement(AvailableServerListModel.CONSUMER_LIST_NOT_AVAILABLE);
                        }
                        NewAgreementDialog.access$400(1.access$200(this.this$1)).setModel(NewAgreementDialog.access$300(1.access$200(this.this$1)));
                        NewAgreementDialog.access$400(1.access$200(this.this$1)).setSelectedIndex(0);
                        NewAgreementDialog.access$600(1.access$200(this.this$1), NewAgreementDialog.access$500(1.access$200(this.this$1)));
                        1.access$200(this.this$1).pack();
                    }
                });
                NewAgreementDialog.this._isInitialized = true;
            }

            static /* synthetic */ NewAgreementDialog access$200(1 var0) {
                return var0.NewAgreementDialog.this;
            }
        });
        thread.start();
        super.show();
    }

    public static boolean testAuthentication(JFrame jFrame, String string, String string2, String string3, String string4, boolean bl) {
        boolean[] blArray = new boolean[]{true};
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(jFrame, true, 1, _resource.getString("newagreementdialog", "testingconnection-title"));
        genericProgressDialog.setTextInLabel(_resource.getString("newagreementdialog", "testingconnection-msg"));
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setLabelColumns(25);
        class MySwingWorker
        extends SwingWorker {
            boolean _errorHappened;
            boolean _connected;
            boolean _authenticated;
            boolean _timeOutHappened;
            boolean _doModification;
            final int TIME_LIMIT = 5;
            private final /* synthetic */ String val$host;
            private final /* synthetic */ String val$port;
            private final /* synthetic */ String val$bindDn;
            private final /* synthetic */ String val$bindPwd;
            private final /* synthetic */ JFrame val$frame;
            private final /* synthetic */ boolean val$isLocal;
            private final /* synthetic */ GenericProgressDialog val$dlg;

            MySwingWorker(String string, String string2, String string3, String string4, JFrame jFrame, boolean bl, GenericProgressDialog genericProgressDialog) {
                this.val$host = string;
                this.val$port = string2;
                this.val$bindDn = string3;
                this.val$bindPwd = string4;
                this.val$frame = jFrame;
                this.val$isLocal = bl;
                this.val$dlg = genericProgressDialog;
                this._errorHappened = false;
                this._connected = false;
                this._authenticated = false;
                this._timeOutHappened = false;
                this._doModification = true;
                this.TIME_LIMIT = 5;
            }

            public Object construct() {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LDAPConnection lDAPConnection = DSUtil.makeLDAPConnection(false);
                try {
                    if (lDAPConnection == null) {
                        throw new LDAPException("Could not create connection");
                    }
                    lDAPConnection.setConnectTimeout(5);
                    lDAPConnection.connect(this.val$host, Integer.parseInt(this.val$port));
                    LDAPConstraints lDAPConstraints = lDAPConnection.getConstraints();
                    lDAPConstraints.setTimeLimit(5000);
                    lDAPConnection.setConstraints(lDAPConstraints);
                    this._connected = true;
                    lDAPConnection.authenticate(3, this.val$bindDn, this.val$bindPwd);
                    this._authenticated = true;
                }
                catch (LDAPException lDAPException) {
                    this._errorHappened = true;
                    this._timeOutHappened = lDAPException.getLDAPResultCode() == 3 || lDAPException.getLDAPResultCode() == 85;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this._connected) {
                    try {
                        lDAPConnection.disconnect();
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                }
                return null;
            }

            public void finished() {
                if (this._errorHappened) {
                    int n;
                    int n2;
                    String[] stringArray;
                    int n3;
                    int n4;
                    int n5;
                    String[] stringArray2;
                    int n6;
                    this._doModification = !this._connected ? (this._timeOutHappened ? (n6 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotconnect-timeout", stringArray2 = new String[]{String.valueOf(5)}, "newagreementdialog", NewAgreementDialog.access$800())) == 0 : (this.val$isLocal ? (n5 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotconnect", (String[])null, "newagreementdialog", NewAgreementDialog.access$800())) == 0 : (n4 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotconnect-notlocal", (String[])null, "newagreementdialog", NewAgreementDialog.access$800())) == 0)) : (this._timeOutHappened ? (n3 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotbind-timeout", stringArray = new String[]{String.valueOf(5)}, "newagreementdialog", NewAgreementDialog.access$800())) == 0 : (this.val$isLocal ? (n2 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotbind", (String[])null, "newagreementdialog", NewAgreementDialog.access$800())) == 0 : (n = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotbind-notlocal", (String[])null, "newagreementdialog", NewAgreementDialog.access$800())) == 0));
                    this.val$dlg.closeCallBack();
                } else {
                    this.val$dlg.closeCallBack();
                    if (this._authenticated && this.val$isLocal) {
                        DSUtil.showInformationDialog(this.val$frame, "warning-checkreliability", null, "newagreementdialog", NewAgreementDialog.access$800());
                    }
                }
            }

            public boolean doModification() {
                return this._doModification;
            }
        }
        MySwingWorker mySwingWorker = new MySwingWorker(string3, string4, string, string2, jFrame, bl, genericProgressDialog);
        mySwingWorker.start();
        genericProgressDialog.packAndShow();
        return mySwingWorker.doModification();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bChangeReplica) {
            this.actionChangeReplica();
        } else if (object == this._bChangeAuthentication) {
            this.actionChangeAuthentication();
        } else if (object == this._comboReplica && !this._ignoreComboEvents) {
            this.actionComboReplica();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this._tfBindDn.getDocument()) {
            this._dnValid = !this._tfBindDn.getText().equals("") && DN.isDN((String)this._tfBindDn.getText());
            this.checkOKButton();
        } else if (document == this._pfBindPwd.getDocument()) {
            this._pwdValid = this._pfBindPwd.getPassword().length > 0;
            this.checkOKButton();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void okInvoked() {
        if (this._isInitialized) {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsDS5ReplicationAgreement"));
            BasicServer basicServer = (BasicServer)this._comboReplica.getSelectedItem();
            String string = basicServer.name;
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaHost", string));
            String string2 = String.valueOf(basicServer.port);
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaPort", string2));
            if (basicServer.isSecurePort) {
                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaTransportInfo", "SSL"));
            }
            if (this._agreement.authentication == 0) {
                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindMethod", "SIMPLE"));
                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindDN", this._tfBindDn.getText()));
                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaCredentials", String.valueOf(this._pfBindPwd.getPassword())));
            } else {
                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindMethod", "SSLCLIENTAUTH"));
            }
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaUpdateSchedule", "*"));
            String string3 = this._tfDescription.getText();
            if (!string3.equals("")) {
                lDAPAttributeSet.add(new LDAPAttribute("description", string3));
            }
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaRoot", this._suffix.getName()));
            String string4 = string + ":" + string2;
            LDAPEntry lDAPEntry = new LDAPEntry("cn=" + string4 + ", cn=replica, " + this._suffix.getDn(), lDAPAttributeSet);
            boolean bl = true;
            if (!basicServer.isSecurePort) {
                boolean bl2;
                int n = DSUtil.showConfirmationDialog((Component)((Object)this), "confirmation-testconnection", (String[])null, "newagreementdialog", _resource);
                boolean bl3 = bl2 = n == 0;
                if (bl2) {
                    String string5 = this._tfBindDn.getText();
                    String string6 = String.valueOf(this._pfBindPwd.getPassword());
                    bl = NewAgreementDialog.testAuthentication((JFrame)((Object)this._framework), string5, string6, string, string2, this._isLocal);
                }
            } else {
                DSUtil.showInformationDialog((Component)((Object)this), "testconnection-impossible", null, "newagreementdialog", _resource);
            }
            if (bl) {
                try {
                    LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    lDAPConnection.add(lDAPEntry);
                    this._isCreated = true;
                    super.okInvoked();
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    DSUtil.showErrorDialog((Component)((Object)this._framework), "error-creatingagreement-title", "error-creatingagreement-msg", stringArray, "newagreementdialog", _resource);
                }
            }
        } else {
            super.okInvoked();
        }
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void layoutReplicaPane() {
        this._replicaPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("newagreementdialog", "lhostport", _resource);
        this._comboReplica = new JComboBox();
        this._comboReplica.addActionListener(this);
        this._comboReplica.setRenderer(new AvailableServersCellRenderer());
        jLabel.setLabelFor(this._comboReplica);
        this._bChangeReplica = UIFactory.makeJButton(this, "newagreementdialog", "bchangereplica", _resource);
        this._lAuthentication = UIFactory.makeJLabel("newagreementdialog", "simpleauthentication", _resource);
        this._agreement.authentication = 0;
        GroupPanel groupPanel = new GroupPanel(_resource.getString("newagreementdialog", "authenticationpanel-title"));
        this._bChangeAuthentication = UIFactory.makeJButton(this, "newagreementdialog", "bchangeauthentication", _resource);
        this._simpleAuthenticationPanel = new JPanel(new GridBagLayout());
        JLabel jLabel2 = UIFactory.makeJLabel("newagreementdialog", "lbinddn", _resource);
        this._tfBindDn = UIFactory.makeJTextField(this, "newagreementdialog", "lbinddn", "cn=replication manager, cn=replication, cn=config", 30, _resource);
        jLabel2.setLabelFor(this._tfBindDn);
        JLabel jLabel3 = UIFactory.makeJLabel("newagreementdialog", "lbindpwd", _resource);
        this._pfBindPwd = UIFactory.makeJPasswordField(this, "newagreementdialog", "lbindpwd", null, 30, _resource);
        jLabel3.setLabelFor(this._pfBindPwd);
        JLabel jLabel4 = UIFactory.makeJLabel("newagreementdialog", "ldescription", _resource);
        this._tfDescription = UIFactory.makeJTextField(null, "newagreementdialog", "ldescription", null, 30, _resource);
        jLabel4.setLabelFor(this._tfDescription);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.left = 2;
        this._replicaPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._replicaPanel.add((Component)this._comboReplica, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 2;
        this._replicaPanel.add((Component)this._bChangeReplica, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._tfDescription, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        this._replicaPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        this._replicaPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = 0;
        groupPanel.add((Component)this._lAuthentication, gridBagConstraints);
        this._lAuthentication.setLabelFor(groupPanel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._bChangeAuthentication, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        this._authenticationPanel = new JPanel(new BorderLayout());
        groupPanel.add((Component)this._authenticationPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this._authenticationPanel.add("Center", this._simpleAuthenticationPanel);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this._simpleAuthenticationPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._simpleAuthenticationPanel.add((Component)this._tfBindDn, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        this._simpleAuthenticationPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._simpleAuthenticationPanel.add((Component)this._pfBindPwd, gridBagConstraints);
    }

    private void showComponent(JComponent jComponent) {
        this._contentPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof JLabel) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this._contentPanel.add((Component)jComponent, gridBagConstraints);
        this._contentPanel.revalidate();
        this._contentPanel.repaint();
    }

    private void actionChangeAuthentication() {
        AgreementAuthenticationTypeDialog agreementAuthenticationTypeDialog = new AgreementAuthenticationTypeDialog((JFrame)((Object)this._framework), this._agreement);
        agreementAuthenticationTypeDialog.pack();
        agreementAuthenticationTypeDialog.show();
        if (!agreementAuthenticationTypeDialog.isCancelled()) {
            this._agreement.authentication = agreementAuthenticationTypeDialog.getAuthentication();
            if (this._agreement.authentication == 0) {
                this._lAuthentication.setText(_resource.getString("newagreementdialog", "simpleauthentication-label"));
            } else if (this._agreement.authentication == 2) {
                this._lAuthentication.setText(_resource.getString("newagreementdialog", "starttls-label"));
            } else {
                this._lAuthentication.setText(_resource.getString("newagreementdialog", "certificateauthentication-label"));
            }
            if (!this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel) && this._agreement.authentication != 1) {
                this._authenticationPanel.add("Center", this._simpleAuthenticationPanel);
                this._dnValid = !this._tfBindDn.getText().equals("") && DN.isDN((String)this._tfBindDn.getText());
                this.checkOKButton();
                this._contentPanel.revalidate();
                this._contentPanel.repaint();
            } else if (this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel) && this._agreement.authentication == 1) {
                this._authenticationPanel.remove(this._simpleAuthenticationPanel);
                this._dnValid = true;
                this.checkOKButton();
                this._contentPanel.revalidate();
                this._contentPanel.repaint();
            }
        }
    }

    private void actionChangeReplica() {
        RemoteReplicaDialog remoteReplicaDialog = new RemoteReplicaDialog((JFrame)((Object)this._framework));
        remoteReplicaDialog.pack();
        remoteReplicaDialog.show();
        if (!remoteReplicaDialog.isCancelled()) {
            BasicServer basicServer = new BasicServer();
            basicServer.name = remoteReplicaDialog.getHost();
            basicServer.port = remoteReplicaDialog.getPort();
            basicServer.isSecurePort = remoteReplicaDialog.isSSL();
            this._ignoreComboEvents = true;
            this._listModel.addElement(basicServer);
            this._ignoreComboEvents = false;
            this._comboReplica.setSelectedIndex(this._listModel.getSize() - 1);
            this._comboReplica.revalidate();
            this._comboReplica.repaint();
        }
    }

    private void actionComboReplica() {
        boolean bl;
        boolean bl2 = bl = this._comboReplica.getSelectedItem() == AvailableServerListModel.CONSUMER_LIST_NOT_AVAILABLE;
        if (!bl) {
            BasicServer basicServer = (BasicServer)this._comboReplica.getSelectedItem();
            this._agreement.isSSL = basicServer.isSecurePort;
        } else {
            this._agreement.isSSL = false;
        }
        this._bChangeAuthentication.setEnabled(this._agreement.isSSL);
        if (!this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel) && !this._agreement.isSSL) {
            this._authenticationPanel.add("Center", this._simpleAuthenticationPanel);
            this._contentPanel.revalidate();
            this._contentPanel.repaint();
        } else if (this._agreement.isSSL && this._lAuthentication.getText().equals(_resource.getString("agreementdialog", "starttls-label"))) {
            this._lAuthentication.setText(_resource.getString("agreementdialog", "simpleauthentication-label"));
        }
        this._serverValid = !bl;
        this.checkOKButton();
    }

    private void checkOKButton() {
        boolean bl;
        boolean bl2 = bl = this._serverValid && this._dnValid;
        if (bl && this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel)) {
            bl = this._pwdValid;
        }
        this.setOKButtonEnabled(bl);
    }

    static /* synthetic */ AvailableServerListModel access$302(NewAgreementDialog newAgreementDialog, AvailableServerListModel availableServerListModel) {
        newAgreementDialog._listModel = availableServerListModel;
        return newAgreementDialog._listModel;
    }

    static /* synthetic */ AvailableServerListModel access$300(NewAgreementDialog newAgreementDialog) {
        return newAgreementDialog._listModel;
    }

    static /* synthetic */ JComboBox access$400(NewAgreementDialog newAgreementDialog) {
        return newAgreementDialog._comboReplica;
    }

    static /* synthetic */ JPanel access$500(NewAgreementDialog newAgreementDialog) {
        return newAgreementDialog._replicaPanel;
    }

    static /* synthetic */ void access$600(NewAgreementDialog newAgreementDialog, JComponent jComponent) {
        newAgreementDialog.showComponent(jComponent);
    }

    static /* synthetic */ ResourceSet access$800() {
        return _resource;
    }
}

