/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.AgreementAuthenticationTypeDialog;
import com.netscape.admin.dirserv.config.replication.NewAgreementDialog;
import com.netscape.admin.dirserv.config.replication.PartialAttributeElementDialog;
import com.netscape.admin.dirserv.config.replication.PartialReplication;
import com.netscape.admin.dirserv.config.replication.PartialReplicationRuleManager;
import com.netscape.admin.dirserv.config.replication.PartialRule;
import com.netscape.admin.dirserv.config.replication.RemoteReplicaDialog;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.config.replication.RuleCellRenderer;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.util.DN;

public class EditAgreementDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private JTabbedPane _tabbedPanel;
    private JTextField _tfDescription;
    private JLabel _lHostPort;
    private JButton _bChangePort;
    private JLabel _lAuthentication;
    private JButton _bChangeAuthentication;
    private JPanel _simpleAuthenticationPanel;
    private JTextField _tfBindDn;
    private JPasswordField _pfBindPwd;
    private JCheckBox[] _cbDays;
    private JButton _bAll;
    private JRadioButton _rbAlwaysSync;
    private JRadioButton _rbSyncIn;
    private JTextField _tfBeginHour;
    private JTextField _tfBeginMinute;
    private JTextField _tfEndHour;
    private JTextField _tfEndMinute;
    private JCheckBox _cbUsePartial;
    private JComboBox _comboRules;
    private JButton _bAddSet;
    private JButton _bManageSets;
    private JTextField _tfWindowSize;
    private JTextField _tfGroupSize;
    private boolean _daysValid = true;
    private boolean _timeValid = true;
    private boolean _dnValid = true;
    private boolean _pwdValid = true;
    private boolean _partialValid = true;
    private boolean _windowSizeValid = true;
    private boolean _groupSizeValid = true;
    private boolean _isModified;
    private boolean _isInitialized;
    private boolean _isLocal;
    private ReplicationAgreement _agreement;
    private ReplicationAgreement _saveAgreement;
    private JPanel _authenticationPanel;
    private static final int WINDOW_SIZE_MIN_VALUE = 1;
    private static final int WINDOW_SIZE_MAX_VALUE = 1000;
    private static final int GROUP_SIZE_MIN_VALUE = 1;
    private static final int GROUP_SIZE_MAX_VALUE = 100;
    private static final ResourceSet _resource = ReplicaWizard._resource;

    public EditAgreementDialog(DSFramework dSFramework, ReplicationAgreement replicationAgreement) {
        super((Frame)((Object)dSFramework), _resource.getString("editagreementdialog", "title"), true, 11);
        this._framework = dSFramework;
        this._saveAgreement = replicationAgreement;
        this._agreement = (ReplicationAgreement)replicationAgreement.clone();
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        this.layoutContentPane();
        this._isInitialized = true;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void pack() {
        int n = this._tabbedPanel.getSelectedIndex();
        this._tabbedPanel.setSelectedIndex(1);
        super.pack();
        this._tabbedPanel.setSelectedIndex(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bAll) {
            this._daysValid = true;
            int n = 0;
            while (n < this._cbDays.length) {
                this._cbDays[n].setSelected(true);
                ++n;
            }
            this.checkOKButton();
        } else if (object == this._rbAlwaysSync || object == this._rbSyncIn) {
            boolean bl = this._rbSyncIn.isSelected();
            int n = 0;
            while (n < this._cbDays.length) {
                this._cbDays[n].setEnabled(bl);
                ++n;
            }
            this._tfBeginHour.setEnabled(bl);
            this._tfBeginMinute.setEnabled(bl);
            this._tfEndHour.setEnabled(bl);
            this._tfEndMinute.setEnabled(bl);
            this._bAll.setEnabled(bl);
            if (bl) {
                this.checkScheduleTime();
            }
            this.checkOKButton();
        } else if (object == this._cbUsePartial) {
            boolean bl = this._cbUsePartial.isSelected();
            this._partialValid = !bl || this._comboRules.getSelectedItem() != RuleCellRenderer.NO_RULE_AVAILABLE;
            this._bAddSet.setEnabled(bl);
            this._bManageSets.setEnabled(bl);
            this._comboRules.setEnabled(bl);
            this.checkOKButton();
        } else if (object instanceof JCheckBox) {
            this._daysValid = false;
            int n = 0;
            while (n < this._cbDays.length && !this._daysValid) {
                this._daysValid = this._cbDays[n].isSelected();
                ++n;
            }
            this.checkOKButton();
        } else if (object == this._bChangePort) {
            this.actionChangePort();
        } else if (object == this._bChangeAuthentication) {
            this.actionChangeAuthentication();
        } else if (object == this._comboRules) {
            this._partialValid = this._comboRules.getSelectedItem() != RuleCellRenderer.NO_RULE_AVAILABLE;
            this.checkOKButton();
        } else if (object == this._bManageSets) {
            this.actionManageSets();
        } else if (object == this._bAddSet) {
            this.actionAddSet();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this._isInitialized) {
            Document document = documentEvent.getDocument();
            if (document == this._tfBindDn.getDocument()) {
                this._dnValid = !this._tfBindDn.getText().equals("") && DN.isDN((String)this._tfBindDn.getText());
                ((JTextComponent)this._pfBindPwd).setText("");
                this.checkOKButton();
            } else if (document == this._pfBindPwd.getDocument()) {
                this._pwdValid = this._pfBindPwd.getPassword().length > 0;
                this.checkOKButton();
            } else if (document == this._tfBeginHour.getDocument()) {
                this.checkScheduleTime();
                this.checkOKButton();
            } else if (document == this._tfBeginMinute.getDocument()) {
                this.checkScheduleTime();
                this.checkOKButton();
            } else if (document == this._tfEndHour.getDocument()) {
                this.checkScheduleTime();
                this.checkOKButton();
            } else if (document == this._tfEndMinute.getDocument()) {
                this.checkScheduleTime();
                this.checkOKButton();
            } else if (document == this._tfWindowSize.getDocument()) {
                this.checkWindowGroupSize();
                this.checkOKButton();
            } else if (document == this._tfGroupSize.getDocument()) {
                this.checkWindowGroupSize();
                this.checkOKButton();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void okInvoked() {
        Object object;
        Object object2;
        boolean bl = false;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._agreement.port != this._saveAgreement.port) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaPort", String.valueOf(this._agreement.port)));
            bl = true;
        }
        if (this._agreement.isSSL != this._saveAgreement.isSSL) {
            if (this._agreement.isSSL) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaTransportInfo", "SSL"));
            } else {
                lDAPModificationSet.add(1, new LDAPAttribute("nsDS5ReplicaTransportInfo"));
            }
            bl = true;
        }
        if (this._agreement.authentication != this._saveAgreement.authentication) {
            if (this._agreement.authentication == 0) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaBindMethod", "SIMPLE"));
            } else {
                lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaBindMethod", "SSLCLIENTAUTH"));
            }
            bl = true;
        }
        if (this._agreement.authentication == 0) {
            if (!this._saveAgreement.authenticationDn.equals(this._tfBindDn.getText())) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaBindDN", this._tfBindDn.getText()));
                bl = true;
            }
            if (!this._saveAgreement.authenticationPwd.equals(String.valueOf(this._pfBindPwd.getPassword()))) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaCredentials", String.valueOf(this._pfBindPwd.getPassword())));
                bl = true;
            }
        } else {
            if (!this._saveAgreement.authenticationDn.equals("")) {
                lDAPModificationSet.add(1, new LDAPAttribute("nsDS5ReplicaBindDN"));
                bl = true;
            }
            if (!this._saveAgreement.authenticationPwd.equals("")) {
                lDAPModificationSet.add(1, new LDAPAttribute("nsDS5ReplicaCredentials"));
                bl = true;
            }
        }
        if (this._rbAlwaysSync.isSelected()) {
            this._agreement.schedule = "*";
        } else {
            String string = this.get2Digit(this._tfBeginHour.getText()) + this.get2Digit(this._tfBeginMinute.getText()) + "-" + this.get2Digit(this._tfEndHour.getText()) + this.get2Digit(this._tfEndMinute.getText());
            String string2 = "";
            int n = 0;
            while (n < this._cbDays.length) {
                if (this._cbDays[n].isSelected()) {
                    string2 = string2 + String.valueOf(n);
                }
                ++n;
            }
            this._agreement.schedule = string + " " + string2;
        }
        if (!this._agreement.schedule.equals(this._saveAgreement.schedule)) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsDS5ReplicaUpdateSchedule", this._agreement.schedule));
        }
        if (!this._tfDescription.getText().equals(this._saveAgreement.description)) {
            lDAPModificationSet.add(2, new LDAPAttribute("description", this._tfDescription.getText()));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this._cbUsePartial.isSelected()) {
            if (!this._saveAgreement.partialReplication.equals("")) {
                lDAPModificationSet.add(1, new LDAPAttribute("ds5PartialReplConfiguration"));
                bl2 = true;
            }
        } else {
            String string = ((PartialRule)this._comboRules.getSelectedItem()).name;
            if (!this._saveAgreement.partialReplication.equals(string)) {
                lDAPModificationSet.add(2, new LDAPAttribute("ds5PartialReplConfiguration", string));
                bl3 = true;
            }
        }
        try {
            if (this._saveAgreement.windowSize != Integer.parseInt(this._tfWindowSize.getText())) {
                lDAPModificationSet.add(2, new LDAPAttribute("ds5ReplicaTransportWindowSize", this._tfWindowSize.getText()));
            }
            if (this._saveAgreement.groupSize != Integer.parseInt(this._tfGroupSize.getText())) {
                lDAPModificationSet.add(2, new LDAPAttribute("ds5ReplicaTransportGroupSize", this._tfGroupSize.getText()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        boolean bl4 = true;
        if (bl && !this._agreement.isSSL) {
            boolean bl5;
            int n = DSUtil.showConfirmationDialog((Component)((Object)this), "confirmation-testconnection", (String[])null, "editagreementdialog", _resource);
            boolean bl6 = bl5 = n == 0;
            if (bl5) {
                object2 = this._tfBindDn.getText();
                object = String.valueOf(this._pfBindPwd.getPassword());
                bl4 = NewAgreementDialog.testAuthentication((JFrame)((Object)this._framework), (String)object2, (String)object, this._agreement.host, String.valueOf(this._agreement.port), this._isLocal);
            }
        }
        if (lDAPModificationSet.size() > 0) {
            if (bl4) {
                LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                try {
                    lDAPConnection.modify(this._agreement.dn, lDAPModificationSet);
                    super.okInvoked();
                    this._isModified = true;
                    if (bl2) {
                        PartialReplication partialReplication = this._framework.getServerObject().getPartialReplication();
                        object2 = partialReplication.getRule(this._saveAgreement.partialReplication);
                        if (object2 != null) {
                            ((PartialRule)object2).removeAgreement(this._saveAgreement.dn);
                        }
                        DSUtil.showInformationDialog((Component)((Object)this), "warning-partialdeleted", null, "editagreementdialog", _resource);
                    } else if (bl3) {
                        PartialRule partialRule;
                        PartialRule partialRule2 = (PartialRule)this._comboRules.getSelectedItem();
                        object2 = partialRule2.name;
                        object = this._framework.getServerObject().getPartialReplication();
                        PartialRule partialRule3 = ((PartialReplication)object).getRule(this._saveAgreement.partialReplication);
                        if (partialRule3 != null) {
                            partialRule3.removeAgreement(this._saveAgreement.dn);
                        }
                        if ((partialRule = ((PartialReplication)object).getRule((String)object2)) != null) {
                            partialRule.addAgreement(this._agreement);
                        }
                        String[] stringArray = new String[]{this._agreement.host + ":" + String.valueOf(this._agreement.port)};
                        DSUtil.showInformationDialog((Component)((Object)this), "warning-partialadded", stringArray, "editagreementdialog", _resource);
                    }
                }
                catch (LDAPException lDAPException) {
                    object2 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    DSUtil.showErrorDialog((Component)((Object)this), "error-modifyingagreement-title", "error-modifyingagreement-msg", (String[])object2, "editagreementdialog", _resource);
                }
            }
        } else {
            super.okInvoked();
        }
    }

    protected void helpInvoked() {
        String string = null;
        int n = this._tabbedPanel.getSelectedIndex();
        switch (n) {
            case 0: {
                string = "configuration-replication-edit-agreement-connection-dbox-help";
                break;
            }
            case 1: {
                string = "configuration-replication-edit-agreement-schedule-dbox-help";
                break;
            }
            case 2: {
                string = "configuration-replication-edit-agreement-partialreplication-dbox-help";
                break;
            }
            case 3: {
                string = "configuration-replication-edit-agreement-network-dbox-help";
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        DSUtil.help(string, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void layoutContentPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._tabbedPanel = new JTabbedPane(1);
        this._tabbedPanel.addTab(_resource.getString("editagreementdialog-remotereplicapanel", "title"), this.createRemoteReplicaPanel());
        this._tabbedPanel.addTab(_resource.getString("editagreementdialog-schedulepanel", "title"), this.createSchedulePanel());
        this._tabbedPanel.addTab(_resource.getString("editagreementdialog-partialreplicationpanel", "title"), this.createPartialReplicationPanel());
        this._tabbedPanel.addTab(_resource.getString("editagreementdialog-networkpanel", "title"), this.createNetworkPanel());
        JLabel jLabel = UIFactory.makeJLabel("editagreementdialog", "ldescription", _resource);
        this._tfDescription = UIFactory.makeJTextField(null, "editagreementdialog", "ldescription", this._saveAgreement.description, 30, _resource);
        jLabel.setLabelFor(this._tfDescription);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this._tabbedPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._tfDescription, gridBagConstraints);
        this.checkOKButton();
        this.setComponent(jPanel);
    }

    private JPanel createRemoteReplicaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._bChangePort = UIFactory.makeJButton(this, "editagreementdialog", "bchangeport", _resource);
        GroupPanel groupPanel = new GroupPanel(_resource.getString("editagreementdialog", "authenticationpanel-title"));
        this._lAuthentication = new JLabel();
        this._bChangeAuthentication = UIFactory.makeJButton(this, "editagreementdialog", "bchangeauthentication", _resource);
        this._simpleAuthenticationPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("editagreementdialog", "lbinddn", _resource);
        this._tfBindDn = UIFactory.makeJTextField(this, "editagreementdialog", "lbinddn", null, 30, _resource);
        jLabel.setLabelFor(this._tfBindDn);
        JLabel jLabel2 = UIFactory.makeJLabel("editagreementdialog", "lbindpwd", _resource);
        this._pfBindPwd = UIFactory.makeJPasswordField(this, "editagreementdialog", "lbindpwd", null, 30, _resource);
        jLabel2.setLabelFor(this._pfBindPwd);
        String string = this._saveAgreement.host + ":" + String.valueOf(this._saveAgreement.port);
        String[] stringArray = new String[]{string};
        stringArray[0] = this._saveAgreement.isSSL ? string + " " + _resource.getString("editagreementdialog", "secure-label") : string;
        this._lHostPort = new JLabel();
        this._lHostPort.setText(_resource.getString("editagreementdialog", "lhostport-label", stringArray));
        if (this._saveAgreement.authentication == 0) {
            this._lAuthentication.setText(_resource.getString("editagreementdialog", "simpleauthentication-label"));
            this._tfBindDn.setText(this._saveAgreement.authenticationDn);
            ((JTextComponent)this._pfBindPwd).setText(this._saveAgreement.authenticationPwd);
        } else if (this._saveAgreement.authentication == 2) {
            this._lAuthentication.setText(_resource.getString("editagreementdialog", "starttls-label"));
            this._tfBindDn.setText(this._saveAgreement.authenticationDn);
            ((JTextComponent)this._pfBindPwd).setText(this._saveAgreement.authenticationPwd);
        } else {
            this._lAuthentication.setText(_resource.getString("editagreementdialog", "certificateauthentication-label"));
        }
        this._bChangeAuthentication.setEnabled(this._saveAgreement.isSSL);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 2 + UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.right = 2 + UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._lHostPort, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        jPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._lAuthentication, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        groupPanel.add((Component)this._bChangeAuthentication, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        this._authenticationPanel = new JPanel(new BorderLayout());
        groupPanel.add((Component)this._authenticationPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        if (this._saveAgreement.authentication == 0) {
            this._authenticationPanel.add("Center", this._simpleAuthenticationPanel);
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this._simpleAuthenticationPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._simpleAuthenticationPanel.add((Component)this._tfBindDn, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        this._simpleAuthenticationPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._simpleAuthenticationPanel.add((Component)this._pfBindPwd, gridBagConstraints);
        return jPanel;
    }

    private JPanel createSchedulePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._rbAlwaysSync = UIFactory.makeJRadioButton(null, "editagreementdialog", "rbalwayssync", true, _resource);
        this._rbAlwaysSync.addActionListener(this);
        this._rbSyncIn = UIFactory.makeJRadioButton(null, "editagreementdialog", "rbsyncin", true, _resource);
        this._rbSyncIn.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbAlwaysSync);
        buttonGroup.add(this._rbSyncIn);
        this._cbDays = new JCheckBox[7];
        int n = 0;
        while (n < this._cbDays.length) {
            this._cbDays[n] = UIFactory.makeJCheckBox(this, "editagreementdialog", "day" + n, false, _resource);
            ++n;
        }
        this._bAll = UIFactory.makeJButton(this, "editagreementdialog", "ball", _resource);
        JLabel jLabel = UIFactory.makeJLabel("editagreementdialog", "lhourminute", _resource);
        JLabel jLabel2 = UIFactory.makeJLabel("editagreementdialog", "lbetween", _resource);
        this._tfBeginHour = UIFactory.makeJTextField(this, "editagreementdialog", "lhourminute", null, 3, _resource);
        this._tfBeginMinute = UIFactory.makeJTextField(this, "editagreementdialog", "lhourminute", null, 3, _resource);
        this._tfEndHour = UIFactory.makeJTextField(this, "editagreementdialog", "lbetween", null, 3, _resource);
        this._tfEndMinute = UIFactory.makeJTextField(this, "editagreementdialog", "lbetween", null, 3, _resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._rbAlwaysSync, gridBagConstraints);
        jPanel.add((Component)this._rbSyncIn, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, UIFactory.getComponentSpace());
        gridBagConstraints.gridwidth = this._cbDays.length + 2;
        gridBagConstraints.weightx = 0.0;
        int n2 = 1;
        while (n2 < this._cbDays.length) {
            jPanel2.add((Component)this._cbDays[n2], gridBagConstraints);
            --gridBagConstraints.gridwidth;
            ++n2;
        }
        jPanel2.add((Component)this._cbDays[0], gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)this._bAll, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)this._tfBeginHour, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)this._tfBeginMinute, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)this._tfEndHour, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.insets.right = 0;
        jPanel3.add((Component)this._tfEndMinute, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 20, 0, UIFactory.getComponentSpace());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        String string = this._saveAgreement.schedule;
        if (string.equals("*")) {
            this._rbAlwaysSync.setSelected(true);
            int n3 = 0;
            while (n3 < this._cbDays.length) {
                this._cbDays[n3].setEnabled(false);
                ++n3;
            }
            this._tfBeginHour.setEnabled(false);
            this._tfBeginMinute.setEnabled(false);
            this._tfEndHour.setEnabled(false);
            this._tfEndMinute.setEnabled(false);
            this._bAll.setEnabled(false);
        } else {
            this._rbSyncIn.setSelected(true);
            try {
                string = string.trim();
                String string2 = string.substring(0, 2);
                String string3 = string.substring(2, 4);
                String string4 = string.substring(5, 7);
                String string5 = string.substring(7, 9);
                this._tfBeginHour.setText(string2);
                this._tfBeginMinute.setText(string3);
                this._tfEndHour.setText(string4);
                this._tfEndMinute.setText(string5);
                int n4 = string.lastIndexOf(" ");
                int n5 = n4 + 1;
                while (n5 < string.length()) {
                    int n6 = Integer.parseInt(String.valueOf(string.charAt(n5)));
                    this._cbDays[n6].setSelected(true);
                    ++n5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jPanel;
    }

    /*
     * Unable to fully structure code
     */
    private JPanel createPartialReplicationPanel() {
        block4: {
            var1_1 = this._framework.getServerObject().getPartialReplication();
            var2_2 = new JPanel(new GridBagLayout());
            this._cbUsePartial = UIFactory.makeJCheckBox(this, "editagreementdialog", "cbusepartial", false, EditAgreementDialog._resource);
            var3_3 = UIFactory.makeJLabel("editagreementdialog", "lsets", EditAgreementDialog._resource);
            this._comboRules = new JComboBox<E>();
            var4_4 = new RuleCellRenderer(var1_1);
            this._comboRules.setRenderer(var4_4);
            this._bManageSets = UIFactory.makeJButton(this, "editagreementdialog", "bmanagesets", EditAgreementDialog._resource);
            this._bAddSet = UIFactory.makeJButton(this, "editagreementdialog", "baddset", EditAgreementDialog._resource);
            var5_5 = new GridBagConstraints();
            var6_6 = new JPanel(new GridBagLayout());
            var5_5.gridwidth = -1;
            var5_5.fill = 2;
            var5_5.weightx = 1.0;
            var6_6.add(Box.createHorizontalGlue(), var5_5);
            var5_5.gridwidth = 0;
            var5_5.weightx = 0.0;
            var6_6.add((Component)this._bManageSets, var5_5);
            var5_5.gridwidth = 0;
            var5_5.fill = 2;
            var5_5.weightx = 0.0;
            var5_5.anchor = 17;
            if (this._saveAgreement.isEnabled) {
                var7_7 = UIFactory.makeJLabel("editagreementdialog", "lnopartialmodifyallowed", EditAgreementDialog._resource);
                var7_7.setIcon((Icon)DSUtil.getPackageImage("failed.gif"));
                var7_7.setFont(var7_7.getFont().deriveFont(0));
                var5_5.insets = new Insets(UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace(), 0);
                var2_2.add((Component)var7_7, var5_5);
                this._cbUsePartial.setEnabled(false);
                this._comboRules.setEnabled(false);
                this._bAddSet.setEnabled(false);
                this._bManageSets.setEnabled(false);
                var3_3.setEnabled(false);
            }
            var5_5.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
            var2_2.add((Component)this._cbUsePartial, var5_5);
            var5_5.gridwidth = 3;
            var2_2.add((Component)var3_3, var5_5);
            var5_5.insets.left = 0;
            var5_5.insets.right = UIFactory.getComponentSpace();
            var5_5.weightx = 1.0;
            var5_5.gridwidth = -1;
            var2_2.add((Component)this._comboRules, var5_5);
            var5_5.weightx = 0.0;
            var5_5.gridwidth = 0;
            var2_2.add((Component)this._bAddSet, var5_5);
            var5_5.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
            var5_5.weighty = 1.0;
            var5_5.fill = 3;
            var2_2.add(Box.createVerticalGlue(), var5_5);
            var5_5.weightx = 1.0;
            var5_5.weighty = 0.0;
            var5_5.fill = 2;
            var2_2.add((Component)var6_6, var5_5);
            var7_7 = var1_1.getRules();
            if (var7_7.hasMoreElements()) ** GOTO lbl59
            this._comboRules.addItem(RuleCellRenderer.NO_RULE_AVAILABLE);
            break block4;
lbl-1000:
            // 1 sources

            {
                this._comboRules.addItem(var7_7.nextElement());
lbl59:
                // 2 sources

                ** while (var7_7.hasMoreElements())
            }
lbl60:
            // 1 sources

            var8_8 = new PartialRule();
            var8_8.name = "12345";
            var8_8.description = "123456789012345678901234567890";
            var9_9 = var4_4.getListCellRendererComponent((JList)new JList<E>(), var8_8, 0, false, false);
            this._comboRules.setPreferredSize(new Dimension((int)var9_9.getPreferredSize().getWidth(), (int)this._comboRules.getPreferredSize().getHeight()));
        }
        this._comboRules.addActionListener(this);
        var8_8 = this._saveAgreement.partialReplication;
        if (var8_8.equals("")) {
            this._bManageSets.setEnabled(false);
            this._bAddSet.setEnabled(false);
            this._comboRules.setEnabled(false);
            this._cbUsePartial.setSelected(false);
        } else {
            this._comboRules.setSelectedItem(var1_1.getRule((String)var8_8));
            this._cbUsePartial.setSelected(true);
        }
        this._partialValid = this._cbUsePartial.isSelected() == false || this._comboRules.getSelectedItem() != RuleCellRenderer.NO_RULE_AVAILABLE;
        return var2_2;
    }

    private JPanel createNetworkPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("editagreementdialog", "lwindowsize", _resource);
        this._tfWindowSize = UIFactory.makeJTextField(this, "editagreementdialog", "lwindowsize", String.valueOf(this._saveAgreement.windowSize), 5, _resource);
        jLabel.setLabelFor(this._tfWindowSize);
        JLabel jLabel2 = UIFactory.makeJLabel("editagreementdialog", "lgroupsize", _resource);
        this._tfGroupSize = UIFactory.makeJTextField(this, "editagreementdialog", "lgroupsize", String.valueOf(this._saveAgreement.groupSize), 5, _resource);
        jLabel2.setLabelFor(this._tfGroupSize);
        JLabel jLabel3 = UIFactory.makeJLabel("editagreementdialog", "lwindowgroupwarning", _resource);
        jLabel3.setFont(jLabel3.getFont().deriveFont(2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)this._tfWindowSize, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)this._tfGroupSize, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return jPanel;
    }

    private void checkOKButton() {
        boolean bl = this._dnValid && (this._simpleAuthenticationPanel.getParent() != this._authenticationPanel || this._pwdValid) && (this._rbAlwaysSync.isSelected() || this._daysValid && this._timeValid) && this._windowSizeValid && this._groupSizeValid && this._partialValid;
        this.setOKButtonEnabled(bl);
    }

    private void checkScheduleTime() {
        try {
            int n = Integer.parseInt(this._tfBeginHour.getText());
            boolean bl = this._timeValid = 0 <= n && n <= 23;
            if (this._timeValid) {
                int n2 = Integer.parseInt(this._tfEndHour.getText());
                boolean bl2 = this._timeValid = 0 <= n2 && n2 <= 23 && n <= n2;
                if (this._timeValid) {
                    int n3 = Integer.parseInt(this._tfBeginMinute.getText());
                    boolean bl3 = this._timeValid = 0 <= n3 && n3 <= 59;
                    if (this._timeValid) {
                        int n4 = Integer.parseInt(this._tfEndMinute.getText());
                        boolean bl4 = this._timeValid = 0 <= n4 && n4 <= 59;
                        if (this._timeValid && n == n2) {
                            this._timeValid = n3 < n4;
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this._timeValid = false;
        }
    }

    private void actionChangePort() {
        RemoteReplicaDialog remoteReplicaDialog = new RemoteReplicaDialog((JFrame)((Object)this._framework), this._agreement.host, this._agreement.port, this._agreement.isSSL);
        remoteReplicaDialog.pack();
        remoteReplicaDialog.show();
        if (!remoteReplicaDialog.isCancelled()) {
            this._agreement.port = remoteReplicaDialog.getPort();
            this._agreement.isSSL = remoteReplicaDialog.isSSL();
            String string = this._agreement.host + ":" + String.valueOf(this._agreement.port);
            String[] stringArray = new String[]{this._agreement.isSSL ? string + " " + _resource.getString("editagreementdialog", "secure-label") : string};
            this._lHostPort.setText(_resource.getString("editagreementdialog", "lhostport-label", stringArray));
            if (!this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel) && !this._agreement.isSSL) {
                this._authenticationPanel.add("Center", this._simpleAuthenticationPanel);
                this._tabbedPanel.revalidate();
                this._tabbedPanel.repaint();
            } else if (this._agreement.isSSL && this._agreement.authentication == 2) {
                this._agreement.authentication = 0;
                this._lAuthentication.setText(_resource.getString("editagreementdialog", "simpleauthentication-label"));
            }
            ((JTextComponent)this._pfBindPwd).setText("");
        }
    }

    private void actionChangeAuthentication() {
        AgreementAuthenticationTypeDialog agreementAuthenticationTypeDialog = new AgreementAuthenticationTypeDialog((JFrame)((Object)this._framework), this._agreement);
        agreementAuthenticationTypeDialog.pack();
        agreementAuthenticationTypeDialog.show();
        if (!agreementAuthenticationTypeDialog.isCancelled()) {
            this._agreement.authentication = agreementAuthenticationTypeDialog.getAuthentication();
            if (this._agreement.authentication == 0) {
                this._lAuthentication.setText(_resource.getString("editagreementdialog", "simpleauthentication-label"));
                ((JTextComponent)this._pfBindPwd).setText("");
            } else if (this._agreement.authentication == 2) {
                this._lAuthentication.setText(_resource.getString("editagreementdialog", "starttls-label"));
                ((JTextComponent)this._pfBindPwd).setText("");
            } else {
                this._lAuthentication.setText(_resource.getString("editagreementdialog", "certificateauthentication-label"));
            }
            if (!this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel) && this._agreement.authentication != 1) {
                this._authenticationPanel.add("Center", this._simpleAuthenticationPanel);
                this._dnValid = !this._tfBindDn.getText().equals("") && DN.isDN((String)this._tfBindDn.getText());
                this.checkOKButton();
                this._tabbedPanel.revalidate();
                this._tabbedPanel.repaint();
            } else if (this._authenticationPanel.isAncestorOf(this._simpleAuthenticationPanel) && this._agreement.authentication == 1) {
                this._authenticationPanel.remove(this._simpleAuthenticationPanel);
                this._dnValid = true;
                this.checkOKButton();
                this._tabbedPanel.revalidate();
                this._tabbedPanel.repaint();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void actionManageSets() {
        block2: {
            var1_1 = new PartialReplicationRuleManager(this._framework);
            var1_1.pack();
            var1_1.show();
            var2_2 = null;
            if (this._comboRules.getSelectedItem() != RuleCellRenderer.NO_RULE_AVAILABLE) {
                var2_2 = (PartialRule)this._comboRules.getSelectedItem();
            }
            this._comboRules.removeAllItems();
            var3_3 = this._framework.getServerObject().getPartialReplication();
            var4_4 = var3_3.getRules();
            if (var4_4.hasMoreElements()) ** GOTO lbl17
            this._comboRules.addItem(RuleCellRenderer.NO_RULE_AVAILABLE);
            break block2;
lbl-1000:
            // 1 sources

            {
                var5_5 = (PartialRule)var4_4.nextElement();
                this._comboRules.addItem(var5_5);
                if (var5_5 != var2_2 && !var5_5.name.equals(var2_2.name)) continue;
                this._comboRules.setSelectedItem(var5_5);
lbl17:
                // 3 sources

                ** while (var4_4.hasMoreElements())
            }
        }
    }

    private void actionAddSet() {
        PartialAttributeElementDialog partialAttributeElementDialog = new PartialAttributeElementDialog(this._framework);
        partialAttributeElementDialog.pack();
        partialAttributeElementDialog.show();
        PartialRule partialRule = partialAttributeElementDialog.getPartialRule();
        if (partialRule != null) {
            this._comboRules.addItem(partialRule);
            this._comboRules.setSelectedItem(partialRule);
        }
    }

    private boolean isValidValue(String string, int n, int n2) {
        boolean bl;
        try {
            int n3 = Integer.parseInt(string);
            bl = n <= n3 && n3 <= n2;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private void checkWindowGroupSize() {
        this._windowSizeValid = this.isValidValue(this._tfWindowSize.getText(), 1, 1000);
        this._groupSizeValid = this.isValidValue(this._tfGroupSize.getText(), 1, 100);
        if (this._windowSizeValid && this._groupSizeValid) {
            try {
                int n = Integer.parseInt(this._tfWindowSize.getText());
                int n2 = Integer.parseInt(this._tfGroupSize.getText());
                this._groupSizeValid = this._windowSizeValid = n >= n2;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    private String get2Digit(String string) {
        String string2 = null;
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n < 10) {
                string2 = "0" + n;
            } else if (n >= 10 && n < 100) {
                string2 = String.valueOf(n);
            } else {
                Thread.dumpStack();
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return string2;
    }
}

