/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.UIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class AgreementCellRenderer
extends BasicComboBoxRenderer {
    boolean _initialized;
    JPanel _noAgreementPanel;
    Icon _iconNotInitializing = DSUtil.getPackageImage("ds-rep-get-16.gif");
    Icon _iconInitializing = DSUtil.getPackageImage("rep-init-16.gif");
    Icon _iconDisabled = DSUtil.getPackageImage("rep-dis16.gif");
    Icon _iconSuspended = DSUtil.getPackageImage("rep-init-suspended-16.gif");
    static final String NO_SERVER_TO_UPDATE = "NO_SERVER_TO_UPDATE";

    AgreementCellRenderer() {
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JComponent jComponent;
        if (object == NO_SERVER_TO_UPDATE) {
            if (this._noAgreementPanel == null) {
                this.createNoAgreementPanel(jList.getBackground());
            }
            jComponent = this._noAgreementPanel;
        } else {
            ReplicationAgreement replicationAgreement = (ReplicationAgreement)object;
            String string = AgreementCellRenderer.getDisplayText(replicationAgreement);
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            if (!this._initialized) {
                jLabel.setBorder(new EmptyBorder(0, 3, 0, 3));
                this._initialized = true;
            }
            Icon icon = !replicationAgreement.isEnabled ? this._iconDisabled : (replicationAgreement.isSuspended ? this._iconSuspended : (replicationAgreement.isInitializing ? this._iconInitializing : this._iconNotInitializing));
            if (jLabel.getIcon() != icon) {
                jLabel.setIcon(icon);
            }
            jComponent = jLabel;
        }
        return jComponent;
    }

    private void createNoAgreementPanel(Color color) {
        this._noAgreementPanel = new JPanel(new GridBagLayout());
        this._noAgreementPanel.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = UIFactory.makeJLabel("agreementcellrenderer", "no-server-to-update", ReplicaWizard._resource);
        JLabel jLabel2 = UIFactory.makeJLabel("agreementcellrenderer", "no-data-replicated", ReplicaWizard._resource);
        jLabel2.setForeground((Color)UIManager.get("Label.error"));
        jLabel2.setFont(jLabel2.getFont().deriveFont(2));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(color);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._noAgreementPanel.add((Component)new JLabel((Icon)DSUtil.getPackageImage("alertl.gif")), gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        this._noAgreementPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this._noAgreementPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    static String getDisplayText(ReplicationAgreement replicationAgreement) {
        String string = "";
        string = replicationAgreement.isSSL ? replicationAgreement.host + ":" + replicationAgreement.port + ReplicaWizard._resource.getString("agreementcellrenderer-secureport", "label") : replicationAgreement.host + ":" + replicationAgreement.port;
        if (replicationAgreement.authentication == 2) {
            string = string + "  " + ReplicaWizard._resource.getString("agreementcellrenderer-starttls", "label");
        } else if (replicationAgreement.authentication == 1) {
            string = string + "  " + ReplicaWizard._resource.getString("agreementcellrenderer-certificate", "label");
        }
        if (!replicationAgreement.description.equals("")) {
            string = string + "  " + replicationAgreement.description;
        }
        return string;
    }
}

