/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.NewChainedSuffixDialog;
import com.netscape.admin.dirserv.config.NewSuffixDialog;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.components.SwingWorker;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class NewChainedSuffixDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private JPanel _contentPanel;
    private JTextField _tfDn;
    private JTextField _tfHost;
    private JTextField _tfPort;
    private JTextField _tfBindDn;
    private JPasswordField _pfBindPwd;
    private JCheckBox _cbIsSecure;
    private JLabel _lLdapUrl;
    private JLabel _lSuffix;
    private boolean _isDnValid;
    private boolean _isHostValid;
    private boolean _isPortValid = true;
    private boolean _isBindDnValid = true;
    private Suffix _parentSuffix;
    private Suffix _suffix;
    private String _helpToken = "configuration-new-chained-suffix-dbox-help";
    private static final ResourceSet _resource = DSConfigPage._resource;

    public NewChainedSuffixDialog(DSFramework dSFramework) {
        this(dSFramework, null);
    }

    public NewChainedSuffixDialog(DSFramework dSFramework, Suffix suffix) {
        super((Frame)((Object)dSFramework), suffix == null ? _resource.getString("newchainedsuffixdialog", "rootsuffix-title") : _resource.getString("newchainedsuffixdialog", "subsuffix-title"), true, 11);
        this._framework = dSFramework;
        this._parentSuffix = suffix;
        this.layoutContentPane();
        this.setComponent(this._contentPanel);
        this.setOKButtonEnabled(false);
    }

    public Suffix getSuffix() {
        return this._suffix;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbIsSecure) {
            this.updateLDAPUrl();
            if (this._tfPort.getText().equals("")) {
                String string = this._cbIsSecure.isSelected() ? "636" : "389";
                this._tfPort.setText(string);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._tfDn.getDocument()) {
            boolean bl = this._isDnValid = !this._tfDn.getText().equals("") && DN.isDN((String)this._tfDn.getText());
            if (this._isDnValid && this._parentSuffix != null) {
                String[] stringArray = new String[]{this._tfDn.getText() + ", " + this._parentSuffix.getName()};
                this._lSuffix.setText(_resource.getString("newchainedsuffixdialog", "completesuffix-label", stringArray));
            }
        } else if (documentEvent.getDocument() == this._tfPort.getDocument()) {
            try {
                int n = Integer.parseInt(this._tfPort.getText());
                this._isPortValid = n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                this._isPortValid = false;
            }
            this.updateLDAPUrl();
        } else if (documentEvent.getDocument() == this._tfHost.getDocument()) {
            this._isHostValid = this._tfHost.getText().trim().length() > 0;
            this.updateLDAPUrl();
        } else if (documentEvent.getDocument() == this._tfBindDn.getDocument()) {
            this._isBindDnValid = DN.isDN((String)this._tfBindDn.getText());
            this.updateLDAPUrl();
        } else if (documentEvent.getDocument() == this._pfBindPwd.getDocument()) {
            this.updateLDAPUrl();
        }
        this.checkOKButtonEnabled();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public static boolean testAuthentication(JFrame jFrame, String string, String string2, String string3, int n, boolean bl) {
        boolean[] blArray = new boolean[]{true};
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(jFrame, true, 1, _resource.getString("newchainedsuffixdialog", "testingconnection-title"));
        genericProgressDialog.setTextInLabel(_resource.getString("newchainedsuffixdialog", "testingconnection-msg"));
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setLabelColumns(25);
        class MySwingWorker
        extends SwingWorker {
            boolean _errorHappened;
            boolean _connected;
            boolean _authenticated;
            boolean _timeOutHappened;
            boolean _doModification;
            boolean _isDirectoryManager;
            boolean _controlFound;
            final int TIME_LIMIT = 5;
            private final /* synthetic */ String val$host;
            private final /* synthetic */ int val$port;
            private final /* synthetic */ String val$bindDn;
            private final /* synthetic */ String val$bindPwd;
            private final /* synthetic */ JFrame val$frame;
            private final /* synthetic */ boolean val$isLocal;
            private final /* synthetic */ GenericProgressDialog val$dlg;

            MySwingWorker(String string, int n, String string2, String string3, JFrame jFrame, boolean bl, GenericProgressDialog genericProgressDialog) {
                this.val$host = string;
                this.val$port = n;
                this.val$bindDn = string2;
                this.val$bindPwd = string3;
                this.val$frame = jFrame;
                this.val$isLocal = bl;
                this.val$dlg = genericProgressDialog;
                this._errorHappened = false;
                this._connected = false;
                this._authenticated = false;
                this._timeOutHappened = false;
                this._doModification = true;
                this._isDirectoryManager = false;
                this._controlFound = false;
                this.TIME_LIMIT = 5;
            }

            public Object construct() {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LDAPConnection lDAPConnection = DSUtil.makeLDAPConnection(false);
                try {
                    Object object;
                    Enumeration enumeration;
                    LDAPAttribute lDAPAttribute;
                    if (lDAPConnection == null) {
                        throw new LDAPException("Could not create connection");
                    }
                    lDAPConnection.setConnectTimeout(5);
                    lDAPConnection.connect(this.val$host, this.val$port);
                    LDAPConstraints lDAPConstraints = lDAPConnection.getConstraints();
                    lDAPConstraints.setTimeLimit(5000);
                    lDAPConnection.setConstraints(lDAPConstraints);
                    this._connected = true;
                    lDAPConnection.authenticate(3, this.val$bindDn, this.val$bindPwd);
                    this._authenticated = true;
                    String[] stringArray = new String[]{"supportedControl"};
                    LDAPEntry lDAPEntry = lDAPConnection.read("", stringArray);
                    if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("supportedControl")) != null) {
                        enumeration = lDAPAttribute.getStringValues();
                        while (enumeration.hasMoreElements() && !this._controlFound) {
                            object = (String)enumeration.nextElement();
                            this._controlFound = ((String)object).equals("2.16.840.1.113730.3.4.18");
                        }
                    }
                    if (!this._controlFound) {
                        throw new LDAPException("Control not found");
                    }
                    stringArray[0] = "nsslapd-rootdn";
                    try {
                        lDAPAttribute = lDAPConnection.read("cn=config", stringArray);
                        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getAttribute("nsslapd-rootdn")) != null) {
                            object = enumeration.getStringValues();
                            while (object.hasMoreElements() && !this._isDirectoryManager) {
                                String string = (String)object.nextElement();
                                boolean bl = this._isDirectoryManager = DSUtil.equalDNs(this.val$bindDn, string) || string.equalsIgnoreCase(this.val$bindDn);
                            }
                        }
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                    if (this._isDirectoryManager) {
                        throw new LDAPException("is directory manager");
                    }
                }
                catch (LDAPException lDAPException) {
                    this._errorHappened = true;
                    boolean bl = this._timeOutHappened = lDAPException.getLDAPResultCode() == 3 || lDAPException.getLDAPResultCode() == 85;
                }
                if (this._connected) {
                    try {
                        lDAPConnection.disconnect();
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                }
                return null;
            }

            public void finished() {
                if (this._errorHappened) {
                    if (!this._connected) {
                        int n;
                        int n2;
                        String[] stringArray;
                        int n3;
                        this._doModification = this._timeOutHappened ? (n3 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotconnect-timeout", stringArray = new String[]{String.valueOf(5)}, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000())) == 0 : (this.val$isLocal ? (n2 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotconnect", (String[])null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000())) == 0 : (n = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotconnect-notlocal", (String[])null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000())) == 0);
                    } else if (!this._authenticated) {
                        int n;
                        int n4;
                        String[] stringArray;
                        int n5;
                        this._doModification = this._timeOutHappened ? (n5 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotbind-timeout", stringArray = new String[]{String.valueOf(5)}, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000())) == 0 : (this.val$isLocal ? (n4 = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotbind", (String[])null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000())) == 0 : (n = DSUtil.showConfirmationDialog((Component)this.val$frame, "couldnotbind-notlocal", (String[])null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000())) == 0);
                    } else if (!this._controlFound) {
                        DSUtil.showErrorDialog((Component)this.val$frame, "controlnotfound", (String[])null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000());
                        this._doModification = false;
                    } else if (this._isDirectoryManager) {
                        DSUtil.showErrorDialog((Component)this.val$frame, "isdirectorymanager", (String[])null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000());
                        this._doModification = false;
                    }
                    this.val$dlg.closeCallBack();
                } else {
                    this.val$dlg.closeCallBack();
                    if (this._authenticated && this.val$isLocal) {
                        DSUtil.showInformationDialog(null, "warning-checkreliability", null, "newchainedsuffixdialog", NewChainedSuffixDialog.access$000());
                    }
                }
            }

            public boolean doModification() {
                return this._doModification;
            }
        }
        MySwingWorker mySwingWorker = new MySwingWorker(string3, n, string, string2, jFrame, bl, genericProgressDialog);
        mySwingWorker.start();
        genericProgressDialog.packAndShow();
        return mySwingWorker.doModification();
    }

    protected void okInvoked() {
        final DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        final String string = this._parentSuffix == null ? this._tfDn.getText() : this._tfDn.getText() + ", " + this._parentSuffix.getName();
        boolean bl = true;
        if (!this._cbIsSecure.isSelected()) {
            boolean bl2;
            int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirmation-testconnection", (String[])null, "newchainedsuffixdialog", _resource);
            boolean bl3 = bl2 = n == 0;
            if (bl2) {
                boolean bl4 = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
                try {
                    bl = NewChainedSuffixDialog.testAuthentication((JFrame)((Object)this._framework), this._tfBindDn.getText(), String.valueOf(this._pfBindPwd.getPassword()), this._tfHost.getText(), Integer.parseInt(this._tfPort.getText()), bl4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            if (!this.suffixExists(string, databaseConfig)) {
                final GenericProgressDialog genericProgressDialog = this.createProgressDialog();
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        String[] stringArray;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean bl = false;
                        LDAPConnection lDAPConnection = NewChainedSuffixDialog.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                        String string5 = NewSuffixDialog.getDbNameFromSuffix(string, 1, databaseConfig);
                        String string2 = "cn=" + DSUtil.getRdnValue(string) + ", cn=mapping tree, cn=config";
                        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                        String[] stringArray2 = new String[]{"extensibleObject", "nsMappingTree"};
                        lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray2));
                        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-backend", string5));
                        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-state", "backend"));
                        if (NewChainedSuffixDialog.this._parentSuffix != null) {
                            lDAPAttributeSet.add(new LDAPAttribute("nsslapd-parent-suffix", NewChainedSuffixDialog.this._parentSuffix.getName()));
                        }
                        LDAPEntry lDAPEntry = new LDAPEntry(string2, lDAPAttributeSet);
                        try {
                            lDAPConnection.add(lDAPEntry);
                            NewChainedSuffixDialog.this._suffix = new Suffix();
                            NewChainedSuffixDialog.this._suffix.setName(string);
                            NewChainedSuffixDialog.this._suffix.setDn(string2);
                            NewChainedSuffixDialog.this._suffix.setHasRootEntry(false);
                            if (NewChainedSuffixDialog.this._parentSuffix != null) {
                                NewChainedSuffixDialog.this._suffix.setParentSuffix(NewChainedSuffixDialog.this._parentSuffix);
                                NewChainedSuffixDialog.this._parentSuffix.addChildSuffix(NewChainedSuffixDialog.this._suffix);
                            }
                        }
                        catch (LDAPException lDAPException) {
                            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                            NewChainedSuffixDialog.this.displayError("creating-suffix", stringArray);
                            NewChainedSuffixDialog.this._suffix = null;
                            bl = true;
                        }
                        if (!bl) {
                            genericProgressDialog.nextStepCompleted();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            String string3 = "cn=" + string5 + ", cn=chaining database, cn=plugins, cn=config";
                            stringArray = new String[]{"extensibleObject", "nsBackendInstance"};
                            lDAPAttributeSet = new LDAPAttributeSet();
                            lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
                            String string4 = NewChainedSuffixDialog.this._cbIsSecure.isSelected() ? "ldaps://" : "ldap://";
                            string4 = string4 + NewChainedSuffixDialog.this._tfHost.getText() + ":" + NewChainedSuffixDialog.this._tfPort.getText() + "/";
                            lDAPAttributeSet.add(new LDAPAttribute("nsfarmserverurl", string4));
                            lDAPAttributeSet.add(new LDAPAttribute("nsmultiplexorbinddn", NewChainedSuffixDialog.this._tfBindDn.getText()));
                            lDAPAttributeSet.add(new LDAPAttribute("nsmultiplexorcredentials", String.valueOf(NewChainedSuffixDialog.this._pfBindPwd.getPassword())));
                            lDAPAttributeSet.add(new LDAPAttribute("nsslapd-suffix", string));
                            LDAPEntry lDAPEntry2 = new LDAPEntry(string3, lDAPAttributeSet);
                            try {
                                lDAPConnection.add(lDAPEntry2);
                                Database database = new Database();
                                database.setName(string5);
                                database.setType(1);
                                database.setDn(string3);
                                NewChainedSuffixDialog.this._suffix.addDatabase(database);
                                database.setSuffix(NewChainedSuffixDialog.this._suffix);
                                databaseConfig.notifySuffixAdded(NewChainedSuffixDialog.this._suffix);
                            }
                            catch (LDAPException lDAPException) {
                                try {
                                    lDAPConnection.delete(string2);
                                    NewChainedSuffixDialog.this._suffix = null;
                                }
                                catch (LDAPException lDAPException2) {
                                    databaseConfig.notifySuffixAdded(NewChainedSuffixDialog.this._suffix);
                                }
                                String[] stringArray3 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                                NewChainedSuffixDialog.this.displayError("creating-database", stringArray3);
                                bl = true;
                            }
                            if (!bl) {
                                genericProgressDialog.nextStepCompleted();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        genericProgressDialog.closeCallBack();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                NewChainedSuffixDialog.access$1101(1.access$1000(this.this$1));
                            }
                        });
                    }

                    static /* synthetic */ NewChainedSuffixDialog access$1000(1 var0) {
                        return var0.NewChainedSuffixDialog.this;
                    }
                });
                thread.start();
                genericProgressDialog.packAndShow();
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-suffixexists-title", "error-suffixexists-msg", null, "newchainedsuffixdialog", _resource);
            }
        }
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void layoutContentPane() {
        String[] stringArray;
        JLabel jLabel;
        this._contentPanel = new JPanel(new GridBagLayout());
        if (this._parentSuffix == null) {
            jLabel = UIFactory.makeJLabel("newchainedsuffixdialog", "rootsuffix-ldn", _resource);
            this._tfDn = UIFactory.makeJTextField(this, "newchainedsuffixdialog", "rootsuffix-ldn", null, 20, _resource);
            jLabel.setLabelFor(this._tfDn);
        } else {
            jLabel = UIFactory.makeJLabel("newchainedsuffixdialog", "subsuffix-ldn", _resource);
            this._tfDn = UIFactory.makeJTextField(this, "newchainedsuffixdialog", "subsuffix-ldn", null, 30, _resource);
            jLabel.setLabelFor(this._tfDn);
            stringArray = new String[]{", " + this._parentSuffix.getName()};
            this._lSuffix = new JLabel(_resource.getString("newchainedsuffixdialog", "completesuffix-label", stringArray));
            this._lSuffix.setLabelFor(this._contentPanel);
        }
        stringArray = UIFactory.makeJLabel("newchainedsuffixdialog", "lhost", _resource);
        this._tfHost = UIFactory.makeJTextField(this, "newchainedsuffixdialog", "lhost", null, 30, _resource);
        stringArray.setLabelFor(this._tfHost);
        JLabel jLabel2 = UIFactory.makeJLabel("newchainedsuffixdialog", "lport", _resource);
        this._tfPort = UIFactory.makeJTextField(this, "newchainedsuffixdialog", "lport", "389", 6, _resource);
        jLabel2.setLabelFor(this._tfPort);
        this._cbIsSecure = UIFactory.makeJCheckBox(this, "newchainedsuffixdialog", "cbissecure", false, _resource);
        JLabel jLabel3 = UIFactory.makeJLabel("newchainedsuffixdialog", "lbinddn", _resource);
        this._tfBindDn = UIFactory.makeJTextField(this, "newchainedsuffixdialog", "lbinddn", null, 30, _resource);
        jLabel3.setLabelFor(this._tfBindDn);
        JLabel jLabel4 = UIFactory.makeJLabel("newchainedsuffixdialog", "lbindpwd", _resource);
        this._pfBindPwd = UIFactory.makeJPasswordField(this, "newchainedsuffixdialog", "lbindpwd", null, 30, _resource);
        jLabel4.setLabelFor(this._pfBindPwd);
        String[] stringArray2 = new String[]{""};
        this._lLdapUrl = new JLabel(_resource.getString("newchainedsuffixdialog", "lldapurl-label", stringArray2));
        this._lLdapUrl.setLabelFor(this._contentPanel);
        GroupPanel groupPanel = new GroupPanel(_resource.getString("newchainedsuffixdialog", "authenticationpanel-label"));
        GroupPanel groupPanel2 = new GroupPanel(_resource.getString("newchainedsuffixdialog", "serverinfopanel-label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this._contentPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)this._tfDn, gridBagConstraints);
        if (this._parentSuffix != null) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.left = 2;
            gridBagConstraints.insets.right = 2;
            this._contentPanel.add((Component)this._lSuffix, gridBagConstraints);
            gridBagConstraints.insets.top = 0;
        }
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel2.add((Component)stringArray, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        groupPanel2.add((Component)this._tfHost, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this._tfPort, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        jPanel.add((Component)this._cbIsSecure, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        groupPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        groupPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        groupPanel.add((Component)this._tfBindDn, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._pfBindPwd, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)groupPanel2, gridBagConstraints);
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.bottom = 0;
        this._contentPanel.add((Component)this._lLdapUrl, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this.setFocusComponent(this._tfDn);
    }

    private void checkOKButtonEnabled() {
        boolean bl = this._isDnValid && this._isHostValid && this._isPortValid && this._isBindDnValid;
        this.setOKButtonEnabled(bl);
    }

    private void updateLDAPUrl() {
        if (this._isHostValid && this._isPortValid) {
            String string = this._cbIsSecure.isSelected() ? "ldaps://" : "ldap://";
            string = string + this._tfHost.getText() + ":" + this._tfPort.getText() + "/";
            String[] stringArray = new String[]{string};
            this._lLdapUrl.setText(_resource.getString("newchainedsuffixdialog", "lldapurl-label", stringArray));
        }
    }

    private void displayError(final String string, final String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)NewChainedSuffixDialog.this._framework), "error-" + string + "-title", "error-" + string + "-msg", stringArray, "newchainedsuffixdialog", _resource);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private GenericProgressDialog createProgressDialog() {
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("newchainedsuffixdialog", "progressdialog-title"));
        genericProgressDialog.setLabelColumns(40);
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setTextInLabel(_resource.getString("newchainedsuffixdialog", "progressdialog-label"));
        genericProgressDialog.addStep(_resource.getString("newchainedsuffixdialog", "creating-suffix-label"));
        genericProgressDialog.addStep(_resource.getString("newchainedsuffixdialog", "creating-database-label"));
        return genericProgressDialog;
    }

    private boolean suffixExists(String string, DatabaseConfig databaseConfig) {
        DN dN = new DN(string);
        boolean bl = false;
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext() && !bl) {
            DN dN2 = new DN(((Suffix)listIterator.next()).getName());
            bl = dN2.equals(dN);
        }
        return bl;
    }

    static /* synthetic */ void access$1101(NewChainedSuffixDialog newChainedSuffixDialog) {
        super.okInvoked();
    }
}

