/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

class LDAPSuffixReindex
implements Runnable,
ActionListener {
    private DSFramework _framework;
    private GenericProgressDialog _dlg;
    private String _suffix;
    private String[] _indexes;
    private String _databaseName;
    private boolean _taskCancelled;
    private String _taskDn;
    private String _text;
    private static ResourceSet _resource = DSConfigPage._resource;

    public LDAPSuffixReindex(DSFramework dSFramework, String string, String[] stringArray, String string2) {
        this._framework = dSFramework;
        this._suffix = string;
        this._indexes = stringArray;
        this._databaseName = string2;
        this.createProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        String[] stringArray;
        boolean bl = false;
        try {
            this.initTask();
        }
        catch (LDAPException lDAPException) {
            bl = true;
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)LDAPSuffixReindex.this._framework), "error-launching-title", "error-launching-msg", stringArray, "ldapsuffixreindex", _resource);
                }
            });
        }
        if (!bl) {
            try {
                this.updateProgressDialog();
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)LDAPSuffixReindex.this._framework), "error-updating-dialog-title", "error-updating-dialog-msg", stringArray, "ldapsuffixreindex", _resource);
                    }
                });
            }
            this._dlg.waitForClose();
        } else {
            this._dlg.closeCallBack();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("ldapsuffixreindex", "cancelling-label"));
            this._taskCancelled = true;
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsTaskCancel", "true"));
            try {
                lDAPConnection.modify(this._taskDn, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-cancelling-title", "error-cancelling-msg", stringArray, "ldapsuffixreindex", _resource);
            }
            this._dlg.setTextInLabel(_resource.getString("ldapsuffixreindex", "cancelled-label"));
            this._dlg.waitForClose();
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    private void createProgressDialog() {
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("ldapsuffixreindex", "title"), null, this);
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix, 40)};
        this._text = _resource.getString("ldapsuffixreindex", "reindexing-label", stringArray);
        this._dlg.setTextInLabel(this._text);
        this._dlg.setLabelRows(2);
        this._dlg.disableCancelButton();
        this._dlg.setTextInTextAreaLabel(_resource.getString("ldapsuffixreindex", "logs-label"));
        this._dlg.setTextAreaRows(5);
    }

    private void initTask() throws LDAPException {
        this._taskCancelled = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
        lDAPAttributeSet.add(new LDAPAttribute("nsInstance", this._databaseName));
        lDAPAttributeSet.add(new LDAPAttribute("nsIndexAttribute", this._indexes));
        lDAPAttributeSet.add(new LDAPAttribute("ttl", "8"));
        this._taskDn = "cn=index" + System.currentTimeMillis() + ", cn=index, cn=tasks, cn=config";
        LDAPEntry lDAPEntry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected void updateProgressDialog() throws LDAPException {
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        while (!bl && !this._taskCancelled) {
            String[] stringArray;
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String[] stringArray2;
                LDAPEntry lDAPEntry = lDAPConnection.read(this._taskDn);
                stringArray = DSUtil.getAttrValue(lDAPEntry, "nsTaskLog");
                int n = stringArray.lastIndexOf("Indexing attribute:");
                if (n >= 0) {
                    boolean bl2 = false;
                    stringArray2 = stringArray.substring(n + 20);
                    int n2 = 0;
                    while (n2 < this._indexes.length && !bl2) {
                        if (stringArray2.startsWith(this._indexes[n2])) {
                            bl2 = true;
                            String[] stringArray3 = new String[]{DSUtil.abreviateString((String)stringArray2, 40), String.valueOf(n2 + 1), String.valueOf(this._indexes.length)};
                            String string = this._text + "\n" + _resource.getString("ldapsuffixreindex", "attribute-label", stringArray3);
                            this._dlg.setTextInLabel(string);
                        }
                        ++n2;
                    }
                }
                this._dlg.setTextInTextArea((String)stringArray);
                String string = DSUtil.getAttrValue(lDAPEntry, "nsTaskExitCode");
                if (string.equals("")) continue;
                bl = true;
                stringArray2 = new String[]{DSUtil.abreviateString(this._suffix, 40)};
                if (string.equals("0")) {
                    this._dlg.setTextInLabel(_resource.getString("ldapsuffixreindex", "successful-label", stringArray2));
                    continue;
                }
                this._dlg.setTextInLabel(_resource.getString("ldapsuffixreindex", "unsuccessful-label", stringArray2));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                bl = true;
                stringArray = new String[]{DSUtil.abreviateString(this._suffix, 40)};
                this._dlg.setTextInLabel(_resource.getString("ldapsuffixreindex", "successful-label", stringArray));
            }
        }
    }
}

