/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigSchemaAttributesPanel;
import com.netscape.admin.dirserv.config.ConfigSchemaMatchingRulesPanel;
import com.netscape.admin.dirserv.config.ConfigSchemaObjectClassesPanel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.IConfigPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class ConfigSchemaTabbedPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private DSFramework _framework;
    private JPanel _contentPanel;
    private JPanel _statePanel;
    private JPanel _disabledPanel;
    private JPanel _enabledPanel;
    private JTabbedPane _tabbedPane;
    private JButton _bEnableSchema;
    private JButton _bDisableSchema;
    private boolean _isInitialized;
    private boolean _isInitializing;
    private final JLabel RESETTING_LABEL = UIFactory.makeJLabel("schematabbedpanel", "resetting", _resource);
    private static ResourceSet _resource = DSConfigPage._resource;

    public ConfigSchemaTabbedPanel(DSFramework dSFramework) {
        this.basicLayout();
        this._framework = dSFramework;
        this.addTab(new ConfigSchemaObjectClassesPanel());
        this.addTab(new ConfigSchemaAttributesPanel());
        this.addTab(new ConfigSchemaMatchingRulesPanel());
        this.refreshPanel();
    }

    public void refreshPanel() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.RESETTING_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Object object;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (ConfigSchemaTabbedPanel.this._isInitialized) {
                        DSUtil.setSchema(ConfigSchemaTabbedPanel.this._framework.getServerObject().getServerInfo(), null);
                        DSUtil.getSchema(ConfigSchemaTabbedPanel.this._framework.getServerObject().getServerInfo());
                        int n = ConfigSchemaTabbedPanel.this._tabbedPane.getTabCount();
                        int n2 = 0;
                        while (n2 < n) {
                            object = (IConfigPanel)((Object)ConfigSchemaTabbedPanel.this._tabbedPane.getComponentAt(n2));
                            if (object.isInitialized()) {
                                object.resetCallback();
                            }
                            ++n2;
                        }
                    }
                    LDAPConnection lDAPConnection = ConfigSchemaTabbedPanel.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    String[] stringArray = new String[]{"nsslapd-schemacheck"};
                    try {
                        object = lDAPConnection.read("cn=config", stringArray);
                        boolean bl = !DSUtil.getAttrValue((LDAPEntry)object, stringArray[0]).equalsIgnoreCase("off");
                        SwingUtilities.invokeLater(new Runnable(this, bl){
                            private final /* synthetic */ boolean val$schemaEnabled;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$schemaEnabled = bl;
                            }

                            public void run() {
                                if (this.val$schemaEnabled) {
                                    if (!ConfigSchemaTabbedPanel.access$500(1.access$300(this.this$1)).isAncestorOf(ConfigSchemaTabbedPanel.access$400(1.access$300(this.this$1)))) {
                                        ConfigSchemaTabbedPanel.access$500(1.access$300(this.this$1)).removeAll();
                                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                                        gridBagConstraints.fill = 2;
                                        gridBagConstraints.weightx = 1.0;
                                        ConfigSchemaTabbedPanel.access$500(1.access$300(this.this$1)).add((Component)ConfigSchemaTabbedPanel.access$400(1.access$300(this.this$1)), gridBagConstraints);
                                    }
                                } else if (!ConfigSchemaTabbedPanel.access$500(1.access$300(this.this$1)).isAncestorOf(ConfigSchemaTabbedPanel.access$600(1.access$300(this.this$1)))) {
                                    ConfigSchemaTabbedPanel.access$500(1.access$300(this.this$1)).removeAll();
                                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                                    gridBagConstraints.fill = 2;
                                    gridBagConstraints.weightx = 1.0;
                                    ConfigSchemaTabbedPanel.access$500(1.access$300(this.this$1)).add((Component)ConfigSchemaTabbedPanel.access$600(1.access$300(this.this$1)), gridBagConstraints);
                                }
                                ConfigSchemaTabbedPanel.access$800(1.access$300(this.this$1), ConfigSchemaTabbedPanel.access$700(1.access$300(this.this$1)), false);
                                if (!ConfigSchemaTabbedPanel.access$000(1.access$300(this.this$1))) {
                                    ConfigSchemaTabbedPanel.access$002(1.access$300(this.this$1), true);
                                    ConfigSchemaTabbedPanel.access$200(1.access$300(this.this$1)).setSelectedIndex(0);
                                }
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.weightx = 1.0;
                        String[] stringArray2 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = _resource.getString("schematabbedpanel-error-reading", "label", stringArray2);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                ConfigSchemaTabbedPanel.access$800(1.access$300(this.this$1), (JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigSchemaTabbedPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigSchemaTabbedPanel access$300(1 var0) {
                    return var0.ConfigSchemaTabbedPanel.this;
                }
            });
            thread.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bEnableSchema) {
            this.actionEnableSchema();
        } else if (object == this._bDisableSchema) {
            this.actionDisableSchema();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        IConfigPanel iConfigPanel;
        if (changeEvent.getSource() == this._tabbedPane && !(iConfigPanel = (IConfigPanel)((Object)this._tabbedPane.getSelectedComponent())).isInitialized()) {
            iConfigPanel.setFramework(this._framework);
            iConfigPanel.init();
        }
    }

    private void addTab(IConfigPanel iConfigPanel) {
        this._tabbedPane.addTab(iConfigPanel.getTitle(), (JComponent)((Object)iConfigPanel));
    }

    private void showComponent(JComponent jComponent, boolean bl) {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        if (bl) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        } else {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this.add((Component)jComponent, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void basicLayout() {
        this.setLayout(new GridBagLayout());
        this._contentPanel = new JPanel(new GridBagLayout());
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addChangeListener(this);
        this._statePanel = new JPanel(new GridBagLayout());
        this._disabledPanel = new JPanel(new GridBagLayout());
        this._enabledPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("schematabbedpanel", "lschemaenabled", _resource);
        jLabel.setLabelFor(this._enabledPanel);
        this._bDisableSchema = UIFactory.makeJButton(this, "schematabbedpanel", "bdisableschema", _resource);
        JLabel jLabel2 = UIFactory.makeJLabel("schematabbedpanel", "lschemadisabled", _resource);
        jLabel2.setLabelFor(this._disabledPanel);
        this._bEnableSchema = UIFactory.makeJButton(this, "schematabbedpanel", "benableschema", _resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this._enabledPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this._enabledPanel.add((Component)this._bDisableSchema, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this._disabledPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this._disabledPanel.add((Component)this._bEnableSchema, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)this._statePanel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add((Component)this._tabbedPane, gridBagConstraints);
        this.showComponent(this._contentPanel, false);
    }

    private void actionEnableSchema() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsslapd-schemacheck", "on"));
        try {
            lDAPConnection.modify("cn=config", lDAPModification);
            this._statePanel.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this._statePanel.add((Component)this._enabledPanel, gridBagConstraints);
            this._statePanel.validate();
            this._statePanel.repaint();
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-enabling-title", "error-enabling-msg", stringArray, "schematabbedpanel", _resource);
        }
    }

    private void actionDisableSchema() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsslapd-schemacheck", "off"));
        try {
            lDAPConnection.modify("cn=config", lDAPModification);
            this._statePanel.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this._statePanel.add((Component)this._disabledPanel, gridBagConstraints);
            this._statePanel.validate();
            this._statePanel.repaint();
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-disabling-title", "error-disabling-msg", stringArray, "schematabbedpanel", _resource);
        }
    }

    static /* synthetic */ JPanel access$400(ConfigSchemaTabbedPanel configSchemaTabbedPanel) {
        return configSchemaTabbedPanel._enabledPanel;
    }

    static /* synthetic */ JPanel access$500(ConfigSchemaTabbedPanel configSchemaTabbedPanel) {
        return configSchemaTabbedPanel._statePanel;
    }

    static /* synthetic */ JPanel access$600(ConfigSchemaTabbedPanel configSchemaTabbedPanel) {
        return configSchemaTabbedPanel._disabledPanel;
    }

    static /* synthetic */ JPanel access$700(ConfigSchemaTabbedPanel configSchemaTabbedPanel) {
        return configSchemaTabbedPanel._contentPanel;
    }

    static /* synthetic */ void access$800(ConfigSchemaTabbedPanel configSchemaTabbedPanel, JComponent jComponent, boolean bl) {
        configSchemaTabbedPanel.showComponent(jComponent, bl);
    }

    static /* synthetic */ boolean access$002(ConfigSchemaTabbedPanel configSchemaTabbedPanel, boolean bl) {
        configSchemaTabbedPanel._isInitialized = bl;
        return configSchemaTabbedPanel._isInitialized;
    }
}

