/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.SnmpCtrl;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ConfigSNMPSettingsPanel
extends ConfigBasePanel
implements ActionListener {
    private boolean _isNT;
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isCancelled;
    private JPanel _contentPanel;
    private JCheckBox _cbEnableSNMP;
    private JTextField _tfMasterHost;
    private JLabel _lMasterHost;
    private JTextField _tfMasterPort;
    private JLabel _lMasterPort;
    private JTextField _tfDescription;
    private JLabel _lDescription;
    private JTextField _tfOrganization;
    private JLabel _lOrganization;
    private JTextField _tfLocation;
    private JLabel _lLocation;
    private JTextField _tfContact;
    private JLabel _lContact;
    private JButton _bStartAgent;
    private JButton _bStopAgent;
    private JButton _bRestartAgent;
    private boolean _saveEnableSNMP;
    private String _saveMasterHost;
    private int _saveMasterPort;
    private String _saveDescription;
    private String _saveOrganization;
    private String _saveLocation;
    private String _saveContact;
    private boolean _isEnableSNMPDirty;
    private boolean _isMasterHostDirty;
    private boolean _isMasterHostValid;
    private boolean _isMasterPortDirty;
    private boolean _isMasterPortValid;
    private boolean _isDescriptionDirty;
    private boolean _isOrganizationDirty;
    private boolean _isLocationDirty;
    private boolean _isContactDirty;
    private static final int PORT_NOT_DEFINED = -1;
    private static final int PORT_DEFAULT_VALUE = 199;
    private static final String HOST_DEFAULT_VALUE = "localhost";
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("snmpsettingspanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("snmpsettingspanel-no-rights", "label"), 2, 50);

    public ConfigSNMPSettingsPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("snmpsettingspanel", "title"));
        this._helpToken = "configuration-system-snmp-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this._isNT = DSUtil.isNT(this.getServerInfo());
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigSNMPSettingsPanel.this.createContentPanel();
                        ConfigSNMPSettingsPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigSNMPSettingsPanel.access$300(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigSNMPSettingsPanel.access$400(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{"nssnmpmasterport"};
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("snmpsettingspanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigSNMPSettingsPanel.access$500(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("snmpsettingspanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigSNMPSettingsPanel.this._isInitialized = true;
                    ConfigSNMPSettingsPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigSNMPSettingsPanel access$200(1 var0) {
                    return var0.ConfigSNMPSettingsPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSNMPSettingsPanel.this.initComponentsFromServerValues();
                    ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                    ConfigSNMPSettingsPanel.this.showComponent(ConfigSNMPSettingsPanel.this._contentPanel, false);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{"nssnmpmasterport"};
                    ConfigSNMPSettingsPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("snmpsettingspanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSNMPSettingsPanel.this.showComponent((JComponent)ConfigSNMPSettingsPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("snmpsettingspanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSNMPSettingsPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        String string;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isEnableSNMPDirty) {
            string = this._cbEnableSNMP.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPEnabled", string));
        }
        if (this._cbEnableSNMP.isSelected()) {
            if (!this._isNT) {
                if (this._isMasterHostDirty) {
                    string = this._tfMasterHost.getText();
                    lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPMasterHost", string));
                }
                if (this._isMasterPortDirty) {
                    string = this._tfMasterPort.getText();
                    lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPMasterPort", string));
                }
            }
            if (this._isDescriptionDirty) {
                string = this._tfDescription.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPDescription", string));
            }
            if (this._isOrganizationDirty) {
                string = this._tfOrganization.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPOrganization", string));
            }
            if (this._isLocationDirty) {
                string = this._tfLocation.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPLocation", string));
            }
            if (this._isContactDirty) {
                string = this._tfContact.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsSNMPContact", string));
            }
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                this.getServerInfo().getLDAPConnection().modify("cn=SNMP, cn=config", lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("snmpsettingspanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("snmpsettingspanel", "updating-server-error-msg", stringArray));
            }
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbEnableSNMP) {
            this._isEnableSNMPDirty = this._cbEnableSNMP.isSelected() != this._saveEnableSNMP;
            this.enableFields(this._cbEnableSNMP.isSelected());
            if (this._isEnableSNMPDirty) {
                BlankPanel.setChangeState(this._cbEnableSNMP, 2);
            } else {
                BlankPanel.setChangeState(this._cbEnableSNMP, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._bStartAgent) {
            boolean bl;
            boolean bl2 = true;
            boolean bl3 = bl = this._isEnableSNMPDirty || this._cbEnableSNMP.isSelected() && (this._isMasterHostDirty || this._isMasterPortDirty || this._isDescriptionDirty || this._isOrganizationDirty || this._isLocationDirty || this._isContactDirty);
            if (bl) {
                bl2 = this.askForStartConfirmation();
            }
            if (bl2) {
                String string = this._isNT ? "snmp" : "agent";
                this.executeAction("START", ConfigBasePanel._resource.getString("snmpsettingspanel", "starting" + string + "-title"));
            }
        } else if (object == this._bStopAgent) {
            String string = this._isNT ? "snmp" : "agent";
            this.executeAction("STOP", ConfigBasePanel._resource.getString("snmpsettingspanel", "stopping" + string + "-title"));
        } else if (object == this._bRestartAgent) {
            boolean bl;
            boolean bl4 = true;
            boolean bl5 = bl = this._isEnableSNMPDirty || this._cbEnableSNMP.isSelected() && (this._isMasterHostDirty || this._isMasterPortDirty || this._isDescriptionDirty || this._isOrganizationDirty || this._isLocationDirty || this._isContactDirty);
            if (bl) {
                bl4 = this.askForStartConfirmation();
            }
            if (bl4) {
                String string = this._isNT ? "snmp" : "agent";
                this.executeAction("RESTART", ConfigBasePanel._resource.getString("snmpsettingspanel", "restarting" + string + "-title"));
            }
        }
    }

    private void createContentPanel() {
        JComponent[] jComponentArray;
        JComponent[] jComponentArray2;
        JButton[] jButtonArray;
        DocumentListener documentListener;
        DocumentListener documentListener2;
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbEnableSNMP = UIFactory.makeJCheckBox(this, "snmpsettingspanel", "cbenablesnmp", false, ConfigBasePanel._resource);
        if (!this._isNT) {
            documentListener2 = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!ConfigSNMPSettingsPanel.this._isInitializingComponents) {
                        String string = ConfigSNMPSettingsPanel.this._tfMasterHost.getText();
                        ConfigSNMPSettingsPanel.this._isMasterHostValid = string.length() > 0;
                        ConfigSNMPSettingsPanel.this._isMasterHostDirty = !string.equals(ConfigSNMPSettingsPanel.this._saveMasterHost);
                        ConfigSNMPSettingsPanel.this.updateColoring(ConfigSNMPSettingsPanel.this._lMasterHost, ConfigSNMPSettingsPanel.this._isMasterHostValid, ConfigSNMPSettingsPanel.this._isMasterHostDirty);
                        ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                    }
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
            this._lMasterHost = UIFactory.makeJLabel("snmpsettingspanel", "lmasterhost", ConfigBasePanel._resource);
            this._tfMasterHost = UIFactory.makeJTextField(documentListener2, "snmpsettingspanel", "lmasterhost", null, 20, ConfigBasePanel._resource);
            this._lMasterHost.setLabelFor(this._tfMasterHost);
            documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!ConfigSNMPSettingsPanel.this._isInitializingComponents) {
                        try {
                            int n = Integer.parseInt(ConfigSNMPSettingsPanel.this._tfMasterPort.getText());
                            ConfigSNMPSettingsPanel.this._isMasterPortValid = n > 0 && n <= 65535;
                            ConfigSNMPSettingsPanel.this._isMasterPortDirty = n != ConfigSNMPSettingsPanel.this._saveMasterPort;
                        }
                        catch (NumberFormatException numberFormatException) {
                            ConfigSNMPSettingsPanel.this._isMasterPortValid = false;
                            ConfigSNMPSettingsPanel.this._isMasterPortDirty = true;
                        }
                        ConfigSNMPSettingsPanel.this.updateColoring(ConfigSNMPSettingsPanel.this._lMasterPort, ConfigSNMPSettingsPanel.this._isMasterPortValid, ConfigSNMPSettingsPanel.this._isMasterPortDirty);
                        ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                    }
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
            this._lMasterPort = UIFactory.makeJLabel("snmpsettingspanel", "lmasterport", ConfigBasePanel._resource);
            this._tfMasterPort = UIFactory.makeJTextField(documentListener, "snmpsettingspanel", "lmasterport", null, 5, ConfigBasePanel._resource);
            this._lMasterPort.setLabelFor(this._tfMasterPort);
        }
        documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigSNMPSettingsPanel.this._isInitializingComponents) {
                    ConfigSNMPSettingsPanel.this._isDescriptionDirty = !ConfigSNMPSettingsPanel.this._tfDescription.getText().equals(ConfigSNMPSettingsPanel.this._saveDescription);
                    ConfigSNMPSettingsPanel.this.updateColoring(ConfigSNMPSettingsPanel.this._lDescription, true, ConfigSNMPSettingsPanel.this._isDescriptionDirty);
                    ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lDescription = UIFactory.makeJLabel("snmpsettingspanel", "ldescription", ConfigBasePanel._resource);
        this._tfDescription = UIFactory.makeJTextField(documentListener2, "snmpsettingspanel", "ldescription", null, 20, ConfigBasePanel._resource);
        this._lDescription.setLabelFor(this._tfDescription);
        documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigSNMPSettingsPanel.this._isInitializingComponents) {
                    ConfigSNMPSettingsPanel.this._isOrganizationDirty = !ConfigSNMPSettingsPanel.this._tfOrganization.getText().equals(ConfigSNMPSettingsPanel.this._saveOrganization);
                    ConfigSNMPSettingsPanel.this.updateColoring(ConfigSNMPSettingsPanel.this._lOrganization, true, ConfigSNMPSettingsPanel.this._isOrganizationDirty);
                    ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lOrganization = UIFactory.makeJLabel("snmpsettingspanel", "lorganization", ConfigBasePanel._resource);
        this._tfOrganization = UIFactory.makeJTextField(documentListener, "snmpsettingspanel", "lorganization", null, 20, ConfigBasePanel._resource);
        this._lOrganization.setLabelFor(this._tfOrganization);
        DocumentListener documentListener3 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigSNMPSettingsPanel.this._isInitializingComponents) {
                    ConfigSNMPSettingsPanel.this._isLocationDirty = !ConfigSNMPSettingsPanel.this._tfLocation.getText().equals(ConfigSNMPSettingsPanel.this._saveLocation);
                    ConfigSNMPSettingsPanel.this.updateColoring(ConfigSNMPSettingsPanel.this._lLocation, true, ConfigSNMPSettingsPanel.this._isLocationDirty);
                    ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lLocation = UIFactory.makeJLabel("snmpsettingspanel", "llocation", ConfigBasePanel._resource);
        this._tfLocation = UIFactory.makeJTextField(documentListener3, "snmpsettingspanel", "llocation", null, 20, ConfigBasePanel._resource);
        this._lLocation.setLabelFor(this._tfLocation);
        DocumentListener documentListener4 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigSNMPSettingsPanel.this._isInitializingComponents) {
                    ConfigSNMPSettingsPanel.this._isContactDirty = !ConfigSNMPSettingsPanel.this._tfContact.getText().equals(ConfigSNMPSettingsPanel.this._saveContact);
                    ConfigSNMPSettingsPanel.this.updateColoring(ConfigSNMPSettingsPanel.this._lContact, true, ConfigSNMPSettingsPanel.this._isContactDirty);
                    ConfigSNMPSettingsPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lContact = UIFactory.makeJLabel("snmpsettingspanel", "lcontact", ConfigBasePanel._resource);
        this._tfContact = UIFactory.makeJTextField(documentListener4, "snmpsettingspanel", "lcontact", null, 20, ConfigBasePanel._resource);
        this._lContact.setLabelFor(this._tfContact);
        String string = this._isNT ? "snmp" : "agent";
        this._bStartAgent = UIFactory.makeJButton(this, "snmpsettingspanel", "subagent-start" + string, ConfigBasePanel._resource);
        this._bStopAgent = UIFactory.makeJButton(this, "snmpsettingspanel", "subagent-stop" + string, ConfigBasePanel._resource);
        this._bRestartAgent = UIFactory.makeJButton(this, "snmpsettingspanel", "subagent-restart" + string, ConfigBasePanel._resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 16, 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)this._cbEnableSNMP, gridBagConstraints);
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("snmpsettingspanel", "descriptionpanel-label"));
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        if (!this._isNT) {
            jButtonArray = new GroupPanel(ConfigBasePanel._resource.getString("snmpsettingspanel", "masterpanel-label"));
            this._contentPanel.add((Component)jButtonArray, gridBagConstraints);
            jComponentArray2 = new JComponent[]{this._lMasterHost, this._tfMasterHost};
            this.addLine((Container)jButtonArray, jComponentArray2, true);
            jComponentArray = new JComponent[]{this._lMasterPort, this._tfMasterPort};
            this.addLine((Container)jButtonArray, jComponentArray);
        }
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        jButtonArray = new JButton[]{this._bStartAgent, this._bStopAgent, this._bRestartAgent};
        jComponentArray2 = UIFactory.makeJButtonPanel(jButtonArray);
        gridBagConstraints.weightx = 0.0;
        this._contentPanel.add((Component)jComponentArray2, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        jComponentArray = new JComponent[]{this._lDescription, this._tfDescription};
        this.addLine(groupPanel, jComponentArray, true);
        JComponent[] jComponentArray3 = new JComponent[]{this._lOrganization, this._tfOrganization};
        this.addLine(groupPanel, jComponentArray3, true);
        JComponent[] jComponentArray4 = new JComponent[]{this._lLocation, this._tfLocation};
        this.addLine(groupPanel, jComponentArray4, true);
        JComponent[] jComponentArray5 = new JComponent[]{this._lContact, this._tfContact};
        this.addLine(groupPanel, jComponentArray5, true);
    }

    private void readDataFromServer() throws LDAPException, NumberFormatException {
        String[] stringArray = new String[]{"nsSNMPEnabled", "nsSNMPMasterHost", "nsSNMPMasterPort", "nsSNMPDescription", "nsSNMPOrganization", "nsSNMPLocation", "nsSNMPContact"};
        LDAPEntry lDAPEntry = this.getServerInfo().getLDAPConnection().read("cn=SNMP, cn=config", stringArray);
        this._saveEnableSNMP = this.getValue(lDAPEntry, "nsSNMPEnabled").equalsIgnoreCase("on");
        this._saveMasterHost = DSUtil.getAttrValue(lDAPEntry, "nsSNMPMasterHost");
        String string = DSUtil.getAttrValue(lDAPEntry, "nsSNMPMasterPort").trim();
        this._saveMasterPort = string.length() > 0 ? Integer.parseInt(string) : -1;
        this._saveDescription = DSUtil.getAttrValue(lDAPEntry, "nsSNMPDescription");
        this._saveOrganization = DSUtil.getAttrValue(lDAPEntry, "nsSNMPOrganization");
        this._saveLocation = DSUtil.getAttrValue(lDAPEntry, "nsSNMPLocation");
        this._saveContact = DSUtil.getAttrValue(lDAPEntry, "nsSNMPContact");
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._cbEnableSNMP.setSelected(this._saveEnableSNMP);
        BlankPanel.setChangeState(this._cbEnableSNMP, 1);
        this._isEnableSNMPDirty = false;
        if (!this._isNT) {
            if (this._saveMasterHost.length() > 0) {
                this._tfMasterHost.setText(this._saveMasterHost);
                BlankPanel.setChangeState(this._lMasterHost, 1);
                this._isMasterHostDirty = false;
            } else {
                BlankPanel.setChangeState(this._lMasterHost, 2);
                this._tfMasterHost.setText(HOST_DEFAULT_VALUE);
                this._isMasterHostDirty = true;
            }
            this._isMasterHostValid = true;
            if (this._saveMasterPort != -1) {
                this._tfMasterPort.setText(Integer.toString(this._saveMasterPort));
                BlankPanel.setChangeState(this._lMasterPort, 1);
                this._isMasterPortDirty = false;
            } else {
                this._tfMasterPort.setText(Integer.toString(199));
                BlankPanel.setChangeState(this._lMasterPort, 2);
                this._isMasterPortDirty = true;
            }
            this._isMasterPortValid = true;
        } else {
            this._isMasterHostDirty = false;
            this._isMasterHostValid = true;
            this._isMasterPortDirty = false;
            this._isMasterPortValid = true;
        }
        this._tfDescription.setText(this._saveDescription);
        BlankPanel.setChangeState(this._lDescription, 1);
        this._isDescriptionDirty = false;
        this._tfOrganization.setText(this._saveOrganization);
        BlankPanel.setChangeState(this._lOrganization, 1);
        this._isOrganizationDirty = false;
        this._tfLocation.setText(this._saveLocation);
        BlankPanel.setChangeState(this._lLocation, 1);
        this._isLocationDirty = false;
        this._tfContact.setText(this._saveContact);
        BlankPanel.setChangeState(this._lContact, 1);
        this._isContactDirty = false;
        this._bStartAgent.setEnabled(this._saveEnableSNMP);
        this._bRestartAgent.setEnabled(this._saveEnableSNMP);
        this.enableFields(this._saveEnableSNMP);
        this._isInitializingComponents = false;
    }

    private void enableFields(boolean bl) {
        if (!this._isNT) {
            this._tfMasterHost.setEnabled(bl);
            this._lMasterHost.setEnabled(bl);
            this._tfMasterPort.setEnabled(bl);
            this._lMasterPort.setEnabled(bl);
        }
        this._tfDescription.setEnabled(bl);
        this._lDescription.setEnabled(bl);
        this._tfOrganization.setEnabled(bl);
        this._lOrganization.setEnabled(bl);
        this._tfLocation.setEnabled(bl);
        this._lLocation.setEnabled(bl);
        this._tfContact.setEnabled(bl);
        this._lContact.setEnabled(bl);
    }

    private void updateColoring(JLabel jLabel, boolean bl, boolean bl2) {
        if (!bl) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (bl2) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
    }

    private void executeAction(final String string, String string2) {
        Container container = this.getParent();
        while (!(container instanceof DSFramework)) {
            container = container.getParent();
        }
        DSFramework dSFramework = (DSFramework)((Object)container);
        dSFramework.setBusyCursor(true);
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)dSFramework), false, 1, string2);
        String string3 = ConfigBasePanel._resource.getString("snmpsettingspanel", "progressdialog-label");
        genericProgressDialog.setTextInLabel(string3);
        genericProgressDialog.setLabelColumns(30);
        genericProgressDialog.setLabelRows(1);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                SnmpCtrl snmpCtrl = new SnmpCtrl(string, ConfigSNMPSettingsPanel.this.getServerInfo());
                snmpCtrl.exec();
                genericProgressDialog.closeCallBack();
            }
        });
        thread.start();
        genericProgressDialog.packAndShow();
        dSFramework.setBusyCursor(false);
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = !this._cbEnableSNMP.isSelected() || this._isMasterHostValid && this._isMasterPortValid;
        boolean bl3 = bl = this._isEnableSNMPDirty || this._cbEnableSNMP.isSelected() && (this._isMasterHostDirty || this._isMasterPortDirty || this._isDescriptionDirty || this._isOrganizationDirty || this._isLocationDirty || this._isContactDirty);
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private void addLine(Container container, JComponent[] jComponentArray) {
        this.addLine(container, jComponentArray, false);
    }

    private void addLine(Container container, JComponent[] jComponentArray, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = bl ? jComponentArray.length : jComponentArray.length + 1;
        container.add((Component)jComponentArray[0], gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        int n = 1;
        while (n < jComponentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            container.add((Component)jComponentArray[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        int n2 = gridBagConstraints.gridwidth = bl ? 0 : -1;
        if (bl) {
            gridBagConstraints.weightx = 1.0;
        }
        container.add((Component)jComponentArray[jComponentArray.length - 1], gridBagConstraints);
        if (!bl) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.gridwidth = 0;
            container.add(Box.createHorizontalGlue(), gridBagConstraints);
        }
    }

    private boolean askForStartConfirmation() {
        String string = this._isNT ? "startwithserverdata-nt" : "startwithserverdata";
        int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), string, (String[])null, "snmpsettingspanel", ConfigBasePanel._resource);
        return n == 0;
    }
}

